/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.bridge.util.impl.BridgeAdaptorUtils;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;

public class FieldHelper {
    private static final Pattern DOT = Pattern.compile("\\.");

    private FieldHelper() {
    }

    private static NumericFieldSettingsDescriptor.NumericEncodingType getNumericEncodingType(DocumentFieldMetadata field) {
        BridgeDefinedField bridgeDefinedField;
        NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType = field.getNumericEncodingType();
        if (numericEncodingType == NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN && (bridgeDefinedField = (BridgeDefinedField)field.getBridgeDefinedFields().get(field.getAbsoluteName())) != null) {
            numericEncodingType = FieldHelper.getNumericEncodingType(bridgeDefinedField.getType());
        }
        return numericEncodingType;
    }

    private static NumericFieldSettingsDescriptor.NumericEncodingType getNumericEncodingType(FieldType fieldType) {
        switch (fieldType) {
            case FLOAT: {
                return NumericFieldSettingsDescriptor.NumericEncodingType.FLOAT;
            }
            case DOUBLE: {
                return NumericFieldSettingsDescriptor.NumericEncodingType.DOUBLE;
            }
            case INTEGER: {
                return NumericFieldSettingsDescriptor.NumericEncodingType.INTEGER;
            }
            case LONG: {
                return NumericFieldSettingsDescriptor.NumericEncodingType.LONG;
            }
        }
        return NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN;
    }

    private static ExtendedFieldType toExtendedFieldType(NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType) {
        switch (numericEncodingType) {
            case INTEGER: {
                return ExtendedFieldType.INTEGER;
            }
            case LONG: {
                return ExtendedFieldType.LONG;
            }
            case FLOAT: {
                return ExtendedFieldType.FLOAT;
            }
            case DOUBLE: {
                return ExtendedFieldType.DOUBLE;
            }
        }
        return ExtendedFieldType.UNKNOWN_NUMERIC;
    }

    public static ExtendedFieldType getType(DocumentFieldMetadata fieldMetadata) {
        Class propertyClass;
        BridgeDefinedField overriddenField = (BridgeDefinedField)fieldMetadata.getBridgeDefinedFields().get(fieldMetadata.getAbsoluteName());
        if (overriddenField != null) {
            return FieldHelper.getType(overriddenField);
        }
        PropertyMetadata propertyMetata = fieldMetadata.getSourceProperty();
        Class clazz = propertyClass = propertyMetata == null ? null : propertyMetata.getPropertyClass();
        if (propertyClass == null) {
            return ExtendedFieldType.UNKNOWN;
        }
        if (Boolean.TYPE.equals(propertyClass) || Boolean.class.isAssignableFrom(propertyClass)) {
            return ExtendedFieldType.BOOLEAN;
        }
        if (FieldHelper.isNumeric(fieldMetadata)) {
            return FieldHelper.toExtendedFieldType(FieldHelper.getNumericEncodingType(fieldMetadata));
        }
        if (Date.class.isAssignableFrom(propertyClass)) {
            return ExtendedFieldType.DATE;
        }
        if (Calendar.class.isAssignableFrom(propertyClass)) {
            return ExtendedFieldType.CALENDAR;
        }
        if ("java.time.Instant".equals(propertyClass.getName())) {
            return ExtendedFieldType.INSTANT;
        }
        if ("java.time.LocalDate".equals(propertyClass.getName())) {
            return ExtendedFieldType.LOCAL_DATE;
        }
        if ("java.time.LocalTime".equals(propertyClass.getName())) {
            return ExtendedFieldType.LOCAL_TIME;
        }
        if ("java.time.LocalDateTime".equals(propertyClass.getName())) {
            return ExtendedFieldType.LOCAL_DATE_TIME;
        }
        if ("java.time.OffsetDateTime".equals(propertyClass.getName())) {
            return ExtendedFieldType.OFFSET_DATE_TIME;
        }
        if ("java.time.OffsetTime".equals(propertyClass.getName())) {
            return ExtendedFieldType.OFFSET_TIME;
        }
        if ("java.time.ZonedDateTime".equals(propertyClass.getName())) {
            return ExtendedFieldType.ZONED_DATE_TIME;
        }
        if ("java.time.Year".equals(propertyClass.getName())) {
            return ExtendedFieldType.YEAR;
        }
        if ("java.time.YearMonth".equals(propertyClass.getName())) {
            return ExtendedFieldType.YEAR_MONTH;
        }
        if ("java.time.MonthDay".equals(propertyClass.getName())) {
            return ExtendedFieldType.MONTH_DAY;
        }
        return ExtendedFieldType.UNKNOWN;
    }

    public static ExtendedFieldType getType(BridgeDefinedField field) {
        FieldType type = field.getType();
        if (type == null) {
            return null;
        }
        switch (type) {
            case BOOLEAN: {
                return ExtendedFieldType.BOOLEAN;
            }
            case DATE: {
                return ExtendedFieldType.DATE;
            }
            case DOUBLE: {
                return ExtendedFieldType.DOUBLE;
            }
            case FLOAT: {
                return ExtendedFieldType.FLOAT;
            }
            case INTEGER: {
                return ExtendedFieldType.INTEGER;
            }
            case LONG: {
                return ExtendedFieldType.LONG;
            }
            case STRING: {
                return ExtendedFieldType.STRING;
            }
            case OBJECT: {
                return ExtendedFieldType.OBJECT;
            }
        }
        return ExtendedFieldType.UNKNOWN;
    }

    public static boolean isNumeric(DocumentFieldMetadata field) {
        if (field.isNumeric()) {
            return true;
        }
        FieldBridge fieldBridge = field.getFieldBridge();
        return BridgeAdaptorUtils.unwrapAdaptorOnly((Object)fieldBridge, NumericFieldBridge.class) != null;
    }

    public static String[] getFieldNameParts(String fieldName) {
        String[] stringArray;
        boolean isEmbeddedField = FieldHelper.isEmbeddedField(fieldName);
        if (isEmbeddedField) {
            stringArray = DOT.split(fieldName);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fieldName;
        }
        return stringArray;
    }

    public static boolean isSortableField(TypeMetadata sourceType, PropertyMetadata sourceProperty, String fieldName) {
        Set sortableFields = sourceProperty != null ? sourceProperty.getSortableFieldMetadata() : sourceType.getClassBridgeSortableFieldMetadata();
        for (SortableFieldMetadata sortableField : sortableFields) {
            if (!fieldName.equals(sortableField.getAbsoluteName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmbeddedField(String field) {
        return field.contains(".");
    }

    public static String getEmbeddedFieldPath(String field) {
        return field.substring(0, field.lastIndexOf("."));
    }

    public static String getEmbeddedFieldPropertyName(String field) {
        return field.substring(field.lastIndexOf(".") + 1);
    }

    public static enum ExtendedFieldType {
        STRING,
        BOOLEAN,
        DATE,
        CALENDAR,
        INSTANT,
        LOCAL_DATE,
        LOCAL_TIME,
        LOCAL_DATE_TIME,
        OFFSET_DATE_TIME,
        OFFSET_TIME,
        ZONED_DATE_TIME,
        YEAR,
        YEAR_MONTH,
        MONTH_DAY,
        OBJECT,
        INTEGER{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        LONG{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        FLOAT{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        DOUBLE{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        UNKNOWN_NUMERIC{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        UNKNOWN;


        public boolean isNumeric() {
            return false;
        }
    }
}

