/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.EnumSet;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.testing.TestForIssue;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@TestForIssue(jiraKey="HSEARCH-2456")
public class ElasticsearchIndexExistsCheckIT
extends SearchInitializationTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient().requiredIndexStatus(ElasticsearchIndexStatus.YELLOW);
    private IndexSchemaManagementStrategy strategy;

    @Parameterized.Parameters(name="With strategy {0}")
    public static Iterable<IndexSchemaManagementStrategy> strategies() {
        return EnumSet.complementOf(EnumSet.of(IndexSchemaManagementStrategy.NONE));
    }

    public ElasticsearchIndexExistsCheckIT(IndexSchemaManagementStrategy strategy) {
        this.strategy = strategy;
    }

    @Test
    public void indexMissing() throws Exception {
        Assume.assumeFalse((String)("The strategy " + this.strategy + " creates an index automatically. No point running this test."), (boolean)this.createsIndex(this.strategy));
        this.elasticSearchClient.index(SimpleEntity.class).ensureDoesNotExist();
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400050");
        this.init(SimpleEntity.class);
    }

    @Test
    public void invalidIndexStatus_creatingIndex() throws Exception {
        Assume.assumeTrue((String)("The strategy " + this.strategy + " doesn't creates an index automatically. No point running this test."), (boolean)this.createsIndex(this.strategy));
        this.elasticSearchClient.template("yellow_index_because_not_enough_nodes_for_so_many_replicas").create("*", JsonBuilder.object().addProperty("number_of_replicas", (Number)5).build());
        this.elasticSearchClient.index(SimpleEntity.class).ensureDoesNotExist();
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400024");
        this.thrown.expectMessage("100ms");
        this.init(SimpleEntity.class);
    }

    @Test
    public void invalidIndexStatus_usingPreexistingIndex() throws Exception {
        this.elasticSearchClient.template("yellow_index_because_not_enough_nodes_for_so_many_replicas").create("*", JsonBuilder.object().addProperty("number_of_replicas", (Number)5).build());
        this.elasticSearchClient.index(SimpleEntity.class).deleteAndCreate();
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400024");
        this.thrown.expectMessage("100ms");
        this.init(SimpleEntity.class);
    }

    protected void init(Class<?> ... entityClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", this.strategy.name());
        settings.put("hibernate.search.default.elasticsearch.index_management_wait_timeout", "100");
        settings.put("hibernate.search.default.elasticsearch.required_index_status", ElasticsearchIndexStatus.GREEN.getElasticsearchString());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])entityClasses));
    }

    private boolean createsIndex(IndexSchemaManagementStrategy strategy) {
        return !IndexSchemaManagementStrategy.NONE.equals((Object)strategy) && !IndexSchemaManagementStrategy.VALIDATE.equals((Object)strategy);
    }

    @Indexed
    @Entity
    private static class SimpleEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        String myField;

        private SimpleEntity() {
        }
    }
}

