/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.fest.assertions.ObjectAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.elasticsearch.test.GolfCourse;
import org.hibernate.search.elasticsearch.test.GolfPlayer;
import org.hibernate.search.elasticsearch.test.Hole;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.test.SearchTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ElasticsearchNullValueIT
extends SearchTestBase {
    @Before
    public void setupTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Calendar dob = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        dob.set(1958, 3, 7, 0, 0, 0);
        dob.set(14, 0);
        GolfPlayer hergesheimer = new GolfPlayer.Builder().firstName("Klaus").lastName("Hergesheimer").active(true).dateOfBirth(dob.getTime()).handicap(3.4).driveWidth(285).ranking(311).build();
        s.persist((Object)hergesheimer);
        GolfPlayer kidd = new GolfPlayer.Builder().lastName("Kidd").build();
        s.persist((Object)kidd);
        tx.commit();
        s.close();
    }

    @After
    public void deleteTestData() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        for (Object entity : result) {
            session.delete(entity);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testQueryOnNullToken() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromQueryString((String)"firstName:&lt;NULL&gt;");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).list();
        ((ListAssert)Assertions.assertThat((List)result).onProperty("id").describedAs("Querying null-encoded String")).containsOnly(new Object[]{2L});
        query = ElasticsearchQueries.fromQueryString((String)"dateOfBirth:1970-01-01");
        result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).list();
        ((ListAssert)Assertions.assertThat((List)result).onProperty("id").describedAs("Querying null-encoded Date")).containsOnly(new Object[]{2L});
        query = ElasticsearchQueries.fromQueryString((String)"active:false");
        result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).list();
        ((ListAssert)Assertions.assertThat((List)result).onProperty("id").describedAs("Querying null-encoded Boolean")).containsOnly(new Object[]{2L});
        query = ElasticsearchQueries.fromQueryString((String)"driveWidth:\\-1");
        result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).list();
        ((ListAssert)Assertions.assertThat((List)result).onProperty("id").describedAs("Querying null-encoded Integer")).containsOnly(new Object[]{2L});
        tx.commit();
        s.close();
    }

    @Test
    public void testProjectionOfNullValues() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromQueryString((String)"lastName:Kidd");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"firstName", "lastName", "active", "dateOfBirth", "handicap", "driveWidth", "ranking.value"}).list();
        Assertions.assertThat((List)result).hasSize(1);
        Object[] projection = (Object[])result.iterator().next();
        ((ObjectAssert)Assertions.assertThat((Object)projection[0]).describedAs("firstName")).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projection[1]).describedAs("lastName")).isEqualTo((Object)"Kidd");
        ((ObjectAssert)Assertions.assertThat((Object)projection[2]).describedAs("active")).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projection[3]).describedAs("dateOfBirth")).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projection[4]).describedAs("handicap")).isEqualTo((Object)0.0);
        ((ObjectAssert)Assertions.assertThat((Object)projection[5]).describedAs("driveWidth")).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projection[6]).describedAs("ranking value")).isNull();
        tx.commit();
        s.close();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{GolfPlayer.class, GolfCourse.class, Hole.class};
    }
}

