/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.lucene.document.Document;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.elasticsearch.work.impl.BulkRequestFailedException;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.test.SearchTestBase;
import org.junit.After;
import org.junit.Test;

public class ElasticsearchExceptionHandlingIT
extends SearchTestBase {
    private static TestExceptionHandler errorHandler = new TestExceptionHandler();

    @After
    public void deleteTestDataAndResetErrorHandler() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        for (Object entity : result) {
            session.delete(entity);
        }
        tx.commit();
        s.close();
        errorHandler.reset();
    }

    @Test
    public void errorHandlerInvokedForSingleOperation() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        Actor bert = new Actor();
        bert.id = 1L;
        bert.name = "Bert";
        s.persist((Object)bert);
        tx.commit();
        Assertions.assertThat(errorHandler.getHandleInvocations()).hasSize(1);
        ErrorContext errorContext = errorHandler.getHandleInvocations().iterator().next();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isExactlyInstanceOf(SearchException.class);
        Assertions.assertThat((List)errorContext.getFailingOperations()).onProperty("idInString").containsOnly(new Object[]{"1"});
        tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[]{Actor.class}).list();
        Assertions.assertThat((List)result).isEmpty();
        tx.commit();
        s.close();
    }

    @Test
    public void errorHandlerInvokedForBulk() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        Actor bob = new Actor();
        bob.id = 1L;
        bob.name = "Bob";
        s.persist((Object)bob);
        Actor bruce = new Actor();
        bruce.id = 2L;
        bruce.name = "Bruce";
        s.persist((Object)bruce);
        Actor bert = new Actor();
        bert.id = 3L;
        bert.name = "Bert";
        s.persist((Object)bert);
        Actor brent = new Actor();
        brent.id = 4L;
        brent.name = "Brent";
        s.persist((Object)brent);
        tx.commit();
        Assertions.assertThat(errorHandler.getHandleInvocations()).hasSize(1);
        ErrorContext errorContext = errorHandler.getHandleInvocations().iterator().next();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isExactlyInstanceOf(BulkRequestFailedException.class);
        Assertions.assertThat((List)errorContext.getFailingOperations()).onProperty("idInString").containsOnly(new Object[]{"3"});
        tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[]{Actor.class}).list();
        Assertions.assertThat((List)result).onProperty("name").containsOnly(new Object[]{"Bob", "Bruce", "Brent"});
        tx.commit();
        s.close();
    }

    public void configure(Map<String, Object> settings) {
        settings.put("hibernate.search.error_handler", errorHandler);
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Actor.class};
    }

    public static class ErroneousFieldBridge
    implements org.hibernate.search.bridge.FieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            String asString = (String)value;
            luceneOptions.addFieldToDocument(name, asString, document);
            if ("Bert".equals(asString)) {
                luceneOptions.addFieldToDocument("unexpected", "unexpected", document);
            }
        }
    }

    @Entity
    @Indexed(index="actor")
    public static class Actor {
        @Id
        public Long id;
        @Field(bridge=@FieldBridge(impl=ErroneousFieldBridge.class))
        public String name;

        public String getName() {
            return this.name;
        }
    }

    public static class TestExceptionHandler
    implements ErrorHandler {
        private List<ErrorContext> handleInvocations = new ArrayList<ErrorContext>();

        public void handle(ErrorContext context) {
            this.handleInvocations.add(context);
        }

        public void handleException(String errorMsg, Throwable exception) {
        }

        public List<ErrorContext> getHandleInvocations() {
            return this.handleInvocations;
        }

        public void reset() {
            this.handleInvocations.clear();
        }
    }
}

