/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.testutil;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexManager;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.elasticsearch.impl.ElasticsearchService;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.TestResourceManager;
import org.hibernate.search.test.util.BackendTestHelper;

public class ElasticsearchBackendTestHelper
extends BackendTestHelper {
    private TestResourceManager resourceManager;

    public ElasticsearchBackendTestHelper(TestResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public int getNumberOfDocumentsInIndex(Class<?> entityType) {
        ServiceManager serviceManager = this.resourceManager.getExtendedSearchIntegrator().getServiceManager();
        IndexManager[] indexManagers = this.resourceManager.getExtendedSearchIntegrator().getIndexBinding(entityType).getIndexManagers();
        ArrayList<String> indexNames = new ArrayList<String>(indexManagers.length);
        for (IndexManager indexManager : indexManagers) {
            indexNames.add(((ElasticsearchIndexManager)indexManager).getActualIndexName());
        }
        try (ServiceReference esService = serviceManager.requestReference(ElasticsearchService.class);){
            CountWork work = new CountWork.Builder(indexNames).type(entityType.getName()).build();
            int n = (Integer)((ElasticsearchService)esService.get()).getWorkProcessor().executeSyncUnsafe((ElasticsearchWork)work);
            return n;
        }
    }

    public int getNumberOfDocumentsInIndex(String indexName) {
        ServiceManager serviceManager = this.resourceManager.getExtendedSearchIntegrator().getServiceManager();
        try (ServiceReference esService = serviceManager.requestReference(ElasticsearchService.class);){
            CountWork work = new CountWork.Builder(ElasticsearchIndexNameNormalizer.getElasticsearchIndexName((String)indexName)).build();
            int n = (Integer)((ElasticsearchService)esService.get()).getWorkProcessor().executeSyncUnsafe((ElasticsearchWork)work);
            return n;
        }
    }

    public int getNumberOfDocumentsInIndexByQuery(String indexName, String fieldName, String value) {
        ServiceManager serviceManager = this.resourceManager.getExtendedSearchIntegrator().getServiceManager();
        String query = value.contains("*") ? "wildcard" : "term";
        try (ServiceReference esService = serviceManager.requestReference(ElasticsearchService.class);){
            CountWork work = new CountWork.Builder(ElasticsearchIndexNameNormalizer.getElasticsearchIndexName((String)indexName)).query(JsonBuilder.object().add("query", JsonBuilder.object().add(query, JsonBuilder.object().addProperty(fieldName, value))).build()).build();
            int n = (Integer)((ElasticsearchService)esService.get()).getWorkProcessor().executeSyncUnsafe((ElasticsearchWork)work);
            return n;
        }
    }

    private static class CountWork
    extends SimpleElasticsearchWork<Integer> {
        private static final JsonAccessor COUNT_ACCESSOR = JsonAccessor.root().property("count");

        protected CountWork(Builder builder) {
            super((SimpleElasticsearchWork.Builder)builder);
        }

        protected Integer generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
            return COUNT_ACCESSOR.get(parsedResponseBody).getAsInt();
        }

        private static class Builder
        extends SimpleElasticsearchWork.Builder<Builder> {
            private final List<String> indexNames = new ArrayList<String>();
            private final List<String> typeNames = new ArrayList<String>();
            private JsonObject query;

            public Builder(String indexName) {
                this(Collections.singletonList(indexName));
            }

            public Builder(Collection<String> indexNames) {
                super(null, (ElasticsearchRequestSuccessAssessor)DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
                this.indexNames.addAll(indexNames);
            }

            public Builder type(String type) {
                this.typeNames.add(type);
                return this;
            }

            public Builder query(JsonObject query) {
                this.query = query;
                return this;
            }

            protected ElasticsearchRequest buildRequest() {
                ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().multiValuedPathComponent(this.indexNames);
                if (!this.typeNames.isEmpty()) {
                    builder.multiValuedPathComponent(this.typeNames);
                }
                builder.pathComponent("_count");
                if (this.query != null) {
                    builder.body(this.query);
                }
                return builder.build();
            }

            public CountWork build() {
                return new CountWork(this);
            }
        }
    }
}

