/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.testutil;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchEnvironment;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.dialect.impl.DialectIndependentGsonProvider;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.impl.SearchThreadFactory;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.rules.ExternalResource;

public class TestElasticsearchClient
extends ExternalResource {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private RestClient client;
    private Gson gson;
    private final List<String> createdIndicesNames = Lists.newArrayList();
    private final List<String> createdTemplatesNames = Lists.newArrayList();
    private ElasticsearchIndexStatus requiredIndexStatus = ElasticsearchEnvironment.Defaults.REQUIRED_INDEX_STATUS;

    public TestElasticsearchClient requiredIndexStatus(ElasticsearchIndexStatus requiredIndexStatus) {
        this.requiredIndexStatus = requiredIndexStatus;
        return this;
    }

    public IndexClient index(Class<?> rootClass) {
        return new IndexClient(ElasticsearchIndexNameNormalizer.getElasticsearchIndexName((String)rootClass.getName()));
    }

    public IndexClient index(String indexName) {
        return new IndexClient(indexName);
    }

    public TypeClient type(Class<?> rootClass) {
        return this.index(rootClass).type(rootClass);
    }

    public TemplateClient template(String templateName) {
        return new TemplateClient(templateName);
    }

    private void deleteAndCreateIndex(String indexName) throws IOException {
        this.tryDeleteESIndex(indexName);
        this.registerIndexForCleanup(indexName);
        this.performRequest(ElasticsearchRequest.put().pathComponent(indexName).build());
        this.waitForRequiredIndexStatus(indexName);
    }

    private void createTemplate(String templateName, String templateString, JsonObject settings) throws IOException {
        JsonObject source = JsonBuilder.object().addProperty("template", templateString).add("settings", (JsonElement)settings).build();
        this.registerTemplateForCleanup(templateName);
        this.performRequest(ElasticsearchRequest.put().pathComponent("_template").pathComponent(templateName).body(source).build());
    }

    private void ensureIndexDoesNotExist(String indexName) throws IOException {
        block2: {
            try {
                this.performRequest(ElasticsearchRequest.delete().pathComponent(indexName).build());
            }
            catch (ResponseException e) {
                if (e.getResponse().getStatusLine().getStatusCode() == 404) break block2;
                throw e;
            }
        }
    }

    private void registerIndexForCleanup(String indexName) {
        this.createdIndicesNames.add(indexName);
    }

    private void registerTemplateForCleanup(String templateName) {
        this.createdTemplatesNames.add(templateName);
    }

    private void waitForRequiredIndexStatus(String indexName) throws IOException {
        this.performRequest(ElasticsearchRequest.get().pathComponent("_cluster").pathComponent("health").pathComponent(indexName).param("wait_for_status", this.requiredIndexStatus.getElasticsearchString()).param("timeout", "10000ms").build());
    }

    private void putMapping(String indexName, String mappingName, String mappingJson) throws IOException {
        JsonObject mappingJsonObject = this.toJsonElement(mappingJson).getAsJsonObject();
        this.performRequest(ElasticsearchRequest.put().pathComponent(indexName).pathComponent("_mapping").pathComponent(mappingName).body(mappingJsonObject).build());
    }

    private String getMapping(String indexName, String mappingName) throws IOException {
        Response response = this.performRequest(ElasticsearchRequest.get().pathComponent(indexName).pathComponent("_mapping").pathComponent(mappingName).build());
        JsonObject result = this.toJsonObject(response);
        JsonElement index = result.get(indexName);
        if (index == null) {
            return new JsonObject().toString();
        }
        JsonElement mappings = index.getAsJsonObject().get("mappings");
        if (mappings == null) {
            return new JsonObject().toString();
        }
        JsonElement mapping = mappings.getAsJsonObject().get(mappingName);
        if (mapping == null) {
            return new JsonObject().toString();
        }
        return mapping.toString();
    }

    private void putSettings(String indexName, String settingsPath, String settings) throws IOException {
        JsonElement settingsJsonElement = this.toJsonElement(settings);
        for (String property : Lists.reverse(Arrays.asList(settingsPath.split("\\.")))) {
            settingsJsonElement = JsonBuilder.object().add(property, settingsJsonElement).build();
        }
        this.performRequest(ElasticsearchRequest.post().pathComponent(indexName).pathComponent("_close").build());
        this.performRequest(ElasticsearchRequest.put().pathComponent(indexName).pathComponent("_settings").body(settingsJsonElement.getAsJsonObject()).build());
        this.performRequest(ElasticsearchRequest.post().pathComponent(indexName).pathComponent("_open").build());
    }

    private String getSettings(String indexName, String path) throws IOException {
        Response response = this.performRequest(ElasticsearchRequest.get().pathComponent(indexName).pathComponent("_settings").build());
        JsonObject result = this.toJsonObject(response);
        JsonElement index = result.get(indexName);
        if (index == null) {
            return new JsonObject().toString();
        }
        JsonElement settings = index.getAsJsonObject().get("settings");
        for (String property : path.split("\\.")) {
            if (settings == null) break;
            settings = settings.getAsJsonObject().get(property);
        }
        if (settings == null) {
            return new JsonObject().toString();
        }
        return settings.toString();
    }

    private void index(String indexName, String typeName, String id, String jsonDocument) throws IOException {
        JsonObject documentJsonObject = this.toJsonElement(jsonDocument).getAsJsonObject();
        this.performRequest(ElasticsearchRequest.put().pathComponent(indexName).pathComponent(typeName).pathComponent(id).body(documentJsonObject).param("refresh", true).build());
    }

    private JsonObject getDocumentSource(String indexName, String typeName, String id) throws IOException {
        Response response = this.performRequest(ElasticsearchRequest.get().pathComponent(indexName).pathComponent(typeName).pathComponent(id).build());
        JsonObject result = this.toJsonObject(response);
        return result.get("_source").getAsJsonObject();
    }

    protected JsonElement getDocumentField(String indexName, String typeName, String id, String fieldName) throws IOException {
        Response response = this.performRequest(ElasticsearchRequest.get().pathComponent(indexName).pathComponent(typeName).pathComponent(id).param("stored_fields", fieldName).build());
        JsonObject result = this.toJsonObject(response);
        return result.get("fields").getAsJsonObject().get(fieldName);
    }

    protected void before() throws Throwable {
        this.gson = DialectIndependentGsonProvider.INSTANCE.getGson();
        this.client = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)"http://localhost:9200")}).setMaxRetryTimeoutMillis(60000).setHttpClientConfigCallback(builder -> builder.setMaxConnTotal(20).setMaxConnPerRoute(2).setThreadFactory((ThreadFactory)new SearchThreadFactory("Test Elasticsearch client transport thread"))).setRequestConfigCallback(builder -> builder.setSocketTimeout(60000).setConnectTimeout(3000)).build();
    }

    protected void after() {
        for (String indexName : this.createdIndicesNames) {
            this.tryDeleteESIndex(indexName);
        }
        this.createdIndicesNames.clear();
        for (String templateName : this.createdTemplatesNames) {
            this.tryDeleteESTemplate(templateName);
        }
        this.createdTemplatesNames.clear();
        try {
            this.client.close();
            this.client = null;
        }
        catch (IOException e) {
            throw new AssertionFailure("Unexpected exception when closing the RestClient", (Throwable)e);
        }
    }

    private void tryDeleteESIndex(String indexName) {
        try {
            this.performRequest(ElasticsearchRequest.delete().pathComponent(indexName).build());
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() != 404) {
                LOG.warnf((Throwable)e, "Error while trying to delete index '%s' as part of test cleanup", (Object)indexName);
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.warnf((Throwable)e, "Error while trying to delete index '%s' as part of test cleanup", (Object)indexName);
        }
    }

    private void tryDeleteESTemplate(String templateName) {
        try {
            this.performRequest(ElasticsearchRequest.delete().pathComponent("_template").pathComponent(templateName).build());
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() != 404) {
                LOG.warnf((Throwable)e, "Error while trying to delete template '%s' as part of test cleanup", (Object)templateName);
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.warnf((Throwable)e, "Error while trying to delete template '%s' as part of test cleanup", (Object)templateName);
        }
    }

    protected Response performRequest(ElasticsearchRequest request) throws IOException {
        return this.client.performRequest(request.getMethod(), request.getPath(), request.getParameters(), ElasticsearchClientUtils.toEntity((Gson)this.gson, (ElasticsearchRequest)request), new Header[0]);
    }

    /*
     * Exception decompiling
     */
    protected JsonObject toJsonObject(Response response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JsonElement toJsonElement(String jsonAsString) {
        return new JsonParser().parse(jsonAsString);
    }

    public class TemplateClient {
        private final String templateName;

        public TemplateClient(String templateName) {
            this.templateName = templateName;
        }

        public TemplateClient create(String templateString, JsonObject settings) throws IOException {
            TestElasticsearchClient.this.createTemplate(this.templateName, templateString, settings);
            return this;
        }

        public TemplateClient registerForCleanup() {
            TestElasticsearchClient.this.registerTemplateForCleanup(this.templateName);
            return this;
        }
    }

    public class DocumentClient {
        private final TypeClient typeClient;
        private final String id;

        public DocumentClient(TypeClient typeClient, String id) {
            this.typeClient = typeClient;
            this.id = id;
        }

        public JsonObject getSource() throws IOException {
            return TestElasticsearchClient.this.getDocumentSource(this.typeClient.indexClient.indexName, this.typeClient.typeName, this.id);
        }

        public JsonElement getStoredField(String fieldName) throws IOException {
            return TestElasticsearchClient.this.getDocumentField(this.typeClient.indexClient.indexName, this.typeClient.typeName, this.id, fieldName);
        }
    }

    public class SettingsClient {
        private final IndexClient indexClient;
        private final String settingsPath;

        public SettingsClient(IndexClient indexClient, String settingsPath) {
            this.indexClient = indexClient;
            this.settingsPath = settingsPath;
        }

        public String get() throws IOException {
            return TestElasticsearchClient.this.getSettings(this.indexClient.indexName, this.settingsPath);
        }

        public void put(String settings) throws IOException {
            TestElasticsearchClient.this.putSettings(this.indexClient.indexName, this.settingsPath, settings);
        }
    }

    public class TypeClient {
        private final IndexClient indexClient;
        private final String typeName;

        public TypeClient(IndexClient indexClient, String mappingName) {
            this.indexClient = indexClient;
            this.typeName = mappingName;
        }

        public TypeClient putMapping(String mappingJson) throws IOException {
            TestElasticsearchClient.this.putMapping(this.indexClient.indexName, this.typeName, mappingJson);
            return this;
        }

        public String getMapping() throws IOException {
            return TestElasticsearchClient.this.getMapping(this.indexClient.indexName, this.typeName);
        }

        public TypeClient index(String id, String jsonDocument) throws IOException {
            TestElasticsearchClient.this.index(this.indexClient.indexName, this.typeName, id, jsonDocument);
            return this;
        }

        public DocumentClient document(String id) {
            return new DocumentClient(this, id);
        }
    }

    public class IndexClient {
        private final String indexName;

        public IndexClient(String indexName) {
            this.indexName = indexName;
        }

        public void waitForRequiredIndexStatus() throws IOException {
            TestElasticsearchClient.this.waitForRequiredIndexStatus(this.indexName);
        }

        public IndexClient deleteAndCreate() throws IOException {
            TestElasticsearchClient.this.deleteAndCreateIndex(this.indexName);
            return this;
        }

        public IndexClient ensureDoesNotExist() throws IOException {
            TestElasticsearchClient.this.ensureIndexDoesNotExist(this.indexName);
            return this;
        }

        public IndexClient registerForCleanup() {
            TestElasticsearchClient.this.registerIndexForCleanup(this.indexName);
            return this;
        }

        public TypeClient type(Class<?> mappingClass) {
            return this.type(mappingClass.getName());
        }

        public TypeClient type(String mappingName) {
            return new TypeClient(this, mappingName);
        }

        public SettingsClient settings() {
            return this.settings("");
        }

        public SettingsClient settings(String settingsPath) {
            return new SettingsClient(this, settingsPath);
        }
    }
}

