/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.List;
import java.util.Map;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.elasticsearch.test.ComicBook;
import org.hibernate.search.elasticsearch.test.ResearchPaper;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CombiningLuceneAndElasticsearchIT
extends SearchTestBase {
    private final QueryParser queryParser = new QueryParser("id", TestConstants.simpleAnalyzer);

    @Before
    public void setupTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        ResearchPaper paper = new ResearchPaper("important research", "latest findings", "Once upon a time...", 100);
        s.persist((Object)paper);
        ComicBook comicBook = new ComicBook("The tales of Bob", "Once upon a time...");
        s.persist((Object)comicBook);
        tx.commit();
        s.close();
    }

    @Test
    public void canUseLuceneAndElasticsearchForDifferentEntities() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        List result = session.createFullTextQuery(ElasticsearchQueries.fromQueryString((String)"title:important"), new Class[]{ResearchPaper.class}).list();
        Assertions.assertThat((List)result).onProperty("title").containsExactly(new Object[]{"important research"});
        result = session.createFullTextQuery(this.queryParser.parse("title:tales"), new Class[]{ComicBook.class}).list();
        Assertions.assertThat((List)result).onProperty("title").containsExactly(new Object[]{"The tales of Bob"});
        tx.commit();
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cannotUseElasticsearchQueryWithLuceneIndexedEntity() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        try {
            session.createFullTextQuery(ElasticsearchQueries.fromQueryString((String)"title:tales"), new Class[]{ComicBook.class}).list();
            Fail.fail((String)"Expected exception wasn't raised");
        }
        catch (SearchException se) {
            Assertions.assertThat((String)se.getMessage()).contains("HSEARCH400001");
        }
        finally {
            tx.commit();
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cannotUseLuceneQueryWithElasticsearchIndexedEntity() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        try {
            session.createFullTextQuery((Query)new NotTranslatableQuery(), new Class[]{ResearchPaper.class}).list();
            Fail.fail((String)"Expected exception wasn't raised");
        }
        catch (SearchException se) {
            Assertions.assertThat((String)se.getMessage()).contains("HSEARCH400002");
        }
        finally {
            tx.commit();
            s.close();
        }
    }

    @After
    public void deleteTestData() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[]{ResearchPaper.class}).list();
        for (Object entity : result) {
            session.delete(entity);
        }
        result = session.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{ComicBook.class}).list();
        for (Object entity : result) {
            session.delete(entity);
        }
        tx.commit();
        s.close();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{ResearchPaper.class, ComicBook.class};
    }

    public void configure(Map<String, Object> settings) {
        settings.put("hibernate.search.comic_book.indexmanager", "directory-based");
        settings.put("hibernate.search.comic_book.directory_provider", "ram");
    }

    private static class NotTranslatableQuery
    extends Query {
        private NotTranslatableQuery() {
        }

        public String toString(String field) {
            return ((Object)((Object)this)).getClass().getName();
        }
    }
}

