/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.http.HttpHeader;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntAssert;
import org.fest.assertions.StringAssert;
import org.hibernate.search.elasticsearch.client.impl.DefaultElasticsearchClientFactory;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClientImplementor;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DefaultElasticsearchClientFactoryTest {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final String CLIENT_SCOPE_NAME = "default";
    private static final String CLIENT_PROPERTY_PREFIX = "hibernate.search.default.";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public ExpectedLog4jLog logged = ExpectedLog4jLog.create();
    @Rule
    public WireMockRule wireMockRule1 = new WireMockRule(0);
    @Rule
    public WireMockRule wireMockRule2 = new WireMockRule(0);
    private DefaultElasticsearchClientFactory clientFactory = new DefaultElasticsearchClientFactory();

    @Test
    @TestForIssue(jiraKey="HSEARCH-2274")
    public void simple() throws Exception {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule1));
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200)));
        try (ElasticsearchClientImplementor client = this.clientFactory.create(CLIENT_SCOPE_NAME, configuration.getProperties());){
            Response result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            this.wireMockRule1.verify(WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
        }
    }

    @Test
    public void error() throws Exception {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule1));
        String payload = "{ \"foo\": \"bar\" }";
        String errorMessage = "ErrorMessageExplainingTheError";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(500).withBody("{ \"error\": \"" + errorMessage + "\" }")));
        try (ElasticsearchClientImplementor client = this.clientFactory.create(CLIENT_SCOPE_NAME, configuration.getProperties());){
            Response result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(500);
            ((StringAssert)Assertions.assertThat((String)IOUtils.toString((InputStream)result.getEntity().getContent())).as("response body")).contains(errorMessage);
        }
    }

    @Test
    public void timeout_read() throws Exception {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule1)).addProperty("hibernate.search.default.elasticsearch.read_timeout", "1000").addProperty("hibernate.search.default.elasticsearch.request_timeout", "99999");
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withFixedDelay(Integer.valueOf(2000))));
        this.thrown.expect(IOException.class);
        try (ElasticsearchClientImplementor client = this.clientFactory.create(CLIENT_SCOPE_NAME, configuration.getProperties());){
            this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
        }
    }

    @Test
    public void timeout_request() throws Exception {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule1)).addProperty("hibernate.search.default.elasticsearch.read_timeout", "99999").addProperty("hibernate.search.default.elasticsearch.request_timeout", "1000");
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withFixedDelay(Integer.valueOf(2000))));
        this.thrown.expect(IOException.class);
        try (ElasticsearchClientImplementor client = this.clientFactory.create(CLIENT_SCOPE_NAME, configuration.getProperties());){
            this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2235")
    public void multipleHosts() throws Exception {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule1) + " " + DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule2));
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200)));
        this.wireMockRule2.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200)));
        try (ElasticsearchClientImplementor client = this.clientFactory.create(CLIENT_SCOPE_NAME, configuration.getProperties());){
            Response result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            this.wireMockRule1.verify(WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
            this.wireMockRule2.verify(WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2469")
    public void multipleHosts_failover_serverError() throws Exception {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule1) + " " + DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule2));
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200)));
        this.wireMockRule2.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(503)));
        try (ElasticsearchClientImplementor client = this.clientFactory.create(CLIENT_SCOPE_NAME, configuration.getProperties());){
            Response result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            this.wireMockRule1.verify(2, WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
            this.wireMockRule2.verify(1, WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
            this.wireMockRule1.resetRequests();
            this.wireMockRule2.resetRequests();
            result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            this.wireMockRule1.verify(2, WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
            this.wireMockRule2.verify(0, WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2469")
    public void multipleHosts_failover_timeout() throws Exception {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule1) + " " + DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule2)).addProperty("hibernate.search.default.elasticsearch.read_timeout", "1000");
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200)));
        this.wireMockRule2.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200).withFixedDelay(Integer.valueOf(10000))));
        try (ElasticsearchClientImplementor client = this.clientFactory.create(CLIENT_SCOPE_NAME, configuration.getProperties());){
            Response result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            this.wireMockRule1.verify(2, WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
            this.wireMockRule2.verify(0, WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
            this.wireMockRule1.resetRequests();
            this.wireMockRule2.resetRequests();
            this.wireMockRule2.resetMappings();
            this.wireMockRule2.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200)));
            result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            this.wireMockRule1.verify(2, WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
            this.wireMockRule2.verify(0, WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2469")
    public void multipleHosts_failover_fault() throws Exception {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule1) + " " + DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule2)).addProperty("hibernate.search.default.elasticsearch.read_timeout", "1000");
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200)));
        this.wireMockRule2.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200).withFault(Fault.MALFORMED_RESPONSE_CHUNK)));
        try (ElasticsearchClientImplementor client = this.clientFactory.create(CLIENT_SCOPE_NAME, configuration.getProperties());){
            Response result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            this.wireMockRule1.verify(2, WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
            this.wireMockRule2.verify(1, WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
            this.wireMockRule1.resetRequests();
            this.wireMockRule2.resetRequests();
            result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            this.wireMockRule1.verify(2, WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
            this.wireMockRule2.verify(0, WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2449")
    public void discovery() throws Exception {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule1)).addProperty("hibernate.search.default.elasticsearch.discovery.enabled", "true").addProperty("hibernate.search.default.elasticsearch.discovery.refresh_interval", "1");
        String nodesInfoResult = this.dummyNodeInfoResponse(this.wireMockRule1.port(), this.wireMockRule2.port());
        this.wireMockRule1.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)"/_nodes.*")).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200).withBody(nodesInfoResult)));
        this.wireMockRule2.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)"/_nodes.*")).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200).withBody(nodesInfoResult)));
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200)));
        this.wireMockRule2.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200)));
        try (ElasticsearchClientImplementor client = this.clientFactory.create(CLIENT_SCOPE_NAME, configuration.getProperties());){
            Response result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            Thread.sleep(2000L);
            result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            result = this.doPost((ElasticsearchClient)client, "/myIndex/myType", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            this.wireMockRule1.verify(WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
            this.wireMockRule2.verify(WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType")));
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2453")
    public void authentication() throws Exception {
        String username = "ironman";
        String password = "j@rV1s";
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule1)).addProperty("hibernate.search.default.elasticsearch.username", username).addProperty("hibernate.search.default.elasticsearch.password", password);
        String payload = "{ \"foo\": \"bar\" }";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType/_search")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(401).withHeader(HttpHeader.WWW_AUTHENTICATE.asString(), new String[]{"Basic"})));
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType/_search")).withBasicAuth(username, password).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(200)));
        try (ElasticsearchClientImplementor client = this.clientFactory.create(CLIENT_SCOPE_NAME, configuration.getProperties());){
            Response result = this.doPost((ElasticsearchClient)client, "/myIndex/myType/_search", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(200);
            this.wireMockRule1.verify(WireMock.postRequestedFor((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType/_search")));
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2453")
    public void authentication_error() throws Exception {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", DefaultElasticsearchClientFactoryTest.httpUrlFor(this.wireMockRule1));
        String payload = "{ \"foo\": \"bar\" }";
        String statusMessage = "StatusMessageUnauthorized";
        this.wireMockRule1.stubFor(WireMock.post((UrlPattern)DefaultElasticsearchClientFactoryTest.urlPathLike("/myIndex/myType/_search")).withRequestBody(WireMock.equalToJson((String)payload)).willReturn(DefaultElasticsearchClientFactoryTest.elasticsearchResponse().withStatus(401).withStatusMessage(statusMessage)));
        try (ElasticsearchClientImplementor client = this.clientFactory.create(CLIENT_SCOPE_NAME, configuration.getProperties());){
            Response result = this.doPost((ElasticsearchClient)client, "/myIndex/myType/_search", payload);
            ((IntAssert)Assertions.assertThat((int)result.getStatusLine().getStatusCode()).as("status code")).isEqualTo(401);
            ((StringAssert)Assertions.assertThat((String)result.getStatusLine().getReasonPhrase()).as("reason phrase")).contains(statusMessage);
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2453")
    public void authentication_http_password() throws Exception {
        String username = "ironman";
        String password = "j@rV1s";
        String httpUri = "http://foo.com/";
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.search.default.elasticsearch.host", httpUri).addProperty("hibernate.search.default.elasticsearch.username", username).addProperty("hibernate.search.default.elasticsearch.password", password);
        this.logged.expectMessage("HSEARCH400073", new String[]{httpUri});
        ElasticsearchClientImplementor client = this.clientFactory.create(CLIENT_SCOPE_NAME, configuration.getProperties());
        Throwable throwable = null;
        if (client != null) {
            if (throwable != null) {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                client.close();
            }
        }
    }

    private Response doPost(ElasticsearchClient client, String path, String payload) throws IOException, ResponseException {
        return client.execute(this.buildRequest(ElasticsearchRequest.post(), path, payload));
    }

    private ElasticsearchRequest buildRequest(ElasticsearchRequest.Builder builder, String path, String payload) {
        for (String pathComponent : path.split("/")) {
            if (pathComponent.isEmpty()) continue;
            URLEncodedString fromString = URLEncodedString.fromString((String)pathComponent);
            builder = builder.pathComponent(fromString);
        }
        if (payload != null) {
            builder = builder.body(JSON_PARSER.parse(payload).getAsJsonObject());
        }
        return builder.build();
    }

    private static String httpUrlFor(WireMockRule rule) {
        return "http://localhost:" + rule.port();
    }

    private static UrlPathPattern urlPathLike(String path) {
        return WireMock.urlPathMatching((String)(path + "/?"));
    }

    private static ResponseDefinitionBuilder elasticsearchResponse() {
        return ResponseDefinitionBuilder.okForEmptyJson();
    }

    private String dummyNodeInfoResponse(int ... ports) {
        JsonBuilder.Object nodesBuilder = JsonBuilder.object();
        int index = 1;
        for (int port : ports) {
            nodesBuilder.add("hJLXmY_NTrCytiIMbX4_" + index + "g", (JsonElement)this.dummyNodeInfo(port));
            ++index;
        }
        return JsonBuilder.object().addProperty("cluster_name", "foo-cluster.local").add("nodes", (JsonElement)nodesBuilder.build()).build().toString();
    }

    private JsonObject dummyNodeInfo(int port) {
        return JsonBuilder.object().addProperty("name", "nodeForPort" + port).add("http", JsonBuilder.object().addProperty("publish_address", "localhost:" + port)).add("plugins", (JsonElement)JsonBuilder.array().build()).build();
    }
}

