/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test.filter;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.FilterCacheModeType;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.builtin.IntegerBridge;
import org.hibernate.search.elasticsearch.test.filter.BestDriversElasticsearchFilter;
import org.hibernate.search.elasticsearch.test.filter.DriversMatchingNameElasticsearchFilter;
import org.hibernate.search.test.filter.FieldConstraintFilterFactory;

@Entity
@Indexed
@FullTextFilterDefs(value={@FullTextFilterDef(name="bestDriver", impl=BestDriversElasticsearchFilter.class, cache=FilterCacheModeType.NONE), @FullTextFilterDef(name="namedDriver", impl=DriversMatchingNameElasticsearchFilter.class), @FullTextFilterDef(name="fieldConstraintFilter-1", impl=FieldConstraintFilterFactory.class, cache=FilterCacheModeType.INSTANCE_AND_DOCIDSETRESULTS)})
public class Driver {
    @Id
    @DocumentId
    private int id;
    @Field(analyze=Analyze.YES)
    private String name;
    @Field(analyze=Analyze.NO)
    private String teacher;
    @Field(analyze=Analyze.NO)
    @FieldBridge(impl=IntegerBridge.class)
    private int score;
    @Field(analyze=Analyze.NO)
    @DateBridge(resolution=Resolution.YEAR)
    private Date delivery;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTeacher() {
        return this.teacher;
    }

    public void setTeacher(String teacher) {
        this.teacher = teacher;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public Date getDelivery() {
        return this.delivery;
    }

    public void setDelivery(Date delivery) {
        this.delivery = delivery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Driver driver = (Driver)o;
        if (this.id != driver.id) {
            return false;
        }
        if (this.score != driver.score) {
            return false;
        }
        if (this.delivery != null ? !this.delivery.equals(driver.delivery) : driver.delivery != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(driver.name) : driver.name != null) {
            return false;
        }
        return !(this.teacher == null ? driver.teacher != null : !this.teacher.equals(driver.teacher));
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.teacher != null ? this.teacher.hashCode() : 0);
        result = 31 * result + this.score;
        result = 31 * result + (this.delivery != null ? this.delivery.hashCode() : 0);
        return result;
    }
}

