/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.io.IOException;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Normalizer;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchCharFilterFactory;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchTokenFilterFactory;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidationException;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.test.util.impl.ExceptionMatcherBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class AbstractElasticsearch2And50NormalizerDefinitionValidationIT
extends SearchInitializationTestBase {
    private static final String VALIDATION_FAILED_MESSAGE_ID = "HSEARCH400033";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();

    protected void init(Class<?> ... annotatedClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", IndexSchemaManagementStrategy.VALIDATE.getExternalName());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])annotatedClasses));
    }

    @Test
    public void success_simple() throws Exception {
        this.elasticSearchClient.index(NormalizedEntity.class).deleteAndCreate("index.analysis", "{'analyzer': {'normalizerWithElasticsearchFactories': {'char_filter': ['custom-char-mapping-esFactory'],'tokenizer': 'keyword','filter': ['custom-elision-esFactory']}},'char_filter': {'custom-char-mapping-esFactory': {'type': 'mapping','mappings': ['foo => bar']}},'filter': {'custom-elision-esFactory': {'type': 'elision','articles': ['l', 'd']}}}");
        this.putMapping();
        this.init(NormalizedEntity.class);
    }

    protected abstract void putMapping() throws IOException;

    @Test
    public void normalizer_missing() throws Exception {
        this.elasticSearchClient.index(NormalizedEntity.class).deleteAndCreate("index.analysis", "{'char_filter': {'custom-char-mapping-esFactory': {'type': 'mapping','mappings': ['foo => bar']}},'filter': {'custom-elision-esFactory': {'type': 'elision','articles': ['l', 'd']}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("analyzer 'normalizerWithElasticsearchFactories':\n\tMissing analyzer").build());
        this.init(NormalizedEntity.class);
    }

    @Indexed
    @Entity
    @NormalizerDef(name="normalizerWithElasticsearchFactories", charFilters={@CharFilterDef(name="custom-char-mapping-esFactory", factory=ElasticsearchCharFilterFactory.class, params={@Parameter(name="type", value="'mapping'"), @Parameter(name="mappings", value="['foo => bar']")})}, filters={@TokenFilterDef(name="custom-elision-esFactory", factory=ElasticsearchTokenFilterFactory.class, params={@Parameter(name="type", value="'elision'"), @Parameter(name="articles", value="['l', 'd']")})})
    public static class NormalizedEntity {
        @DocumentId
        @Id
        Long id;
        @Field(normalizer=@Normalizer(definition="normalizerWithElasticsearchFactories"))
        String myField;
    }
}

