/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Date;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidationException;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.elasticsearch.testutil.junit.SkipFromElasticsearch50;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.test.util.impl.ExceptionMatcherBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={SkipFromElasticsearch50.class})
public class Elasticsearch2SchemaValidationIT
extends SearchInitializationTestBase {
    private static final String VALIDATION_FAILED_MESSAGE_ID = "HSEARCH400033";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();

    protected void init(Class<?> ... annotatedClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", IndexSchemaManagementStrategy.VALIDATE.getExternalName());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])annotatedClasses));
    }

    @Test
    public void success_simple() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed','ignore_malformed': true},'NOTmyField': {'type': 'date','index': 'not_analyzed'}}}");
        this.elasticSearchClient.index(SimpleBooleanEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleBooleanEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean','index': 'not_analyzed'},'NOTmyField': {'type': 'boolean','index': 'not_analyzed'}}}");
        this.elasticSearchClient.index(SimpleStringEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleStringEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string','index': 'analyzed','analyzer': 'default'},'NOTmyField': {'type': 'string','index': 'not_analyzed'}}}");
        this.elasticSearchClient.index(FacetedDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(FacetedDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed','ignore_malformed': true,'fields': {'myField__HSearch_Facet': {'type': 'date','index': 'not_analyzed'}}},'NOTmyField': {'type': 'date','index': 'not_analyzed'}}}");
        this.init(SimpleDateEntity.class, SimpleBooleanEntity.class, SimpleStringEntity.class, FacetedDateEntity.class);
    }

    @Test
    public void mapping_missing() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("\n\tMissing type mapping").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void rootMapping_attribute_missing() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleDateEntity.class).putMapping("{'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("\n\tInvalid value for attribute 'dynamic'. Expected 'STRICT', actual is 'null'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void rootMapping_attribute_dynamic_invalid() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleDateEntity.class).putMapping("{'dynamic': false,'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("\n\tInvalid value for attribute 'dynamic'. Expected 'STRICT', actual is 'FALSE'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void properties_missing() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tMissing property mapping").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_missing() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'NOTmyField': {'type': 'date','index': 'not_analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tMissing property mapping").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_attribute_missing() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'object'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tInvalid value for attribute 'type'. Expected 'DATE', actual is 'OBJECT'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_attribute_invalid() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tInvalid value for attribute 'index'. Expected 'NOT_ANALYZED', actual is 'ANALYZED'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_analyzer_invalid() throws Exception {
        this.elasticSearchClient.index(SimpleStringEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleStringEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': not_analyzed,'store': true},'myField': {'type': 'string','index': analyzed,'analyzer': 'keyword'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tInvalid value for attribute 'analyzer'. Expected 'default', actual is 'keyword'").build());
        this.init(SimpleStringEntity.class);
    }

    @Test
    public void property_format_invalidOutputFormat() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'epoch_millis||yyyy'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tThe output format (the first format in the 'format' attribute) is invalid. Expected 'strict_date_optional_time', actual is 'epoch_millis'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_format_missingInputFormat() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'strict_date_optional_time'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tInvalid formats for attribute 'format'").withMessage("missing elements are '[epoch_millis]'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_format_unexpectedInputFormat() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis||yyyy'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField'").withMessage("\n\tInvalid formats for attribute 'format'").withMessage("unexpected elements are '[yyyy]'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_attribute_leniency() throws Exception {
        this.elasticSearchClient.index(SimpleLenientEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleLenientEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'long','index': 'analyzed','store': 'yes'}}}");
        this.init(SimpleLenientEntity.class);
    }

    @Test
    public void multipleErrors_singleIndexManagers() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleDateEntity.class).putMapping("{'dynamic': false,'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("\nindex 'org.hibernate.search.elasticsearch.test.elasticsearch2schemavalidationit$simpledateentity', mapping 'org.hibernate.search.elasticsearch.test.Elasticsearch2SchemaValidationIT$SimpleDateEntity':\n\tInvalid value for attribute 'dynamic'. Expected 'STRICT', actual is 'FALSE'\nindex 'org.hibernate.search.elasticsearch.test.elasticsearch2schemavalidationit$simpledateentity', mapping 'org.hibernate.search.elasticsearch.test.Elasticsearch2SchemaValidationIT$SimpleDateEntity', property 'myField':\n\tInvalid value for attribute 'type'. Expected 'DATE', actual is 'STRING'").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void multipleErrors_multipleIndexManagers() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleDateEntity.class).putMapping("{'dynamic': false,'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'string'}}}");
        this.elasticSearchClient.index(SimpleBooleanEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(SimpleBooleanEntity.class).putMapping("{'dynamic': false,'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMainOrSuppressed(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("\nindex 'org.hibernate.search.elasticsearch.test.elasticsearch2schemavalidationit$simplebooleanentity', mapping 'org.hibernate.search.elasticsearch.test.Elasticsearch2SchemaValidationIT$SimpleBooleanEntity':\n\tInvalid value for attribute 'dynamic'. Expected 'STRICT', actual is 'FALSE'").build()).withMainOrSuppressed(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("\nindex 'org.hibernate.search.elasticsearch.test.elasticsearch2schemavalidationit$simpledateentity', mapping 'org.hibernate.search.elasticsearch.test.Elasticsearch2SchemaValidationIT$SimpleDateEntity':\n\tInvalid value for attribute 'dynamic'. Expected 'STRICT', actual is 'FALSE'\nindex 'org.hibernate.search.elasticsearch.test.elasticsearch2schemavalidationit$simpledateentity', mapping 'org.hibernate.search.elasticsearch.test.Elasticsearch2SchemaValidationIT$SimpleDateEntity', property 'myField':\n\tInvalid value for attribute 'type'. Expected 'DATE', actual is 'STRING'").build()).build());
        this.init(SimpleBooleanEntity.class, SimpleDateEntity.class);
    }

    @Test
    public void property_fields_missing() throws Exception {
        this.elasticSearchClient.index(FacetedDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(FacetedDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField', field 'myField__HSearch_Facet'").withMessage("\n\tMissing field mapping").build());
        this.init(FacetedDateEntity.class);
    }

    @Test
    public void property_field_missing() throws Exception {
        this.elasticSearchClient.index(FacetedDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(FacetedDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed','fields': {'NOTmyField__HSearch_Facet': {'type': 'date','index': 'not_analyzed'}}}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField', field 'myField__HSearch_Facet'").withMessage("\n\tMissing field mapping").build());
        this.init(FacetedDateEntity.class);
    }

    @Test
    public void property_field_attribute_invalid() throws Exception {
        this.elasticSearchClient.index(FacetedDateEntity.class).deleteAndCreate();
        this.elasticSearchClient.type(FacetedDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed','fields': {'myField__HSearch_Facet': {'type': 'date','index': 'analyzed'}}}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("property 'myField', field 'myField__HSearch_Facet'").withMessage("\n\tInvalid value for attribute 'index'. Expected 'NOT_ANALYZED', actual is 'ANALYZED'").build());
        this.init(FacetedDateEntity.class);
    }

    @Indexed
    @Entity
    public static class FacetedDateEntity {
        @DocumentId
        @Id
        Long id;
        @Field(analyze=Analyze.NO)
        @Facet
        Date myField;
    }

    @Indexed
    @Entity
    public static class SimpleLenientEntity {
        @DocumentId
        @Id
        Long id;
        @Field(index=Index.NO, store=Store.NO)
        Long myField;
    }

    @Indexed
    @Entity
    public static class SimpleStringEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        String myField;
    }

    @Indexed
    @Entity
    public static class SimpleDateEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Date myField;
    }

    @Indexed
    @Entity
    public static class SimpleBooleanEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Boolean myField;
    }
}

