/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.testutil.JsonHelper;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.elasticsearch.testutil.junit.SkipBelowElasticsearch50;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SkipBelowElasticsearch50.class})
public class Elasticsearch5SchemaCreationIT
extends SearchInitializationTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();
    private final IndexSchemaManagementStrategy strategy;

    @Parameterized.Parameters(name="With strategy {0}")
    public static EnumSet<IndexSchemaManagementStrategy> strategies() {
        return EnumSet.complementOf(EnumSet.of(IndexSchemaManagementStrategy.NONE, IndexSchemaManagementStrategy.VALIDATE));
    }

    public Elasticsearch5SchemaCreationIT(IndexSchemaManagementStrategy strategy) {
        this.strategy = strategy;
    }

    protected void init(Class<?> ... annotatedClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", this.strategy.getExternalName());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])annotatedClasses));
    }

    @Test
    public void dateField() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).ensureDoesNotExist().registerForCleanup();
        this.init(SimpleDateEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'keyword','store': true},'myField': {'type': 'date'}}}", this.elasticSearchClient.type(SimpleDateEntity.class).getMapping());
    }

    @Test
    public void booleanField() throws Exception {
        this.elasticSearchClient.index(SimpleBooleanEntity.class).ensureDoesNotExist().registerForCleanup();
        this.init(SimpleBooleanEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'keyword','store': true},'myField': {'type': 'boolean'}}}", this.elasticSearchClient.type(SimpleBooleanEntity.class).getMapping());
    }

    @Test
    public void keywordField() throws Exception {
        this.elasticSearchClient.index(SimpleKeywordEntity.class).ensureDoesNotExist().registerForCleanup();
        this.init(SimpleKeywordEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'keyword','store': true},'myField': {'type': 'keyword','norms': true}}}", this.elasticSearchClient.type(SimpleKeywordEntity.class).getMapping());
    }

    @Test
    public void textField() throws Exception {
        this.elasticSearchClient.index(SimpleTextEntity.class).ensureDoesNotExist().registerForCleanup();
        this.init(SimpleTextEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'keyword','store': true},'myField': {'type': 'text'}}}", this.elasticSearchClient.type(SimpleTextEntity.class).getMapping());
    }

    @Test
    public void textField_noNorms() throws Exception {
        this.elasticSearchClient.index(NoNormsTextEntity.class).ensureDoesNotExist().registerForCleanup();
        this.init(NoNormsTextEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'keyword','store': true},'myField': {'type': 'text','norms': false}}}", this.elasticSearchClient.type(NoNormsTextEntity.class).getMapping());
    }

    @Indexed
    @Entity
    private static class NoNormsTextEntity {
        @DocumentId
        @Id
        Long id;
        @Field(norms=Norms.NO)
        String myField;

        private NoNormsTextEntity() {
        }
    }

    @Indexed
    @Entity
    private static class SimpleTextEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        String myField;

        private SimpleTextEntity() {
        }
    }

    @Indexed
    @Entity
    private static class SimpleKeywordEntity {
        @DocumentId
        @Id
        Long id;
        @Field(analyze=Analyze.NO)
        String myField;

        private SimpleKeywordEntity() {
        }
    }

    @Indexed
    @Entity
    private static class SimpleDateEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Date myField;

        private SimpleDateEntity() {
        }
    }

    @Indexed
    @Entity
    private static class SimpleBooleanEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Boolean myField;

        private SimpleBooleanEntity() {
        }
    }
}

