/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.EnumSet;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.document.Document;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.test.util.impl.ExceptionMatcherBuilder;
import org.hibernate.testing.TestForIssue;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ElasticsearchSchemaMetadataErrorsIT
extends SearchInitializationTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();
    private IndexSchemaManagementStrategy strategy;

    @Parameterized.Parameters(name="With strategy {0}")
    public static EnumSet<IndexSchemaManagementStrategy> strategies() {
        return EnumSet.complementOf(EnumSet.of(IndexSchemaManagementStrategy.NONE));
    }

    public ElasticsearchSchemaMetadataErrorsIT(IndexSchemaManagementStrategy strategy) {
        this.strategy = strategy;
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2458")
    public void detectIncompleteNumericType() throws Exception {
        this.thrown.expect(ExceptionMatcherBuilder.isException(SearchException.class).withMessage("HSEARCH400018").withMessage("Unexpected numeric encoding type for field").withMessage("'" + EntityWithIncompleteNumericTypeField.class.getName() + "'").withMessage("'numericField'").build());
        this.elasticSearchClient.index(EntityWithIncompleteNumericTypeField.class).registerForCleanup();
        this.init(this.strategy, EntityWithIncompleteNumericTypeField.class);
    }

    private void init(IndexSchemaManagementStrategy strategy, Class<?> ... entityClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", strategy.getExternalName());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])entityClasses));
    }

    public static class FieldBridgeNotUsingDefaultField
    implements MetadataProvidingFieldBridge {
        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(name + "_string", FieldType.STRING);
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            luceneOptions.addFieldToDocument(name, (String)value, document);
        }
    }

    @Entity
    @Indexed
    private static class EntityWithIncompleteNumericTypeField {
        @Id
        @GeneratedValue
        Long id;
        @Field(bridge=@FieldBridge(impl=FieldBridgeNotUsingDefaultField.class))
        @NumericField
        String numericField;

        private EntityWithIncompleteNumericTypeField() {
        }
    }
}

