/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.DynamicBoost;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Normalizer;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.elasticsearch.testutil.junit.SkipFromElasticsearch52;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.hibernate.testing.TestForIssue;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

public class ElasticsearchUnsupportedFeaturesIT
extends SearchInitializationTestBase {
    @Rule
    public ExpectedLog4jLog logged = ExpectedLog4jLog.create();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void dynamicBoosting() throws Exception {
        this.logged.expectMessage("HSEARCH400032", new String[]{"@DynamicBoost", DynamicBoostingEntity.class.getSimpleName()});
        this.init(new Class[]{DynamicBoostingEntity.class});
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2726")
    @Category(value={SkipFromElasticsearch52.class})
    public void conflictingAnalyzerNormalizerDefinitions() throws Exception {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400087");
        this.thrown.expectMessage("same name");
        this.thrown.expectMessage("'standard'");
        this.init(new Class[]{EntityWithConflictingAnalyzerNormalizerDefinitions.class});
    }

    @Entity
    @Indexed
    @AnalyzerDef(name="standard", tokenizer=@TokenizerDef(factory=WhitespaceTokenizerFactory.class))
    @NormalizerDef(name="standard", filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class)})
    private static class EntityWithConflictingAnalyzerNormalizerDefinitions {
        @Id
        @GeneratedValue
        Long id;
        @Fields(value={@Field(analyzer=@Analyzer(definition="standard")), @Field(name="normalized", normalizer=@Normalizer(definition="standard"))})
        String myField;

        private EntityWithConflictingAnalyzerNormalizerDefinitions() {
        }
    }

    public static class CustomBoostStrategy
    implements BoostStrategy {
        public float defineBoost(Object value) {
            DynamicBoostingEntity entity = (DynamicBoostingEntity)value;
            return entity.getBoost().floatValue();
        }
    }

    @Indexed
    @Entity
    @DynamicBoost(impl=CustomBoostStrategy.class)
    public static class DynamicBoostingEntity {
        @Id
        @GeneratedValue
        private Integer id;
        private Float boost;
        @Field
        private String data;

        public Integer getId() {
            return this.id;
        }

        public Float getBoost() {
            return this.boost;
        }

        public void setBoost(Float boost) {
            this.boost = boost;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}

