/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.testutil.aws;

import java.util.Properties;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.hibernate.search.elasticsearch.client.spi.ElasticsearchHttpClientConfigurer;
import org.hibernate.search.elasticsearch.testutil.aws.AWSSigningRequestInterceptor;
import org.hibernate.search.util.StringHelper;

public class AWSElasticsearchHttpClientConfigurer
implements ElasticsearchHttpClientConfigurer {
    private static final String ACCESS_KEY_PROPERTY = "elasticsearch.aws.access_key";
    private static final String SECRET_KEY_PROPERTY = "elasticsearch.aws.secret_key";
    private static final String REGION_PROPERTY = "elasticsearch.aws.region";
    private static final String ELASTICSEARCH_SERVICE_NAME = "es";

    public void configure(HttpAsyncClientBuilder builder, Properties properties) {
        String accessKey = properties.getProperty(ACCESS_KEY_PROPERTY);
        String secretKey = properties.getProperty(SECRET_KEY_PROPERTY);
        String region = properties.getProperty(REGION_PROPERTY);
        if (StringHelper.isEmpty((String)accessKey) && StringHelper.isEmpty((String)secretKey) && StringHelper.isEmpty((String)region)) {
            return;
        }
        this.requireNonEmpty(accessKey, ACCESS_KEY_PROPERTY);
        this.requireNonEmpty(secretKey, SECRET_KEY_PROPERTY);
        this.requireNonEmpty(region, REGION_PROPERTY);
        AWSSigningRequestInterceptor interceptor = new AWSSigningRequestInterceptor(accessKey, secretKey, region, ELASTICSEARCH_SERVICE_NAME);
        builder.addInterceptorLast((HttpRequestInterceptor)interceptor);
    }

    private void requireNonEmpty(String value, String name) {
        if (StringHelper.isEmpty((String)value)) {
            throw new IllegalStateException("Missing value for property '" + name + "'.");
        }
    }
}

