/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.cfg;

import org.hibernate.search.elasticsearch.cfg.DynamicType;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;

public final class ElasticsearchEnvironment {
    public static final String SERVER_URI = "elasticsearch.host";
    public static final String SERVER_USERNAME = "elasticsearch.username";
    public static final String SERVER_PASSWORD = "elasticsearch.password";
    public static final String SERVER_REQUEST_TIMEOUT = "elasticsearch.request_timeout";
    public static final String SERVER_READ_TIMEOUT = "elasticsearch.read_timeout";
    public static final String SERVER_CONNECTION_TIMEOUT = "elasticsearch.connection_timeout";
    public static final String MAX_TOTAL_CONNECTION = "elasticsearch.max_total_connection";
    public static final String MAX_TOTAL_CONNECTION_PER_ROUTE = "elasticsearch.max_total_connection_per_route";
    public static final String DISCOVERY_ENABLED = "elasticsearch.discovery.enabled";
    public static final String DISCOVERY_REFRESH_INTERVAL = "elasticsearch.discovery.refresh_interval";
    public static final String DISCOVERY_SCHEME = "elasticsearch.discovery.default_scheme";
    public static final String INDEX_SCHEMA_MANAGEMENT_STRATEGY = "elasticsearch.index_schema_management_strategy";
    public static final String INDEX_MANAGEMENT_WAIT_TIMEOUT = "elasticsearch.index_management_wait_timeout";
    public static final String REQUIRED_INDEX_STATUS = "elasticsearch.required_index_status";
    public static final String REFRESH_AFTER_WRITE = "elasticsearch.refresh_after_write";
    public static final String SCROLL_BACKTRACKING_WINDOW_SIZE = "elasticsearch.scroll_backtracking_window_size";
    public static final String SCROLL_FETCH_SIZE = "elasticsearch.scroll_fetch_size";
    public static final String SCROLL_TIMEOUT = "elasticsearch.scroll_timeout";
    public static final String DYNAMIC_MAPPING = "elasticsearch.dynamic_mapping";
    public static final String ANALYSIS_DEFINITION_PROVIDER = "hibernate.search.elasticsearch.analysis_definition_provider";
    public static final String LOG_JSON_PRETTY_PRINTING = "elasticsearch.log.json_pretty_printing";

    private ElasticsearchEnvironment() {
    }

    public static final class Defaults {
        public static final DynamicType DYNAMIC_MAPPING = DynamicType.STRICT;
        public static final String SERVER_URI = "http://localhost:9200";
        public static final int SERVER_REQUEST_TIMEOUT = 60000;
        public static final int SERVER_READ_TIMEOUT = 60000;
        public static final int SERVER_CONNECTION_TIMEOUT = 3000;
        public static final int MAX_TOTAL_CONNECTION = 20;
        public static final int MAX_TOTAL_CONNECTION_PER_ROUTE = 2;
        public static final boolean DISCOVERY_ENABLED = false;
        public static final int DISCOVERY_REFRESH_INTERVAL = 10;
        public static final String DISCOVERY_SCHEME = "http";
        public static final IndexSchemaManagementStrategy INDEX_SCHEMA_MANAGEMENT_STRATEGY = IndexSchemaManagementStrategy.CREATE;
        public static final int INDEX_MANAGEMENT_WAIT_TIMEOUT = 10000;
        public static final ElasticsearchIndexStatus REQUIRED_INDEX_STATUS = ElasticsearchIndexStatus.GREEN;
        public static final boolean REFRESH_AFTER_WRITE = false;
        public static final int SCROLL_BACKTRACKING_WINDOW_SIZE = 10000;
        public static final int SCROLL_FETCH_SIZE = 1000;
        public static final int SCROLL_TIMEOUT = 60;
        public static final boolean LOG_JSON_PRETTY_PRINTING = false;
    }
}

