/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.query.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.regex.Pattern;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.elasticsearch.util.impl.FieldHelper;

abstract class FieldProjection {
    private static final Pattern DOT = Pattern.compile("\\.");

    FieldProjection() {
    }

    public abstract Object convertHit(JsonObject var1, ConversionContext var2);

    protected final JsonElement extractFieldValue(JsonObject parent, String projectedField) {
        String field = projectedField;
        if (FieldHelper.isEmbeddedField(projectedField)) {
            String[] parts = DOT.split(projectedField);
            field = parts[parts.length - 1];
            for (int i = 0; i < parts.length - 1; ++i) {
                JsonElement newParent = parent.get(parts[i]);
                if (newParent == null) {
                    return null;
                }
                parent = newParent.getAsJsonObject();
            }
        }
        return parent.getAsJsonObject().get(field);
    }
}

