/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl.translation;

import com.google.gson.JsonElement;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.settings.impl.translation.ParametersTransformer;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class ThrowingMandatoryStrippedParametersTransformer
implements ParametersTransformer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Class<?> factoryClass;
    private final String parameterName;
    private final String expectedValue;

    ThrowingMandatoryStrippedParametersTransformer(Class<?> factoryClass, String parameterName, String expectedValue) {
        this.factoryClass = factoryClass;
        this.parameterName = parameterName;
        this.expectedValue = expectedValue;
    }

    @Override
    public Map<String, JsonElement> transform(Map<String, String> luceneParameters) {
        String actualValue = luceneParameters.remove(this.parameterName);
        if (!this.expectedValue.equals(actualValue)) {
            throw log.invalidAnalysisFactoryParameter(this.factoryClass, this.parameterName, this.expectedValue, actualValue);
        }
        return Collections.emptyMap();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.factoryClass + "," + this.parameterName + "," + this.expectedValue + "]";
    }
}

