/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.PartialDocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.PartialPropertyMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;

public class FieldHelper {
    private static final Pattern DOT = Pattern.compile("\\.");

    private FieldHelper() {
    }

    private static ExtendedFieldType toExtendedFieldType(NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType) {
        switch (numericEncodingType) {
            case INTEGER: {
                return ExtendedFieldType.INTEGER;
            }
            case LONG: {
                return ExtendedFieldType.LONG;
            }
            case FLOAT: {
                return ExtendedFieldType.FLOAT;
            }
            case DOUBLE: {
                return ExtendedFieldType.DOUBLE;
            }
        }
        return ExtendedFieldType.UNKNOWN_NUMERIC;
    }

    public static ExtendedFieldType getType(PartialDocumentFieldMetadata fieldMetadata) {
        Class propertyClass;
        BridgeDefinedField overriddenField = (BridgeDefinedField)fieldMetadata.getBridgeDefinedFields().get(fieldMetadata.getPath().getAbsoluteName());
        if (overriddenField != null) {
            return FieldHelper.getType(overriddenField);
        }
        PartialPropertyMetadata propertyMetata = fieldMetadata.getSourceProperty();
        Class clazz = propertyClass = propertyMetata == null ? null : propertyMetata.getPropertyClass();
        if (propertyClass == null) {
            return ExtendedFieldType.UNKNOWN;
        }
        if (fieldMetadata.isNumeric()) {
            return FieldHelper.toExtendedFieldType(fieldMetadata.getNumericEncodingType());
        }
        return FieldHelper.getType(propertyClass);
    }

    public static ExtendedFieldType getType(Class<?> propertyClass) {
        if (Boolean.TYPE.equals(propertyClass) || Boolean.class.isAssignableFrom(propertyClass)) {
            return ExtendedFieldType.BOOLEAN;
        }
        if (Date.class.isAssignableFrom(propertyClass)) {
            return ExtendedFieldType.DATE;
        }
        if (Calendar.class.isAssignableFrom(propertyClass)) {
            return ExtendedFieldType.CALENDAR;
        }
        if (Instant.class.equals(propertyClass)) {
            return ExtendedFieldType.INSTANT;
        }
        if (LocalDate.class.equals(propertyClass)) {
            return ExtendedFieldType.LOCAL_DATE;
        }
        if (LocalTime.class.equals(propertyClass)) {
            return ExtendedFieldType.LOCAL_TIME;
        }
        if (LocalDateTime.class.equals(propertyClass)) {
            return ExtendedFieldType.LOCAL_DATE_TIME;
        }
        if (OffsetDateTime.class.equals(propertyClass)) {
            return ExtendedFieldType.OFFSET_DATE_TIME;
        }
        if (OffsetTime.class.equals(propertyClass)) {
            return ExtendedFieldType.OFFSET_TIME;
        }
        if (ZonedDateTime.class.equals(propertyClass)) {
            return ExtendedFieldType.ZONED_DATE_TIME;
        }
        if (Year.class.equals(propertyClass)) {
            return ExtendedFieldType.YEAR;
        }
        if (YearMonth.class.equals(propertyClass)) {
            return ExtendedFieldType.YEAR_MONTH;
        }
        if (MonthDay.class.equals(propertyClass)) {
            return ExtendedFieldType.MONTH_DAY;
        }
        return ExtendedFieldType.UNKNOWN;
    }

    public static ExtendedFieldType getType(BridgeDefinedField field) {
        FieldType type = field.getType();
        if (type == null) {
            return null;
        }
        switch (type) {
            case BOOLEAN: {
                return ExtendedFieldType.BOOLEAN;
            }
            case DATE: {
                return ExtendedFieldType.DATE;
            }
            case DOUBLE: {
                return ExtendedFieldType.DOUBLE;
            }
            case FLOAT: {
                return ExtendedFieldType.FLOAT;
            }
            case INTEGER: {
                return ExtendedFieldType.INTEGER;
            }
            case LONG: {
                return ExtendedFieldType.LONG;
            }
            case STRING: {
                return ExtendedFieldType.STRING;
            }
            case OBJECT: {
                return ExtendedFieldType.OBJECT;
            }
        }
        return ExtendedFieldType.UNKNOWN;
    }

    public static String[] getFieldNameParts(String fieldName) {
        String[] stringArray;
        boolean isEmbeddedField = FieldHelper.isEmbeddedField(fieldName);
        if (isEmbeddedField) {
            stringArray = DOT.split(fieldName);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fieldName;
        }
        return stringArray;
    }

    public static boolean isSortableField(TypeMetadata sourceType, PropertyMetadata sourceProperty, String fieldName) {
        Set sortableFields = sourceProperty != null ? sourceProperty.getSortableFieldMetadata() : sourceType.getClassBridgeSortableFieldMetadata();
        for (SortableFieldMetadata sortableField : sortableFields) {
            if (!fieldName.equals(sortableField.getAbsoluteName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmbeddedField(String field) {
        return field.contains(".");
    }

    public static String getEmbeddedFieldPath(String field) {
        return field.substring(0, field.lastIndexOf("."));
    }

    public static String getEmbeddedFieldPropertyName(String field) {
        return field.substring(field.lastIndexOf(".") + 1);
    }

    public static enum ExtendedFieldType {
        STRING,
        BOOLEAN,
        DATE,
        CALENDAR,
        INSTANT,
        LOCAL_DATE,
        LOCAL_TIME,
        LOCAL_DATE_TIME,
        OFFSET_DATE_TIME,
        OFFSET_TIME,
        ZONED_DATE_TIME,
        YEAR,
        YEAR_MONTH,
        MONTH_DAY,
        OBJECT,
        INTEGER{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        LONG{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        FLOAT{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        DOUBLE{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        UNKNOWN_NUMERIC{

            @Override
            public boolean isNumeric() {
                return true;
            }
        }
        ,
        UNKNOWN;


        public boolean isNumeric() {
            return false;
        }
    }
}

