/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan;

import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.infinispan.ClusterSharedConnectionProvider;
import org.hibernate.search.infinispan.impl.InfinispanDirectoryProvider;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.infinispan.manager.EmbeddedCacheManager;

public final class ClusterTestHelper {
    private ClusterTestHelper() {
    }

    public static FullTextSessionBuilder createClusterNode(Set<Class<?>> entityTypes, boolean exclusiveIndexUse) {
        return ClusterTestHelper.createClusterNode(entityTypes, exclusiveIndexUse, true, false);
    }

    public static FullTextSessionBuilder createClusterNode(Set<Class<?>> entityTypes, boolean exclusiveIndexUse, boolean setInfinispanDirectory, boolean setInfinispanIndexManager) {
        FullTextSessionBuilder node = new FullTextSessionBuilder();
        if (setInfinispanDirectory) {
            node.setProperty("hibernate.search.default.directory_provider", "infinispan");
        }
        if (setInfinispanIndexManager) {
            node.setProperty("hibernate.search.default.indexmanager", "infinispan");
        }
        node.setProperty("hibernate.search.default.indexwriter.chunk_size", "13");
        node.setProperty("hibernate.search.infinispan.configuration.transport_override_resourcename", "testing-flush-loopback.xml");
        node.setProperty("hibernate.hbm2ddl.auto", "create");
        node.setProperty("hibernate.search.default.exclusive_index_use", String.valueOf(exclusiveIndexUse));
        node.setProperty("hibernate.connection.provider_class", ClusterSharedConnectionProvider.class.getName());
        for (Class<?> entityType : entityTypes) {
            node.addAnnotatedClass(entityType);
        }
        return node.build();
    }

    public static void waitMembersCount(FullTextSessionBuilder node, Class<?> entityType, int expectedSize) {
        int currentSize = 0;
        int loopCounter = 0;
        while (currentSize < expectedSize) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new AssertionFailedError(e.getMessage());
            }
            currentSize = ClusterTestHelper.clusterSize(node, entityType);
            if (loopCounter <= 200) continue;
            throw new AssertionFailedError("timeout while waiting for all nodes to join in cluster");
        }
    }

    public static int clusterSize(FullTextSessionBuilder node, Class<?> entityType) {
        SearchFactoryIntegrator searchFactory = (SearchFactoryIntegrator)node.getSearchFactory();
        EntityIndexBinding indexBinding = searchFactory.getIndexBinding(entityType);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexBinding.getIndexManagers()[0];
        InfinispanDirectoryProvider directoryProvider = (InfinispanDirectoryProvider)indexManager.getDirectoryProvider();
        EmbeddedCacheManager cacheManager = directoryProvider.getCacheManager();
        List members = cacheManager.getMembers();
        return members.size();
    }
}

