/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded.test.cache.remote;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.infinispan.cdi.embedded.test.Deployments;
import org.infinispan.cdi.embedded.test.cache.remote.Small;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestResourceTrackingListener;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={TestResourceTrackingListener.class})
@Test(groups={"functional"}, testName="cdi.test.cache.remote.SpecificCacheManagerTest")
public class SpecificCacheManagerTest
extends Arquillian {
    private static final String SERVER_LIST_KEY = "infinispan.client.hotrod.server_list";
    private static HotRodServer hotRodServer;
    private static EmbeddedCacheManager embeddedCacheManager;
    @Inject
    @Small
    private RemoteCache<String, String> cache;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)Deployments.baseDeployment().addClass(SpecificCacheManagerTest.class)).addClass(Small.class);
    }

    @BeforeClass
    public void beforeMethod() {
        embeddedCacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false)));
        embeddedCacheManager.defineConfiguration("small", embeddedCacheManager.getDefaultCacheConfiguration());
        embeddedCacheManager.getCache("small");
        hotRodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)embeddedCacheManager);
    }

    @AfterClass(alwaysRun=true)
    public void afterMethod() {
        if (hotRodServer != null) {
            hotRodServer.stop();
        }
        if (embeddedCacheManager != null) {
            embeddedCacheManager.stop();
        }
        ThreadLeakChecker.ignoreThreadsContaining((String)"HotRod-client-async-pool-");
    }

    public void testSpecificCacheManager() {
        this.cache.put((Object)"pete", (Object)"British");
        this.cache.put((Object)"manik", (Object)"Sri Lankan");
        Assert.assertEquals((String)this.cache.getName(), (String)"small");
        Assert.assertEquals((String)((String)this.cache.get((Object)"pete")), (String)"British");
        Assert.assertEquals((String)((String)this.cache.get((Object)"manik")), (String)"Sri Lankan");
    }

    @Small
    @Produces
    @ApplicationScoped
    public static RemoteCacheManager smallRemoteCacheManager() {
        return new RemoteCacheManager(HotRodClientTestingUtil.newRemoteConfigurationBuilder((HotRodServer)hotRodServer).build());
    }

    static void stopRemoteCacheManager(@Disposes @Any RemoteCacheManager remoteCacheManager) {
        remoteCacheManager.stop();
    }
}

