/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded.test.cachemanager.remote;

import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.infinispan.cdi.embedded.test.Deployments;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.test.TestResourceTrackingListener;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.testng.Assert;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={TestResourceTrackingListener.class})
@Test(groups={"functional"}, testName="cdi.test.cachemanager.remote.DefaultCacheManagerOverrideTest")
public class DefaultCacheManagerOverrideTest
extends Arquillian {
    private static final String SERVER_LIST_KEY = "infinispan.client.hotrod.server_list";
    private static final String SERVER_LIST_VALUE = "foo:15444";
    @Inject
    private RemoteCacheManager remoteCacheManager;

    @Deployment
    public static Archive<?> deployment() {
        return Deployments.baseDeployment().addClass(DefaultCacheManagerOverrideTest.class);
    }

    public void testDefaultRemoteCacheManagerOverride() {
        ThreadLeakChecker.ignoreThreadsContaining((String)"HotRod-client-async-pool-");
        Properties properties = this.remoteCacheManager.getConfiguration().properties();
        Assert.assertEquals((String)properties.getProperty(SERVER_LIST_KEY), (String)SERVER_LIST_VALUE);
    }

    @Produces
    @ApplicationScoped
    public RemoteCacheManager defaultRemoteCacheManager() {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServers(SERVER_LIST_VALUE);
        return new RemoteCacheManager(clientBuilder.build());
    }

    static void stopRemoteCacheManager(@Disposes RemoteCacheManager remoteCacheManager) {
        remoteCacheManager.stop();
    }
}

