/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded.test.cache.remote;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.infinispan.cdi.embedded.test.Deployments;
import org.infinispan.cdi.remote.Remote;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestResourceTrackingListener;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={TestResourceTrackingListener.class})
@Test(groups={"functional"}, testName="cdi.test.cache.remote.DefaultCacheTest")
public class DefaultCacheTest
extends Arquillian {
    private static final String SERVER_LIST_KEY = "infinispan.client.hotrod.server_list";
    private static HotRodServer hotRodServer;
    private static EmbeddedCacheManager embeddedCacheManager;
    @Inject
    @Remote
    private RemoteCache<String, String> cache;
    @Inject
    private RemoteCache<String, String> remoteCache;

    @Deployment
    public static Archive<?> deployment() {
        return Deployments.baseDeployment().addClass(DefaultCacheTest.class);
    }

    @BeforeClass
    public void beforeMethod() {
        embeddedCacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false)));
        hotRodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)embeddedCacheManager);
    }

    @AfterClass(alwaysRun=true)
    public void afterMethod() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{embeddedCacheManager});
        ServerTestingUtil.killServer((AbstractProtocolServer)hotRodServer);
    }

    public void testDefaultCache() {
        this.cache.put((Object)"pete", (Object)"British");
        this.cache.put((Object)"manik", (Object)"Sri Lankan");
        Assert.assertEquals((String)((String)this.cache.get((Object)"pete")), (String)"British");
        Assert.assertEquals((String)((String)this.cache.get((Object)"manik")), (String)"Sri Lankan");
        Assert.assertEquals((String)((String)this.remoteCache.get((Object)"pete")), (String)"British");
        Assert.assertEquals((String)((String)this.remoteCache.get((Object)"manik")), (String)"Sri Lankan");
    }

    @Produces
    @ApplicationScoped
    public static RemoteCacheManager defaultRemoteCacheManager() {
        return new RemoteCacheManager(new ConfigurationBuilder().addServers("127.0.0.1:" + hotRodServer.getPort()).build());
    }
}

