/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import java.util.function.BiFunction;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.tx.util.KeyValueGenerator;
import org.infinispan.client.hotrod.tx.util.TransactionSetup;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.APITest")
public class APITest<K, V>
extends MultiHotRodServersTest {
    private static final int NR_NODES = 2;
    private static final String CACHE_NAME = "api-cache";
    private KeyValueGenerator<K, V> kvGenerator;
    private boolean useJavaSerialization;

    public Object[] factory() {
        return new Object[]{super.keyValueGenerator(KeyValueGenerator.BYTE_ARRAY_GENERATOR), super.keyValueGenerator(KeyValueGenerator.STRING_GENERATOR)};
    }

    public void testCompute(Method method) {
        RemoteCache<K, V> cache = this.remoteCache();
        K key = this.kvGenerator.generateKey(method, 0);
        V value = this.kvGenerator.generateValue(method, 0);
        BiFunction<Object, Object, Object> sameValueFunction = (k, v) -> v;
        cache.put(key, value);
        this.kvGenerator.assertValueEquals(value, cache.compute(key, sameValueFunction));
        this.kvGenerator.assertValueEquals(value, cache.get(key));
        Object value1 = this.kvGenerator.generateValue(method, 1);
        BiFunction<Object, Object, Object> differentValueFunction = (k, v) -> value1;
        this.kvGenerator.assertValueEquals(value1, cache.compute(key, differentValueFunction));
        this.kvGenerator.assertValueEquals(value1, cache.get(key));
        K notPresentKey = this.kvGenerator.generateKey(method, 1);
        this.kvGenerator.assertValueEquals(value1, cache.compute(notPresentKey, differentValueFunction));
        this.kvGenerator.assertValueEquals(value1, cache.get(notPresentKey));
        BiFunction<Object, Object, Object> mappingToNull = (k, v) -> null;
        AssertJUnit.assertNull((String)"mapping to null returns null", (Object)cache.compute(key, mappingToNull));
        AssertJUnit.assertNull((String)"the key is removed", (Object)cache.get(key));
        int cacheSizeBeforeNullValueCompute = cache.size();
        K nonExistantKey = this.kvGenerator.generateKey(method, 3);
        AssertJUnit.assertNull((String)"mapping to null returns null", (Object)cache.compute(nonExistantKey, mappingToNull));
        AssertJUnit.assertNull((String)"the key does not exist", (Object)cache.get(nonExistantKey));
        AssertJUnit.assertEquals((int)cacheSizeBeforeNullValueCompute, (int)cache.size());
        RuntimeException computeRaisedException = new RuntimeException("hi there");
        BiFunction<Object, Object, Object> mappingToException = (k, v) -> {
            throw computeRaisedException;
        };
        try {
            cache.compute(key, mappingToException);
            AssertJUnit.fail((String)"Should have thrown an exception!");
        }
        catch (TransportException t) {
            Throwable cause = t.getCause();
            AssertJUnit.assertTrue((String)("Cause was: " + cause), (boolean)(cause instanceof RuntimeException));
            AssertJUnit.assertEquals((String)"hi there", (String)cause.getMessage());
        }
    }

    protected String[] parameterNames() {
        return (String[])APITest.concat((Object[])super.parameterNames(), null);
    }

    protected Object[] parameterValues() {
        return APITest.concat((Object[])super.parameterValues(), (Object[])new Object[]{this.kvGenerator.toString()});
    }

    protected String parameters() {
        return "[" + this.kvGenerator + "]";
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cacheBuilder = APITest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        this.createHotRodServers(2, new org.infinispan.configuration.cache.ConfigurationBuilder());
        this.defineInAll(CACHE_NAME, cacheBuilder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        ConfigurationBuilder clientBuilder = super.createHotRodClientConfigurationBuilder(serverPort);
        clientBuilder.forceReturnValues(false);
        TransactionSetup.amendJTA(clientBuilder);
        if (this.useJavaSerialization) {
            clientBuilder.marshaller((Marshaller)new JavaSerializationMarshaller()).addJavaSerialWhiteList(new String[]{"\\Q[\\ELjava.lang.Object;"});
        }
        return clientBuilder;
    }

    private APITest<K, V> keyValueGenerator(KeyValueGenerator<K, V> kvGenerator) {
        this.kvGenerator = kvGenerator;
        return this;
    }

    public APITest<K, V> javaSerialization() {
        this.useJavaSerialization = true;
        return this;
    }

    private RemoteCache<K, V> remoteCache() {
        return this.client(0).getCache(CACHE_NAME);
    }
}

