/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ForceReturnValuesIdentityTest", groups={"functional"})
@CleanupAfterMethod
public class ForceReturnValuesIdentityTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotRodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        return this.cacheManager;
    }

    @AfterMethod
    void shutdown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testSameInstanceForSameForceReturnValues() {
        RemoteCache rcDontForceReturn = this.remoteCacheManager.getCache(false);
        RemoteCache rcDontForceReturn2 = this.remoteCacheManager.getCache(false);
        AssertJUnit.assertSame((String)"RemoteCache instances should be the same", (Object)rcDontForceReturn, (Object)rcDontForceReturn2);
        RemoteCache rcForceReturn = this.remoteCacheManager.getCache(true);
        RemoteCache rcForceReturn2 = this.remoteCacheManager.getCache(true);
        AssertJUnit.assertSame((String)"RemoteCache instances should be the same", (Object)rcForceReturn, (Object)rcForceReturn2);
    }

    public void testDifferentInstancesForDifferentForceReturnValues() {
        RemoteCache rcDontForceReturn = this.remoteCacheManager.getCache(false);
        RemoteCache rcForceReturn = this.remoteCacheManager.getCache(true);
        AssertJUnit.assertNotSame((String)"RemoteCache instances should not be the same", (Object)rcDontForceReturn, (Object)rcForceReturn);
        String rv = (String)rcDontForceReturn.put((Object)"Key", (Object)"Value");
        AssertJUnit.assertNull((Object)rv);
        rv = (String)rcDontForceReturn.put((Object)"Key", (Object)"Value2");
        AssertJUnit.assertNull((Object)rv);
        rv = (String)rcForceReturn.put((Object)"Key2", (Object)"Value");
        AssertJUnit.assertNull((Object)rv);
        rv = (String)rcForceReturn.put((Object)"Key2", (Object)"Value2");
        AssertJUnit.assertNotNull((Object)rv);
        AssertJUnit.assertEquals((String)"Previous value should be 'Value'", (String)"Value", (String)rv);
    }
}

