/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.OldClientCustomEventsTest")
public class OldClientCustomEventsTest
extends SingleHotRodServerTest {
    private static final String MAGIC_KEY = "key-42";
    private static final ProtocolVersion VERSION = ProtocolVersion.PROTOCOL_VERSION_27;

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(this.cacheManager, builder);
        server.addCacheEventFilterFactory("static-filter-factory", new EventLogListener.StaticCacheEventFilterFactory<String>(MAGIC_KEY));
        server.addCacheEventConverterFactory("static-converter-factory", new CustomEventLogListener.StaticConverterFactory());
        return server;
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue()).version(VERSION);
        return new InternalRemoteCacheManager(builder.build());
    }

    public void testFilteredEvents() {
        EventLogListener.StaticFilteredEventLogListener l = new EventLogListener.StaticFilteredEventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, new Object[]{"match"}, new Object[0], remote -> {
            l.expectNoEvents();
            remote.put((Object)"key-1", (Object)"one");
            remote.put((Object)"key-2", (Object)"two");
            remote.put((Object)"key-3", (Object)"three");
            l.expectNoEvents();
            remote.put((Object)MAGIC_KEY, (Object)"hot key");
            l.expectOnlyCreatedEvent(MAGIC_KEY);
        });
    }

    public void testConvertedEvents() {
        CustomEventLogListener.StaticCustomEventLogListener l = new CustomEventLogListener.StaticCustomEventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)"key-1", (Object)"one");
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<String>("key-1", "one", 0));
        });
    }
}

