/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AccountPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.MultipleIndexedCacheTest", groups={"functional"})
public class MultipleIndexedCacheTest
extends MultiHotRodServersTest {
    private static final String USER_CACHE = "users";
    private static final String ACCOUNT_CACHE = "accounts";
    private static final String DATA_CACHE = "lucene_data_dist";
    private static final String METADATA_CACHE = "lucene_metadata_dist";
    private static final String LOCKING_CACHE = "lucene_locking_dist";
    private static final int NODES = 3;
    private static final int NUM_ENTRIES = 50;
    private RemoteCache<Integer, UserPB> userCache;
    private RemoteCache<Integer, AccountPB> accountCache;

    public Configuration buildIndexedConfig(String lockCache, String dataCache, String metadataCache) {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)MultipleIndexedCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.indexing().index(Index.PRIMARY_OWNER).addProperty("default.indexmanager", InfinispanIndexManager.class.getName()).addProperty("default.metadata_cachename", metadataCache).addProperty("default.data_cachename", dataCache).addProperty("default.locking_cachename", lockCache);
        return builder.build();
    }

    public Configuration getNonIndexLockConfig() {
        return MultipleIndexedCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false).build();
    }

    public Configuration getNonIndexDataConfig() {
        return MultipleIndexedCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false).build();
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder defaultConfiguration = new org.infinispan.configuration.cache.ConfigurationBuilder();
        this.createHotRodServers(3, defaultConfiguration);
        this.cacheManagers.forEach(cm -> {
            cm.defineConfiguration(USER_CACHE, this.buildIndexedConfig(LOCKING_CACHE, DATA_CACHE, METADATA_CACHE));
            cm.defineConfiguration(ACCOUNT_CACHE, this.buildIndexedConfig(LOCKING_CACHE, DATA_CACHE, METADATA_CACHE));
            cm.defineConfiguration(METADATA_CACHE, this.getNonIndexDataConfig());
            cm.defineConfiguration(DATA_CACHE, this.getNonIndexDataConfig());
            cm.defineConfiguration(LOCKING_CACHE, this.getNonIndexLockConfig());
            cm.getCache(USER_CACHE);
            cm.getCache(ACCOUNT_CACHE);
        });
        this.waitForClusterToForm(new String[]{USER_CACHE, ACCOUNT_CACHE});
        this.userCache = this.client(0).getCache(USER_CACHE);
        this.accountCache = this.client(0).getCache(ACCOUNT_CACHE);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        return super.createHotRodClientConfigurationBuilder(serverPort).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    @BeforeClass(alwaysRun=true)
    protected void registerSerCtx() throws Exception {
        ProtobufMetadataManager protobufMetadataManager = (ProtobufMetadataManager)this.manager(0).getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        protobufMetadataManager.registerProtofile("bank.proto", Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
        for (RemoteCacheManager rcm : this.clients) {
            MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)rcm));
        }
    }

    @Test
    public void testMassIndexing() {
        this.getAccountsPB().forEach(a -> this.accountCache.put((Object)a.getId(), a));
        this.getUsersPB().forEach(u -> this.userCache.put((Object)u.getId(), u));
        Assert.assertEquals((int)this.query(AccountPB.class, this.accountCache, "description:account1"), (int)1);
        Assert.assertEquals((int)this.query(UserPB.class, this.userCache, "name:name1"), (int)1);
        this.reindex(ACCOUNT_CACHE);
        Assert.assertEquals((int)this.query(AccountPB.class, this.accountCache, "description:account1"), (int)1);
        Assert.assertEquals((int)this.query(UserPB.class, this.userCache, "name:name1"), (int)1);
        this.reindex(USER_CACHE);
        Assert.assertEquals((int)this.query(AccountPB.class, this.accountCache, "description:account1"), (int)1);
        Assert.assertEquals((int)this.query(UserPB.class, this.userCache, "name:name1"), (int)1);
    }

    private void reindex(String cacheName) {
        Cache cache = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache(cacheName);
        MassIndexer massIndexer = org.infinispan.query.Search.getSearchManager((Cache)cache).getMassIndexer();
        massIndexer.start();
    }

    private <T> int query(Class<T> entity, RemoteCache<?, ?> cache, String query) {
        String[] fields = query.split(":");
        Query q = Search.getQueryFactory(cache).from(entity).having(fields[0]).eq((Object)fields[1]).build();
        return q.list().size();
    }

    private List<AccountPB> getAccountsPB() {
        return IntStream.range(0, 50).boxed().map(i -> {
            AccountPB accountPB = new AccountPB();
            accountPB.setId((int)i);
            accountPB.setDescription("account" + i);
            accountPB.setCreationDate(new Date());
            return accountPB;
        }).collect(Collectors.toList());
    }

    private List<UserPB> getUsersPB() {
        return IntStream.range(0, 50).boxed().map(i -> {
            UserPB userPB = new UserPB();
            userPB.setId((int)i);
            userPB.setName("name" + i);
            userPB.setSurname("surname" + i);
            return userPB;
        }).collect(Collectors.toList());
    }
}

