/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.IOException;
import java.util.List;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.query.RemoteQueryFactory;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.RemoteQueryTestUtils;
import org.infinispan.client.hotrod.query.testdomain.protobuf.ModelFactoryPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.NotIndexedMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Index;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.query.dsl.embedded.QueryDslConditionsTest;
import org.infinispan.query.dsl.embedded.testdomain.Account;
import org.infinispan.query.dsl.embedded.testdomain.ModelFactory;
import org.infinispan.query.remote.impl.ProgrammaticSearchMappingProviderImpl;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.RemoteQueryDslConditionsTest")
public class RemoteQueryDslConditionsTest
extends QueryDslConditionsTest {
    private static final String NOT_INDEXED_PROTO_SCHEMA = "package sample_bank_account;\n/* @Indexed(false) */\nmessage NotIndexed {\n\toptional string notIndexedField = 1;\n}\n";
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected Cache<Object, Object> cache;

    protected ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.DEFAULT_PROTOCOL_VERSION;
    }

    protected QueryFactory getQueryFactory() {
        return Search.getQueryFactory(this.remoteCache);
    }

    protected ModelFactory getModelFactory() {
        return ModelFactoryPB.INSTANCE;
    }

    protected RemoteCache<Object, Object> getCacheForQuery() {
        return this.remoteCache;
    }

    protected Cache<Object, Object> getEmbeddedCache() {
        return this.cache;
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cfg = this.getConfigurationBuilder();
        this.createClusteredCaches(1, cfg, true, new String[0]);
        this.cache = this.manager(0).getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        clientBuilder.version(this.getProtocolVersion());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        this.initProtoSchema(this.remoteCacheManager);
    }

    protected void initProtoSchema(RemoteCacheManager remoteCacheManager) throws IOException {
        RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)this.loadSchema());
        metadataCache.put((Object)"not_indexed.proto", (Object)NOT_INDEXED_PROTO_SCHEMA);
        RemoteQueryTestUtils.checkSchemaErrors((RemoteCache<String, String>)metadataCache);
        SerializationContext serCtx = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)remoteCacheManager);
        MarshallerRegistration.registerMarshallers(serCtx);
        serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"not_indexed.proto", (String)NOT_INDEXED_PROTO_SCHEMA));
        serCtx.registerMarshaller((BaseMarshaller)new NotIndexedMarshaller());
    }

    protected String loadSchema() throws IOException {
        return Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return builder;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testIndexPresence() {
        SearchIntegrator searchIntegrator = (SearchIntegrator)org.infinispan.query.Search.getSearchManager(this.cache).unwrap(SearchIntegrator.class);
        AssertJUnit.assertTrue((boolean)searchIntegrator.getIndexBindings().containsKey(ProtobufValueWrapper.INDEXING_TYPE));
        AssertJUnit.assertNotNull((Object)searchIntegrator.getIndexManager(ProgrammaticSearchMappingProviderImpl.getIndexName((String)this.cache.getName())));
    }

    public void testQueryFactoryType() {
        AssertJUnit.assertEquals(RemoteQueryFactory.class, this.getQueryFactory().getClass());
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN028503:.*")
    public void testInvalidEmbeddedAttributeQuery() {
        super.testInvalidEmbeddedAttributeQuery();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN014027: The property path 'addresses.postCode' cannot be projected because it is multi-valued")
    public void testRejectProjectionOfRepeatedProperty() {
        super.testRejectProjectionOfRepeatedProperty();
    }

    public void testSampleDomainQuery9() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"date"}).having("date").between((Object)this.makeDate("2013-01-01"), (Object)this.makeDate("2013-01-31")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)4, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(2)).length);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(3)).length);
        for (int i = 0; i < 4; ++i) {
            Long d = (Long)((Object[])list.get(i))[0];
            AssertJUnit.assertTrue((d.compareTo(this.makeDate("2013-01-31").getTime()) <= 0 ? 1 : 0) != 0);
            AssertJUnit.assertTrue((d.compareTo(this.makeDate("2013-01-01").getTime()) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testDefaultValue() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).orderBy("description", SortOrder.ASC).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((String)"Checking account", (String)((Account)list.get(0)).getDescription());
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN014026: The expression 'surname' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testGroupBy3() {
        super.testGroupBy3();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN014021: Queries containing grouping and aggregation functions must use projections.")
    public void testGroupBy5() {
        super.testGroupBy5();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="java.lang.IllegalStateException: Aggregation SUM cannot be applied to property of type java.lang.String")
    public void testGroupBy6() {
        super.testGroupBy6();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN028515: Cannot have aggregate functions in the WHERE clause : SUM.")
    public void testGroupBy7() {
        super.testGroupBy7();
    }

    public void testDateGrouping1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"date"}).having("date").between((Object)this.makeDate("2013-02-15"), (Object)this.makeDate("2013-03-15")).groupBy(new String[]{"date"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27").getTime(), (Object)((Object[])list.get(0))[0]);
    }

    public void testDateGrouping2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.count((String)"date"), Expression.min((String)"date")}).having("description").eq((Object)"Hotel").groupBy(new String[]{"id"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27").getTime(), (Object)((Object[])list.get(0))[1]);
    }

    public void testDateGrouping3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.min((String)"date"), Expression.count((String)"date")}).having("description").eq((Object)"Hotel").groupBy(new String[]{"id"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27").getTime(), (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[1]);
    }

    public void testDuplicateDateProjection() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "date", "date"}).having("description").eq((Object)"Hotel").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)3, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)3, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27").getTime(), (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27").getTime(), (Object)((Object[])list.get(0))[2]);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="ISPN014825: Query parameter 'param2' was not set")
    public void testMissingParamWithParameterMap() {
        super.testMissingParamWithParameterMap();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="ISPN014825: Query parameter 'param2' was not set")
    public void testMissingParam() {
        super.testMissingParam();
    }

    public void testComplexQuery() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.avg((String)"amount"), Expression.sum((String)"amount"), Expression.count((String)"date"), Expression.min((String)"date"), Expression.max((String)"accountId")}).having("isDebit").eq((Object)Expression.param((String)"param")).orderBy(Expression.avg((String)"amount"), SortOrder.DESC).orderBy(Expression.count((String)"date"), SortOrder.DESC).orderBy(Expression.max((String)"amount"), SortOrder.ASC).build();
        q.setParameter("param", (Object)true);
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)5, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((double)143.50909, (double)((Double)((Object[])list.get(0))[0]), (double)1.0E-4);
        AssertJUnit.assertEquals((double)7893.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
        AssertJUnit.assertEquals((Object)55L, (Object)((Object[])list.get(0))[2]);
        AssertJUnit.assertEquals(Long.class, ((Object[])list.get(0))[3].getClass());
        AssertJUnit.assertEquals((Object)this.makeDate("2013-01-01").getTime(), (Object)((Object[])list.get(0))[3]);
        AssertJUnit.assertEquals((Object)2, (Object)((Object[])list.get(0))[4]);
    }

    public void testDateFilteringWithGroupBy() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"date"}).having("date").between((Object)this.makeDate("2013-02-15"), (Object)this.makeDate("2013-03-15")).groupBy(new String[]{"date"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals(Long.class, ((Object[])list.get(0))[0].getClass());
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27").getTime(), (Object)((Object[])list.get(0))[0]);
    }

    public void testAggregateDate() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.count((String)"date"), Expression.min((String)"date")}).having("description").eq((Object)"Hotel").groupBy(new String[]{"id"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals(Long.class, ((Object[])list.get(0))[1].getClass());
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27").getTime(), (Object)((Object[])list.get(0))[1]);
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN014023: Using the multi-valued property path 'addresses.street' in the GROUP BY clause is not currently supported")
    public void testGroupByMustNotAcceptRepeatedProperty() {
        super.testGroupByMustNotAcceptRepeatedProperty();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN014024: The property path 'addresses.street' cannot be used in the ORDER BY clause because it is multi-valued")
    public void testOrderByMustNotAcceptRepeatedProperty() {
        super.testOrderByMustNotAcceptRepeatedProperty();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN028515: Cannot have aggregate functions in the WHERE clause : MIN.")
    public void testRejectAggregationsInWhereClause() {
        super.testRejectAggregationsInWhereClause();
    }
}

