/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.test.FixedServerBalancing;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Index;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.ReplicationIndexTest")
public class ReplicationIndexTest
extends MultiHotRodServersTest {
    public static final String CACHE_NAME = "test-cache";
    public static final String PROTO_FILE = "file.proto";
    public static final int ENTRIES = 2;
    private final AtomicInteger serverCount = new AtomicInteger(0);

    protected void addNode() throws IOException {
        int index = this.serverCount.incrementAndGet();
        this.addHotRodServer(ReplicationIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC));
        EmbeddedCacheManager cacheManager = this.manager(index - 1);
        org.infinispan.configuration.cache.ConfigurationBuilder builder = ReplicationIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)this.isTransactional());
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap");
        cacheManager.defineConfiguration(CACHE_NAME, builder.build());
        Cache cache = cacheManager.getCache(CACHE_NAME);
        TestingUtil.blockUntilViewReceived((Cache)cache, (int)index);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)cache, (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        Collection caches = this.cacheManagers.stream().map(cm -> cm.getCache(CACHE_NAME)).collect(Collectors.toList());
        TestingUtil.waitForNoRebalance((Collection)caches);
        RemoteCacheManager remoteCacheManager = this.createClient(index - 1);
        this.clients.add(remoteCacheManager);
        SerializationContext serCtx = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)remoteCacheManager);
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String protoFile = protoSchemaBuilder.fileName(PROTO_FILE).addClass(Entity.class).build(serCtx);
        RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)PROTO_FILE, (Object)protoFile);
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
    }

    protected boolean isTransactional() {
        return false;
    }

    @Override
    protected RemoteCacheManager createClient(int i) {
        HotRodServer server = this.server(i);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host(server.getHost()).port(server.getPort().intValue()).marshaller((Marshaller)new ProtoStreamMarshaller()).balancingStrategy(() -> new FixedServerBalancing(server));
        return new InternalRemoteCacheManager(clientBuilder.build());
    }

    protected void createCacheManagers() throws Throwable {
        this.addNode();
    }

    private int queryCount(String query, RemoteCache<?, ?> remoteCache) {
        return Search.getQueryFactory(remoteCache).create(query).getResultSize();
    }

    @Test
    public void testIndexingDuringStateTransfer() throws IOException {
        RemoteCache remoteCache = ((RemoteCacheManager)this.clients.get(0)).getCache(CACHE_NAME);
        for (int i = 0; i < 2; ++i) {
            remoteCache.put((Object)i, (Object)Entity.create("name" + i));
        }
        this.assertIndexed(remoteCache);
        this.addNode();
        RemoteCache secondRemoteCache = ((RemoteCacheManager)this.clients.get(1)).getCache(CACHE_NAME);
        this.assertIndexed(secondRemoteCache);
    }

    private void assertIndexed(RemoteCache<?, ?> remoteCache) {
        AssertJUnit.assertEquals((int)2, (int)remoteCache.size());
        AssertJUnit.assertEquals((int)2, (int)this.queryCount("FROM Entity", remoteCache));
        AssertJUnit.assertEquals((int)1, (int)this.queryCount("FROM Entity where name:'name1'", remoteCache));
    }

    @ProtoDoc(value="@Indexed")
    static class Entity {
        private String name;

        static Entity create(String name) {
            Entity entity = new Entity();
            entity.setName(name);
            return entity;
        }

        @ProtoDoc(value="@Field(index=Index.YES, analyze = Analyze.YES, store = Store.NO)")
        @ProtoField(number=1, required=true)
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

