/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.ExtendedMetadata;
import io.smallrye.metrics.ExtendedMetadataAndTags;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.eclipse.microprofile.metrics.Tag;
import org.jboss.logging.Logger;

public class JmxWorker {
    private static final Logger log = Logger.getLogger((String)"io.smallrye.metrics");
    private static final String PLACEHOLDER = "%s";
    private static MBeanServer mbs;
    private static JmxWorker worker;

    private JmxWorker() {
    }

    public static JmxWorker instance() {
        if (worker == null) {
            worker = new JmxWorker();
            mbs = ManagementFactory.getPlatformMBeanServer();
        }
        return worker;
    }

    public Number getValue(String mbeanExpression) {
        if (mbeanExpression == null) {
            throw new IllegalArgumentException("MBean Expression is null");
        }
        if (!mbeanExpression.contains("/")) {
            throw new IllegalArgumentException(mbeanExpression);
        }
        int slashIndex = mbeanExpression.indexOf(47);
        String mbean = mbeanExpression.substring(0, slashIndex);
        String attName = mbeanExpression.substring(slashIndex + 1);
        String subItem = null;
        if (attName.contains("#")) {
            int hashIndex = attName.indexOf(35);
            subItem = attName.substring(hashIndex + 1);
            attName = attName.substring(0, hashIndex);
        }
        try {
            ObjectName objectName = new ObjectName(mbean);
            Object attribute = mbs.getAttribute(objectName, attName);
            if (attribute instanceof Number) {
                return (Number)attribute;
            }
            if (attribute instanceof CompositeData) {
                CompositeData compositeData = (CompositeData)attribute;
                return (Number)compositeData.get(subItem);
            }
            throw new IllegalArgumentException(mbeanExpression);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void expandMultiValueEntries(List<ExtendedMetadataAndTags> entries) {
        ArrayList<ExtendedMetadataAndTags> result = new ArrayList<ExtendedMetadataAndTags>();
        ArrayList<ExtendedMetadataAndTags> toBeRemoved = new ArrayList<ExtendedMetadataAndTags>(entries.size());
        for (ExtendedMetadataAndTags entry : entries) {
            if (!entry.getMetadata().isMulti()) continue;
            String name = entry.getMetadata().getMbean();
            int slashIndex = name.indexOf(47);
            if (slashIndex < 0) {
                toBeRemoved.add(entry);
                continue;
            }
            String queryableName = name.substring(0, slashIndex);
            String attName = name.substring(slashIndex + 1);
            try {
                ObjectName objectNameWithPlaceholders = new ObjectName(queryableName);
                Map<String, String> keyHolders = this.findKeyForValueToBeReplaced(objectNameWithPlaceholders);
                ObjectName objectName = new ObjectName(queryableName.replaceAll("%s(\\d)?+", "*"));
                Set<ObjectName> objNames = mbs.queryNames(objectName, null);
                for (ObjectName oName : objNames) {
                    String newName = entry.getMetadata().getName();
                    if (!newName.contains(PLACEHOLDER) && entry.getTags().isEmpty()) {
                        log.warn((Object)("Name [" + newName + "] did not contain a %s or any tags, no replacement will be done, check the configuration"));
                    }
                    String newDisplayName = entry.getMetadata().getDisplayName();
                    String newDescription = entry.getMetadata().getDescription().orElse("");
                    List<Tag> newTags = new ArrayList<Tag>(entry.getTags());
                    for (Map.Entry<String, String> keyHolder : keyHolders.entrySet()) {
                        String keyValue = oName.getKeyPropertyList().get(keyHolder.getValue());
                        newName = newName.replaceAll(Pattern.quote(keyHolder.getKey()), keyValue);
                        newDisplayName = newDisplayName.replaceAll(Pattern.quote(keyHolder.getKey()), keyValue);
                        newDescription = newDescription.replaceAll(Pattern.quote(keyHolder.getKey()), keyValue);
                        newTags = newTags.stream().map(originalTag -> new Tag(originalTag.getTagName(), originalTag.getTagValue().replaceAll(Pattern.quote((String)keyHolder.getKey()), keyValue))).collect(Collectors.toList());
                    }
                    String newObjectName = oName.getCanonicalName() + "/" + attName;
                    ExtendedMetadata newEntryMetadata = new ExtendedMetadata(newName, newDisplayName, newDescription, entry.getMetadata().getTypeRaw(), entry.getMetadata().getUnit().orElse(null), newObjectName, true);
                    ExtendedMetadataAndTags newEntry = new ExtendedMetadataAndTags(newEntryMetadata, newTags);
                    result.add(newEntry);
                }
                toBeRemoved.add(entry);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalStateException(e);
            }
        }
        entries.removeAll(toBeRemoved);
        entries.addAll(result);
        log.debug((Object)("Converted [" + toBeRemoved.size() + "] config entries and added [" + result.size() + "] replacements"));
    }

    private Map<String, String> findKeyForValueToBeReplaced(ObjectName objectName) {
        return objectName.getKeyPropertyList().entrySet().stream().filter(entry -> ((String)entry.getValue()).matches("%s(\\d)?+")).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }
}

