/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.exporters;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.exporters.Exporter;
import io.smallrye.metrics.exporters.ExporterUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.jboss.logging.Logger;

public class JsonExporter
implements Exporter {
    private static final Logger log = Logger.getLogger((String)"io.smallrye.metrics");
    private static final Map<String, ?> JSON_CONFIG = Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true);

    @Override
    public StringBuilder exportOneScope(MetricRegistry.Type scope) {
        return this.stringify(this.exportOneRegistry(MetricRegistries.get(scope)));
    }

    @Override
    public StringBuilder exportAllScopes() {
        JsonObjectBuilder root = Json.createObjectBuilder();
        root.add("base", (JsonValue)this.exportOneRegistry(MetricRegistries.get(MetricRegistry.Type.BASE)));
        root.add("vendor", (JsonValue)this.exportOneRegistry(MetricRegistries.get(MetricRegistry.Type.VENDOR)));
        root.add("application", (JsonValue)this.exportOneRegistry(MetricRegistries.get(MetricRegistry.Type.APPLICATION)));
        return this.stringify(root.build());
    }

    @Override
    public StringBuilder exportOneMetric(MetricRegistry.Type scope, MetricID metricID) {
        MetricRegistry registry = MetricRegistries.get(scope);
        Map<MetricID, Metric> metricMap = registry.getMetrics();
        Map<String, Metadata> metadataMap = registry.getMetadata();
        Metric m = metricMap.get(metricID);
        HashMap<MetricID, Metric> outMap = new HashMap<MetricID, Metric>(1);
        outMap.put(metricID, m);
        JsonObjectBuilder root = Json.createObjectBuilder();
        this.exportMetricsForMap(outMap, metadataMap).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        return this.stringify(root.build());
    }

    @Override
    public StringBuilder exportMetricsByName(MetricRegistry.Type scope, String name) {
        MetricRegistry registry = MetricRegistries.get(scope);
        Map<MetricID, Metric> metricMap = registry.getMetrics().entrySet().stream().filter(e -> ((MetricID)e.getKey()).getName().equals(name)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, Metadata> metadataMap = registry.getMetadata();
        JsonObjectBuilder root = Json.createObjectBuilder();
        this.exportMetricsForMap(metricMap, metadataMap).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        return this.stringify(root.build());
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    StringBuilder stringify(JsonObject obj) {
        StringWriter out = new StringWriter();
        try (JsonWriter writer = Json.createWriterFactory(JSON_CONFIG).createWriter((Writer)out);){
            writer.writeObject(obj);
        }
        return new StringBuilder(out.toString());
    }

    private Map<String, JsonValue> exportMetricsByName(Map<MetricID, Metric> metricMap, Metadata metadata) {
        HashMap<String, JsonValue> result = new HashMap<String, JsonValue>();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        switch (metadata.getTypeRaw()) {
            case GAUGE: 
            case COUNTER: {
                metricMap.forEach((metricID, metric) -> result.put(metricID.getName() + this.createTagsString(metricID.getTagsAsList()), this.exportSimpleMetric((MetricID)metricID, (Metric)metric)));
                break;
            }
            case METERED: {
                metricMap.forEach((metricID, value) -> {
                    Metered metric = (Metered)value;
                    this.meterValues(metric, this.createTagsString(metricID.getTagsAsList())).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
                });
                result.put(metadata.getName(), (JsonValue)builder.build());
                break;
            }
            case CONCURRENT_GAUGE: {
                metricMap.forEach((metricID, value) -> {
                    ConcurrentGauge metric = (ConcurrentGauge)value;
                    this.exportConcurrentGauge(metric, this.createTagsString(metricID.getTagsAsList())).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
                });
                result.put(metadata.getName(), (JsonValue)builder.build());
                break;
            }
            case TIMER: {
                metricMap.forEach((metricID, value) -> {
                    Timer metric = (Timer)value;
                    this.exportTimer(metric, metadata.getUnit().orElse(null), this.createTagsString(metricID.getTagsAsList())).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
                });
                result.put(metadata.getName(), (JsonValue)builder.build());
                break;
            }
            case HISTOGRAM: {
                metricMap.forEach((metricID, value) -> {
                    Histogram metric = (Histogram)value;
                    this.exportHistogram(metric, this.createTagsString(metricID.getTagsAsList())).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
                });
                result.put(metadata.getName(), (JsonValue)builder.build());
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported: " + (Object)((Object)metadata.getTypeRaw()));
            }
        }
        return result;
    }

    private JsonObject exportOneRegistry(MetricRegistry registry) {
        Map<MetricID, Metric> metricMap = registry.getMetrics();
        Map<String, Metadata> metadataMap = registry.getMetadata();
        JsonObjectBuilder root = Json.createObjectBuilder();
        this.exportMetricsForMap(metricMap, metadataMap).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        return root.build();
    }

    private Map<String, JsonValue> exportMetricsForMap(Map<MetricID, Metric> metricMap, Map<String, Metadata> metadataMap) {
        HashMap<String, JsonValue> result = new HashMap<String, JsonValue>();
        Map<String, Map<MetricID, Metric>> metricsGroupedByName = metricMap.entrySet().stream().collect(Collectors.groupingBy(entry -> ((MetricID)entry.getKey()).getName(), Collectors.mapping(e -> e, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        metricsGroupedByName.entrySet().stream().map(entry -> this.exportMetricsByName((Map)entry.getValue(), (Metadata)metadataMap.get(entry.getKey()))).forEach(map -> map.forEach(result::put));
        return result;
    }

    private JsonValue exportSimpleMetric(MetricID metricID, Metric metric) {
        Number val = this.getValueFromMetric(metric, metricID.getName());
        if (val instanceof Double) {
            return Json.createValue((double)((Double)val));
        }
        if (val instanceof Float) {
            return Json.createValue((double)((Float)val).floatValue());
        }
        if (val instanceof Integer) {
            return Json.createValue((int)((Integer)val));
        }
        if (val instanceof Long) {
            return Json.createValue((long)((Long)val));
        }
        throw new IllegalStateException();
    }

    private Map<String, JsonValue> meterValues(Metered meter, String tags) {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        map.put("count" + tags, (JsonValue)Json.createValue((long)meter.getCount()));
        map.put("meanRate" + tags, (JsonValue)Json.createValue((double)meter.getMeanRate()));
        map.put("oneMinRate" + tags, (JsonValue)Json.createValue((double)meter.getOneMinuteRate()));
        map.put("fiveMinRate" + tags, (JsonValue)Json.createValue((double)meter.getFiveMinuteRate()));
        map.put("fifteenMinRate" + tags, (JsonValue)Json.createValue((double)meter.getFifteenMinuteRate()));
        return map;
    }

    private Map<String, JsonValue> exportConcurrentGauge(ConcurrentGauge concurrentGauge, String tags) {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        map.put("current" + tags, (JsonValue)Json.createValue((long)concurrentGauge.getCount()));
        map.put("max" + tags, (JsonValue)Json.createValue((long)concurrentGauge.getMax()));
        map.put("min" + tags, (JsonValue)Json.createValue((long)concurrentGauge.getMin()));
        return map;
    }

    private JsonObject exportTimer(Timer timer, String unit, String tags) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.snapshotValues(timer.getSnapshot(), unit, tags).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
        this.meterValues(timer, tags).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
        return builder.build();
    }

    private Map<String, JsonValue> exportHistogram(Histogram histogram, String tags) {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        map.put("count" + tags, (JsonValue)Json.createValue((long)histogram.getCount()));
        this.snapshotValues(histogram.getSnapshot(), tags).forEach(map::put);
        return map;
    }

    private Map<String, JsonValue> snapshotValues(Snapshot snapshot, String tags) {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        map.put("p50" + tags, (JsonValue)Json.createValue((double)snapshot.getMedian()));
        map.put("p75" + tags, (JsonValue)Json.createValue((double)snapshot.get75thPercentile()));
        map.put("p95" + tags, (JsonValue)Json.createValue((double)snapshot.get95thPercentile()));
        map.put("p98" + tags, (JsonValue)Json.createValue((double)snapshot.get98thPercentile()));
        map.put("p99" + tags, (JsonValue)Json.createValue((double)snapshot.get99thPercentile()));
        map.put("p999" + tags, (JsonValue)Json.createValue((double)snapshot.get999thPercentile()));
        map.put("min" + tags, (JsonValue)Json.createValue((long)snapshot.getMin()));
        map.put("mean" + tags, (JsonValue)Json.createValue((double)snapshot.getMean()));
        map.put("max" + tags, (JsonValue)Json.createValue((long)snapshot.getMax()));
        map.put("stddev" + tags, (JsonValue)Json.createValue((double)snapshot.getStdDev()));
        return map;
    }

    private Map<String, JsonValue> snapshotValues(Snapshot snapshot, String unit, String tags) {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        map.put("p50" + tags, (JsonValue)Json.createValue((double)this.toBase(snapshot.getMedian(), unit)));
        map.put("p75" + tags, (JsonValue)Json.createValue((double)this.toBase(snapshot.get75thPercentile(), unit)));
        map.put("p95" + tags, (JsonValue)Json.createValue((double)this.toBase(snapshot.get95thPercentile(), unit)));
        map.put("p98" + tags, (JsonValue)Json.createValue((double)this.toBase(snapshot.get98thPercentile(), unit)));
        map.put("p99" + tags, (JsonValue)Json.createValue((double)this.toBase(snapshot.get99thPercentile(), unit)));
        map.put("p999" + tags, (JsonValue)Json.createValue((double)this.toBase(snapshot.get999thPercentile(), unit)));
        map.put("min" + tags, (JsonValue)Json.createValue((double)this.toBase(snapshot.getMin(), unit)));
        map.put("mean" + tags, (JsonValue)Json.createValue((double)this.toBase(snapshot.getMean(), unit)));
        map.put("max" + tags, (JsonValue)Json.createValue((double)this.toBase(snapshot.getMax(), unit)));
        map.put("stddev" + tags, (JsonValue)Json.createValue((double)this.toBase(snapshot.getStdDev(), unit)));
        return map;
    }

    private Double toBase(Number count, String unit) {
        return ExporterUtil.convertNanosTo(count.doubleValue(), unit);
    }

    private Number getValueFromMetric(Metric theMetric, String name) {
        if (theMetric instanceof Gauge) {
            Number value = (Number)((Gauge)theMetric).getValue();
            if (value != null) {
                return value;
            }
            log.warn((Object)("Value is null for " + name));
            return -142.142;
        }
        if (theMetric instanceof Counter) {
            return ((Counter)theMetric).getCount();
        }
        log.error((Object)("Not yet supported metric: " + theMetric.getClass().getName()));
        return -42.42;
    }

    private String createTagsString(List<Tag> tagsAsList) {
        if (tagsAsList == null || tagsAsList.isEmpty()) {
            return "";
        }
        return ";" + tagsAsList.stream().map(tag -> tag.getTagName() + "=" + tag.getTagValue().replaceAll(";", "_")).collect(Collectors.joining(";"));
    }
}

