/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.elementdesc.adapter.cdi.CDIBeanInfoAdapter;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import io.smallrye.metrics.interceptors.MetricResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.Metered;

@Metered
@Interceptor
@Priority(value=1010)
public class MeteredInterceptor {
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    private MeteredInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = new MetricResolver();
    }

    @AroundConstruct
    Object meteredConstructor(InvocationContext context) throws Exception {
        return this.meteredCallable(context, (Member & AnnotatedElement)context.getConstructor());
    }

    @AroundInvoke
    Object meteredMethod(InvocationContext context) throws Exception {
        return this.meteredCallable(context, context.getMethod());
    }

    @AroundTimeout
    Object meteredTimeout(InvocationContext context) throws Exception {
        return this.meteredCallable(context, context.getMethod());
    }

    private <E extends Member & AnnotatedElement> Object meteredCallable(InvocationContext context, E element) throws Exception {
        CDIBeanInfoAdapter beanInfoAdapter = new CDIBeanInfoAdapter();
        CDIMemberInfoAdapter<E> memberInfoAdapter = new CDIMemberInfoAdapter<E>();
        MetricResolver.Of<Metered> meterResolver = this.resolver.metered(this.bean != null ? beanInfoAdapter.convert(this.bean.getBeanClass()) : beanInfoAdapter.convert(element.getDeclaringClass()), memberInfoAdapter.convert(element));
        String name = meterResolver.metricName();
        Tag[] tags = meterResolver.tags();
        MetricID metricID = new MetricID(name, tags);
        Meter meter = (Meter)this.registry.getMetrics().get(metricID);
        if (meter == null) {
            throw new IllegalStateException("No meter with metricID [" + metricID + "] found in registry [" + this.registry + "]");
        }
        meter.mark();
        return context.proceed();
    }
}

