/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.mixed;

import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class CompletableAndThenPublisher<R>
extends Flowable<R> {
    final CompletableSource source;
    final Publisher<? extends R> other;

    public CompletableAndThenPublisher(CompletableSource source, Publisher<? extends R> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new AndThenPublisherSubscriber<R>(s, this.other));
    }

    static final class AndThenPublisherSubscriber<R>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<R>,
    CompletableObserver,
    Subscription {
        private static final long serialVersionUID = -8948264376121066672L;
        final Subscriber<? super R> downstream;
        Publisher<? extends R> other;
        Disposable upstream;
        final AtomicLong requested;

        AndThenPublisherSubscriber(Subscriber<? super R> downstream, Publisher<? extends R> other) {
            this.downstream = downstream;
            this.other = other;
            this.requested = new AtomicLong();
        }

        @Override
        public void onNext(R t) {
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            Publisher<R> p = this.other;
            if (p == null) {
                this.downstream.onComplete();
            } else {
                this.other = null;
                p.subscribe(this);
            }
        }

        @Override
        public void request(long n) {
            SubscriptionHelper.deferredRequest(this, this.requested, n);
        }

        @Override
        public void cancel() {
            this.upstream.dispose();
            SubscriptionHelper.cancel(this);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            SubscriptionHelper.deferredSetOnce(this, this.requested, s);
        }
    }
}

