/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.counter.impl.TestCounterNotificationManager;
import org.infinispan.server.hotrod.counter.impl.TestStrongCounter;
import org.infinispan.server.hotrod.counter.impl.TestWeakCounter;
import org.infinispan.server.hotrod.counter.op.CounterOp;
import org.infinispan.server.hotrod.counter.op.CreateCounterOp;
import org.infinispan.server.hotrod.counter.response.CounterConfigurationTestResponse;
import org.infinispan.server.hotrod.counter.response.CounterNamesTestResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.Op;
import org.infinispan.server.hotrod.test.TestResponse;

public class TestCounterManager
implements CounterManager {
    private final HotRodClient client;
    private final TestCounterNotificationManager notificationManager;
    private final Map<String, Object> counters;

    public TestCounterManager(HotRodClient client) {
        this.client = client;
        this.counters = new ConcurrentHashMap<String, Object>();
        this.notificationManager = new TestCounterNotificationManager(client);
        this.notificationManager.start();
    }

    public StrongCounter getStrongCounter(String name) {
        StrongCounter c = (StrongCounter)this.counters.get(name);
        if (c == null) {
            CounterConfiguration config = this.getConfiguration(name);
            if (config == null || config.type() == CounterType.WEAK) {
                throw new IllegalStateException();
            }
            c = new TestStrongCounter(name, config, this.client, this.notificationManager);
            this.counters.put(name, c);
        }
        return c;
    }

    public WeakCounter getWeakCounter(String name) {
        WeakCounter c = (WeakCounter)this.counters.get(name);
        if (c == null) {
            CounterConfiguration config = this.getConfiguration(name);
            if (config == null || config.type() != CounterType.WEAK) {
                throw new IllegalStateException();
            }
            c = new TestWeakCounter(name, config, this.client, this.notificationManager);
            this.counters.put(name, c);
        }
        return c;
    }

    public boolean defineCounter(String name, CounterConfiguration configuration) {
        CreateCounterOp op = new CreateCounterOp(this.client.protocolVersion(), name, configuration);
        this.client.writeOp(op);
        TestResponse response = this.client.getResponse(op);
        return response.getStatus() == OperationStatus.Success;
    }

    public void undefineCounter(String name) {
    }

    public boolean isDefined(String name) {
        CounterOp op = new CounterOp(this.client.protocolVersion(), HotRodOperation.COUNTER_IS_DEFINED, name);
        this.client.writeOp(op);
        TestResponse response = this.client.getResponse(op);
        return response.getStatus() == OperationStatus.Success;
    }

    public CounterConfiguration getConfiguration(String counterName) {
        CounterOp op = new CounterOp(this.client.protocolVersion(), HotRodOperation.COUNTER_GET_CONFIGURATION, counterName);
        this.client.writeOp(op);
        TestResponse response = this.client.getResponse(op);
        return response.getStatus() == OperationStatus.Success ? ((CounterConfigurationTestResponse)response).getConfiguration() : null;
    }

    public void remove(String counterName) {
        CounterOp op = new CounterOp(this.client.protocolVersion(), HotRodOperation.COUNTER_REMOVE, counterName);
        this.client.writeOp(op);
        this.client.getResponse(op);
    }

    public Collection<String> getCounterNames() {
        Op op = new Op(160, this.client.protocolVersion(), (byte)HotRodOperation.COUNTER_GET_NAMES.getRequestOpCode(), "", null, 0, 0, null, 0, 0L, 0, 0);
        this.client.writeOp(op);
        CounterNamesTestResponse response = (CounterNamesTestResponse)this.client.getResponse(op);
        return response.getCounterNames();
    }
}

