/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.List;
import java.util.Optional;
import javax.transaction.xa.Xid;
import org.infinispan.commons.io.SignedNumeric;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.counter.op.CounterOp;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.test.AddClientListenerOp;
import org.infinispan.server.hotrod.test.AuthOp;
import org.infinispan.server.hotrod.test.BulkGetKeysOp;
import org.infinispan.server.hotrod.test.BulkGetOp;
import org.infinispan.server.hotrod.test.GetStreamOp;
import org.infinispan.server.hotrod.test.IterationEndOp;
import org.infinispan.server.hotrod.test.IterationNextOp;
import org.infinispan.server.hotrod.test.IterationStartOp;
import org.infinispan.server.hotrod.test.Op;
import org.infinispan.server.hotrod.test.PartialOp;
import org.infinispan.server.hotrod.test.PrepareOp;
import org.infinispan.server.hotrod.test.QueryOp;
import org.infinispan.server.hotrod.test.RemoveClientListenerOp;
import org.infinispan.server.hotrod.test.TxOp;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;
import org.infinispan.util.KeyValuePair;

class Encoder
extends MessageToByteEncoder<Object> {
    private final byte protocolVersion;
    private static final Log log = (Log)LogFactory.getLog(Encoder.class, Log.class);

    Encoder(byte protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf buffer) {
        log.tracef("Encode %s so that it's sent to the server", msg);
        if (msg instanceof PartialOp) {
            PartialOp partial = (PartialOp)msg;
            buffer.writeByte((int)((byte)partial.magic));
            ExtendedByteBuf.writeUnsignedLong((long)partial.id, (ByteBuf)buffer);
            buffer.writeByte((int)partial.version);
            buffer.writeByte((int)partial.code);
        } else if (msg instanceof AddClientListenerOp) {
            AddClientListenerOp op = (AddClientListenerOp)msg;
            this.writeHeader(op, buffer);
            ExtendedByteBuf.writeRangedBytes((byte[])op.listenerId, (ByteBuf)buffer);
            buffer.writeByte(op.includeState ? 1 : 0);
            this.writeNamedFactory(op.filterFactory, buffer);
            this.writeNamedFactory(op.converterFactory, buffer);
            if (this.protocolVersion >= 21) {
                buffer.writeByte(op.useRawData ? 1 : 0);
            }
        } else if (msg instanceof RemoveClientListenerOp) {
            RemoveClientListenerOp op = (RemoveClientListenerOp)msg;
            this.writeHeader(op, buffer);
            ExtendedByteBuf.writeRangedBytes((byte[])op.listenerId, (ByteBuf)buffer);
        } else if (msg instanceof PrepareOp) {
            this.encodePrepareOp((PrepareOp)msg, buffer);
        } else if (msg instanceof TxOp) {
            this.encodeTxOp((TxOp)msg, buffer);
        } else if (msg instanceof CounterOp) {
            this.writeHeader((Op)msg, buffer);
            ((CounterOp)msg).writeTo(buffer);
        } else if (msg instanceof Op) {
            Op op = (Op)msg;
            this.writeHeader(op, buffer);
            if (op.code == HotRodOperation.COUNTER_GET_NAMES.getRequestOpCode() || op.code == 123) {
                return;
            }
            if (this.protocolVersion < 20) {
                ExtendedByteBuf.writeRangedBytes((byte[])Util.EMPTY_BYTE_ARRAY, (ByteBuf)buffer);
            }
            if (op.code != 19 && op.code != 21 && op.code != 23 && op.code != 25 && op.code != 29 && op.code != 31 && op.code != 33 && op.code != 35 && op.code != 41 && op.code != 49 && op.code != 51 && op.code != 53) {
                ExtendedByteBuf.writeRangedBytes((byte[])op.key, (ByteBuf)buffer);
                if (op.code == 55) {
                    ExtendedByteBuf.writeUnsignedInt((int)((GetStreamOp)op).offset, (ByteBuf)buffer);
                }
                if (op.value != null) {
                    if (op.code != 13) {
                        if (this.protocolVersion >= 22) {
                            if (op.lifespan > 0 || op.maxIdle > 0) {
                                buffer.writeByte(0);
                                ExtendedByteBuf.writeUnsignedInt((int)op.lifespan, (ByteBuf)buffer);
                                ExtendedByteBuf.writeUnsignedInt((int)op.maxIdle, (ByteBuf)buffer);
                            } else {
                                buffer.writeByte(136);
                            }
                        } else {
                            ExtendedByteBuf.writeUnsignedInt((int)op.lifespan, (ByteBuf)buffer);
                            ExtendedByteBuf.writeUnsignedInt((int)op.maxIdle, (ByteBuf)buffer);
                        }
                    }
                    if (op.code == 9 || op.code == 13 || op.code == 57) {
                        buffer.writeLong(op.dataVersion);
                    }
                    if (op.code == 57) {
                        int chunk;
                        for (int offset = 0; offset < op.value.length; offset += chunk) {
                            chunk = Math.min(op.value.length - offset, 8192);
                            ExtendedByteBuf.writeUnsignedInt((int)chunk, (ByteBuf)buffer);
                            buffer.writeBytes(op.value, offset, chunk);
                        }
                        ExtendedByteBuf.writeUnsignedInt((int)0, (ByteBuf)buffer);
                    } else if (op.code != 13) {
                        ExtendedByteBuf.writeRangedBytes((byte[])op.value, (ByteBuf)buffer);
                    }
                }
            } else if (op.code == 25) {
                ExtendedByteBuf.writeUnsignedInt((int)((BulkGetOp)op).count, (ByteBuf)buffer);
            } else if (op.code == 29) {
                ExtendedByteBuf.writeUnsignedInt((int)((BulkGetKeysOp)op).scope, (ByteBuf)buffer);
            } else if (op.code == 31) {
                ExtendedByteBuf.writeRangedBytes((byte[])((QueryOp)op).query, (ByteBuf)buffer);
            } else if (op.code == 35) {
                AuthOp authop = (AuthOp)op;
                if (!authop.mech.isEmpty()) {
                    ExtendedByteBuf.writeRangedBytes((byte[])authop.mech.getBytes(), (ByteBuf)buffer);
                } else {
                    ExtendedByteBuf.writeUnsignedInt((int)0, (ByteBuf)buffer);
                }
                ExtendedByteBuf.writeRangedBytes((byte[])((AuthOp)op).response, (ByteBuf)buffer);
            } else if (op.code == 49) {
                IterationStartOp startop = (IterationStartOp)op;
                if (startop.segmentMask == null) {
                    ExtendedByteBuf.writeUnsignedInt((int)SignedNumeric.encode((int)-1), (ByteBuf)buffer);
                } else {
                    buffer.writeBytes(startop.segmentMask);
                }
                if (startop.filterConverterFactory != null) {
                    ExtendedByteBuf.writeRangedBytes((byte[])startop.filterConverterFactory.getBytes(), (ByteBuf)buffer);
                    if (startop.filterConverterParams != null && startop.filterConverterParams.size() > 0) {
                        buffer.writeByte(startop.filterConverterParams.size());
                        startop.filterConverterParams.forEach(arg_0 -> ((ByteBuf)buffer).writeBytes(arg_0));
                    } else {
                        buffer.writeByte(0);
                    }
                } else {
                    ExtendedByteBuf.writeUnsignedInt((int)SignedNumeric.encode((int)-1), (ByteBuf)buffer);
                }
                ExtendedByteBuf.writeUnsignedInt((int)startop.batch, (ByteBuf)buffer);
                if (this.protocolVersion >= 24) {
                    buffer.writeByte(startop.includeMetadata ? 1 : 0);
                }
            } else if (op.code == 51) {
                IterationNextOp nextop = (IterationNextOp)op;
                ExtendedByteBuf.writeRangedBytes((byte[])nextop.iterationId.getBytes(), (ByteBuf)buffer);
            } else if (op.code == 53) {
                IterationEndOp endop = (IterationEndOp)op;
                ExtendedByteBuf.writeRangedBytes((byte[])endop.iterationId.getBytes(), (ByteBuf)buffer);
            }
        }
    }

    private void encodePrepareOp(PrepareOp op, ByteBuf buffer) {
        this.writeHeader(op, buffer);
        ExtendedByteBuf.writeXid((Xid)op.xid, (ByteBuf)buffer);
        buffer.writeByte(op.onePhaseCommit ? 1 : 0);
        ExtendedByteBuf.writeUnsignedInt((int)op.modifications.size(), (ByteBuf)buffer);
        op.modifications.forEach(txWrite -> txWrite.encodeTo(buffer));
    }

    private void encodeTxOp(TxOp op, ByteBuf byteBuf) {
        this.writeHeader(op, byteBuf);
        ExtendedByteBuf.writeXid((Xid)op.xid, (ByteBuf)byteBuf);
    }

    private void writeNamedFactory(Optional<KeyValuePair<String, List<byte[]>>> namedFactory, ByteBuf buffer) {
        if (namedFactory.isPresent()) {
            KeyValuePair<String, List<byte[]>> factory = namedFactory.get();
            ExtendedByteBuf.writeString((String)((String)factory.getKey()), (ByteBuf)buffer);
            buffer.writeByte(((List)factory.getValue()).size());
            ((List)factory.getValue()).forEach(bytes -> ExtendedByteBuf.writeRangedBytes((byte[])bytes, (ByteBuf)buffer));
        } else {
            buffer.writeByte(0);
        }
    }

    private void writeHeader(Op op, ByteBuf buffer) {
        buffer.writeByte(op.magic);
        ExtendedByteBuf.writeUnsignedLong((long)op.id, (ByteBuf)buffer);
        buffer.writeByte((int)op.version);
        buffer.writeByte((int)op.code);
        if (!op.cacheName.isEmpty()) {
            ExtendedByteBuf.writeRangedBytes((byte[])op.cacheName.getBytes(), (ByteBuf)buffer);
        } else {
            ExtendedByteBuf.writeUnsignedInt((int)0, (ByteBuf)buffer);
        }
        ExtendedByteBuf.writeUnsignedInt((int)op.flags, (ByteBuf)buffer);
        buffer.writeByte((int)op.clientIntel);
        ExtendedByteBuf.writeUnsignedInt((int)op.topologyId, (ByteBuf)buffer);
        if (this.protocolVersion >= 28) {
            buffer.writeByte(0);
            buffer.writeByte(0);
        }
    }
}

