/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.RemoteTransaction;
import org.infinispan.server.hotrod.tx.table.GlobalTxTable;
import org.infinispan.server.hotrod.tx.table.PerCacheTxTable;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.tx.TxFunctionalTest")
public class TxFunctionalTest
extends HotRodMultiNodeTest {
    private org.infinispan.configuration.cache.TransactionMode transactionMode;

    public Object[] factory() {
        return new Object[]{new TxFunctionalTest().transactionMode(org.infinispan.configuration.cache.TransactionMode.NON_XA).lockingMode(LockingMode.PESSIMISTIC), new TxFunctionalTest().transactionMode(org.infinispan.configuration.cache.TransactionMode.NON_DURABLE_XA).lockingMode(LockingMode.PESSIMISTIC), new TxFunctionalTest().transactionMode(org.infinispan.configuration.cache.TransactionMode.FULL_XA).lockingMode(LockingMode.PESSIMISTIC)};
    }

    public TxFunctionalTest transactionMode(org.infinispan.configuration.cache.TransactionMode transactionMode) {
        this.transactionMode = transactionMode;
        return this;
    }

    public void testKeyNotRead(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1);
        tx.getAndAssert(k1, v1);
        tx.set(k2, v2);
        tx.getAndAssert(k2, v2);
        tx.prepareAndAssert(0);
        tx.commitAndAssert(0);
        tx.forget();
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testKeyNotReadWithConcurrentTransaction(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        byte[] v1_1 = HotRodTestingUtil.v(method, "v1_1");
        HotRodClient otherClient = this.clients().get(1);
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1);
        tx.getAndAssert(k1, v1);
        tx.set(k2, v2);
        tx.getAndAssert(k2, v2);
        otherClient.put(k1, 0, 0, v1_1);
        tx.prepareAndAssert(0);
        tx.commitAndAssert(0);
        tx.forget();
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testKeyNonExisting(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, null);
        tx.set(k1, v1);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, null);
        tx.set(k2, v2);
        tx.getAndAssert(k2, v2);
        tx.prepareAndAssert(0);
        tx.commitAndAssert(0);
        tx.forget();
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testKeyNonExistingWithConflict(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        byte[] v1_1 = HotRodTestingUtil.v(method, "v1_1");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, null);
        tx.set(k1, v1);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, null);
        tx.set(k2, v2);
        tx.getAndAssert(k2, v2);
        this.clients().get(1).put(k1, 0, 0, v1_1);
        tx.prepareAndAssert(100);
        tx.rollbackAndAssert(0);
        tx.forget();
        this.assertData(k1, v1_1);
        this.assertDataDoesNotExist(k2);
        this.assertServerTransactionTableEmpty();
    }

    public void testKeyRead(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        byte[] v1_1 = HotRodTestingUtil.v(method, "v1_1");
        byte[] v2_1 = HotRodTestingUtil.v(method, "v2_1");
        this.clients().get(1).put(k1, 0, 0, v1);
        this.clients().get(1).put(k2, 0, 0, v2);
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, v1);
        tx.set(k1, v1_1);
        tx.getAndAssert(k1, v1_1);
        tx.getAndAssert(k2, v2);
        tx.set(k2, v2_1);
        tx.getAndAssert(k2, v2_1);
        tx.prepareAndAssert(0);
        tx.commitAndAssert(0);
        tx.forget();
        this.assertData(k1, v1_1);
        this.assertData(k2, v2_1);
        this.assertServerTransactionTableEmpty();
    }

    public void testKeyReadWithConflict(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        byte[] v1_1 = HotRodTestingUtil.v(method, "v1_1");
        byte[] v2_1 = HotRodTestingUtil.v(method, "v2_1");
        byte[] v1_1_1 = HotRodTestingUtil.v(method, "v1_1_1");
        this.clients().get(1).put(k1, 0, 0, v1);
        this.clients().get(1).put(k2, 0, 0, v2);
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, v1);
        tx.set(k1, v1_1);
        tx.getAndAssert(k1, v1_1);
        tx.getAndAssert(k2, v2);
        tx.set(k2, v2_1);
        tx.getAndAssert(k2, v2_1);
        this.clients().get(1).put(k1, 0, 0, v1_1_1);
        tx.prepareAndAssert(100);
        tx.rollbackAndAssert(0);
        tx.forget();
        this.assertData(k1, v1_1_1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testRemoveWithKeyNotRead(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1);
        tx.getAndAssert(k1, v1);
        tx.set(k2, v2);
        tx.getAndAssert(k2, v2);
        tx.remove(k1);
        tx.getAndAssert(k1, null);
        tx.prepareAndAssert(0);
        tx.commitAndAssert(0);
        tx.forget();
        this.assertDataDoesNotExist(k1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testRemoveWithKeyNotReadWithConcurrentTransaction(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        byte[] v1_1 = HotRodTestingUtil.v(method, "v1_1");
        byte[] v2_1 = HotRodTestingUtil.v(method, "v2_1");
        byte[] v1_1_1 = HotRodTestingUtil.v(method, "v1_1_1");
        this.clients().get(1).put(k1, 0, 0, v1);
        this.clients().get(1).put(k2, 0, 0, v2);
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1_1);
        tx.getAndAssert(k1, v1_1);
        tx.set(k2, v2_1);
        tx.getAndAssert(k2, v2_1);
        tx.remove(k1);
        tx.getAndAssert(k1, null);
        this.clients().get(1).put(k1, 0, 0, v1_1_1);
        tx.prepareAndAssert(0);
        tx.commitAndAssert(0);
        tx.forget();
        this.assertDataDoesNotExist(k1);
        this.assertData(k2, v2_1);
        this.assertServerTransactionTableEmpty();
    }

    public void testRemoveWithNonExisting(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, null);
        tx.set(k1, v1);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, null);
        tx.set(k2, v2);
        tx.getAndAssert(k2, v2);
        tx.remove(k1);
        tx.getAndAssert(k1, null);
        tx.prepareAndAssert(0);
        tx.commitAndAssert(0);
        tx.forget();
        this.assertDataDoesNotExist(k1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testRemoveWithNonExistingWithConflictingTransaction(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        byte[] v1_1 = HotRodTestingUtil.v(method, "v1_1");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, null);
        tx.set(k1, v1);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, null);
        tx.set(k2, v2);
        tx.getAndAssert(k2, v2);
        tx.remove(k1);
        tx.getAndAssert(k1, null);
        this.clients().get(1).put(k1, 0, 0, v1_1);
        tx.prepareAndAssert(100);
        tx.rollbackAndAssert(0);
        tx.forget();
        this.assertData(k1, v1_1);
        this.assertDataDoesNotExist(k2);
        this.assertServerTransactionTableEmpty();
    }

    public void testRemoveKeyRead(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        byte[] v2_1 = HotRodTestingUtil.v(method, "v2_1");
        this.clients().get(1).put(k1, 0, 0, v1);
        this.clients().get(1).put(k2, 0, 0, v2);
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, v1);
        tx.remove(k1);
        tx.getAndAssert(k1, null);
        tx.getAndAssert(k2, v2);
        tx.set(k2, v2_1);
        tx.getAndAssert(k2, v2_1);
        tx.prepareAndAssert(0);
        tx.commitAndAssert(0);
        tx.forget();
        this.assertDataDoesNotExist(k1);
        this.assertData(k2, v2_1);
        this.assertServerTransactionTableEmpty();
    }

    public void testRemoveKeyReadWithConflicting(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        byte[] v1_1 = HotRodTestingUtil.v(method, "v1_1");
        byte[] v2_1 = HotRodTestingUtil.v(method, "v2_1");
        this.clients().get(1).put(k1, 0, 0, v1);
        this.clients().get(1).put(k2, 0, 0, v2);
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, v1);
        tx.remove(k1);
        tx.getAndAssert(k1, null);
        tx.getAndAssert(k2, v2);
        tx.set(k2, v2_1);
        tx.getAndAssert(k2, v2_1);
        this.clients().get(1).put(k1, 0, 0, v1_1);
        tx.prepareAndAssert(100);
        tx.rollbackAndAssert(0);
        tx.forget();
        this.assertData(k1, v1_1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testReadReadConflict(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        byte[] v1_1 = HotRodTestingUtil.v(method, "v1_1");
        byte[] v2_1 = HotRodTestingUtil.v(method, "v2_1");
        this.clients().get(1).put(k1, 0, 0, v1);
        this.clients().get(1).put(k2, 0, 0, v2);
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, v1);
        tx.remove(k1);
        tx.getAndAssert(k1, null);
        this.clients().get(1).put(k2, 0, 0, v2_1);
        tx.prepareAndAssert(0);
        tx.commitAndAssert(0);
        tx.forget();
        this.assertDataDoesNotExist(k1);
        this.assertData(k2, v2_1);
        this.assertServerTransactionTableEmpty();
        this.clients().get(1).put(k1, 0, 0, v1);
        this.clients().get(1).put(k2, 0, 0, v2);
        tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, v1);
        tx.set(k1, v1_1);
        tx.getAndAssert(k1, v1_1);
        this.clients().get(1).put(k2, 0, 0, v2_1);
        tx.prepareAndAssert(0);
        tx.commitAndAssert(0);
        tx.forget();
        this.assertData(k1, v1_1);
        this.assertData(k2, v2_1);
        this.assertServerTransactionTableEmpty();
    }

    public void testCommitFromAnotherNode(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        byte[] v1_1 = HotRodTestingUtil.v(method, "v1_1");
        this.clients().get(1).put(k1, 0, 0, v1);
        this.clients().get(1).put(k2, 0, 0, v2);
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, v1);
        tx.remove(k1);
        tx.getAndAssert(k1, null);
        tx.prepareAndAssert(0);
        tx.commitAndAssert(this.clients().get(1), 0);
        tx.forget(this.clients().get(1));
        this.assertDataDoesNotExist(k1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
        this.clients().get(1).put(k1, 0, 0, v1);
        this.clients().get(1).put(k2, 0, 0, v2);
        tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, v1);
        tx.set(k1, v1_1);
        tx.getAndAssert(k1, v1_1);
        tx.prepareAndAssert(0);
        tx.commitAndAssert(this.clients().get(1), 0);
        tx.forget(this.clients().get(1));
        this.assertData(k1, v1_1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testRollbackFromAnotherNode(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        byte[] v1_1 = HotRodTestingUtil.v(method, "v1_1");
        this.clients().get(1).put(k1, 0, 0, v1);
        this.clients().get(1).put(k2, 0, 0, v2);
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, v1);
        tx.remove(k1);
        tx.getAndAssert(k1, null);
        tx.prepareAndAssert(0);
        tx.rollbackAndAssert(this.clients().get(1), 0);
        tx.forget(this.clients().get(1));
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
        this.clients().get(1).put(k1, 0, 0, v1);
        this.clients().get(1).put(k2, 0, 0, v2);
        tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.getAndAssert(k1, v1);
        tx.set(k1, v1_1);
        tx.getAndAssert(k1, v1_1);
        tx.prepareAndAssert(0);
        tx.rollbackAndAssert(this.clients().get(1), 0);
        tx.forget(this.clients().get(1));
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testPrepareOnDifferentNode(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1);
        tx.set(k2, v2);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, v2);
        tx.prepareAndAssert(0);
        tx.prepareAndAssert(this.clients().get(1), 0);
        tx.commitAndAssert(0);
        tx.forget();
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    protected String parameters() {
        return "[" + this.lockingMode + "/" + this.transactionMode + "]";
    }

    @Override
    protected String cacheName() {
        return "tx-cache";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        builder.transaction().lockingMode(this.lockingMode);
        switch (this.transactionMode) {
            case NON_XA: {
                builder.transaction().useSynchronization(true);
                break;
            }
            case NON_DURABLE_XA: {
                builder.transaction().useSynchronization(false);
                builder.transaction().recovery().disable();
                break;
            }
            case FULL_XA: {
                builder.transaction().useSynchronization(false);
                builder.transaction().recovery().enable();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        builder.clustering().hash().numOwners(2);
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        return builder;
    }

    @Override
    protected byte protocolVersion() {
        return HotRodVersion.HOTROD_27.getVersion();
    }

    private void assertDataDoesNotExist(byte[] key) {
        for (HotRodClient client : this.clients()) {
            HotRodTestingUtil.assertKeyDoesNotExist(client.get(key, 0));
        }
    }

    private void assertData(byte[] key, byte[] value) {
        for (HotRodClient client : this.clients()) {
            HotRodTestingUtil.assertSuccess(client.get(key, 0), value);
        }
    }

    private void assertServerTransactionTableEmpty() {
        for (Cache cache : this.caches(this.cacheName())) {
            PerCacheTxTable perCacheTxTable = (PerCacheTxTable)TestingUtil.extractComponent((Cache)cache, PerCacheTxTable.class);
            AssertJUnit.assertTrue((boolean)perCacheTxTable.isEmpty());
        }
        for (EmbeddedCacheManager cm : this.managers()) {
            GlobalTxTable globalTxTable = (GlobalTxTable)TestingUtil.extractGlobalComponent((CacheContainer)cm, GlobalTxTable.class);
            AssertJUnit.assertTrue((boolean)globalTxTable.isEmpty());
        }
    }
}

