/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodIgnoreCacheTest")
public class HotRodIgnoreCacheTest
extends HotRodMultiNodeTest {
    public void testIgnoreCache() throws InterruptedException {
        HotRodClient client = this.clients().get(0);
        client.put("k1", "v1");
        HotRodTestingUtil.assertStatus(client.get("k1"), OperationStatus.Success);
        this.servers().get(0).getCacheIgnore().ignoreCache(this.cacheName());
        this.eventually(() -> this.servers().get(1).getCacheIgnore().getIgnoredCaches().contains(this.cacheName()));
        HotRodTestingUtil.assertStatus(client.get("k1"), OperationStatus.ServerError);
        this.servers().get(1).getCacheIgnore().unignoreCache(this.cacheName());
        this.eventually(() -> !this.servers().get(0).getCacheIgnore().getIgnoredCaches().contains(this.cacheName()));
        HotRodTestingUtil.assertStatus(client.get("k1"), OperationStatus.Success);
    }

    @Override
    protected String cacheName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        return HotRodTestingUtil.hotRodCacheConfiguration(HotRodIgnoreCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
    }
}

