/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.Main$;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodServer$;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TestGetResponse;
import org.infinispan.server.hotrod.test.TestGetWithVersionResponse;
import org.infinispan.server.hotrod.test.TestHashDistAware10Response;
import org.infinispan.server.hotrod.test.TestHashDistAware11Response;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestResponseWithPrevious;
import org.infinispan.server.hotrod.test.TestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.UniquePortThreadLocal$;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;
import org.testng.Assert;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HotRodTestingUtil$
implements Log,
ScalaObject {
    public static final HotRodTestingUtil$ MODULE$;
    private final byte EXPECTED_HASH_FUNCTION_VERSION;
    private final org.infinispan.server.hotrod.logging.JavaLog log;
    private final JavaLog org$infinispan$server$core$logging$Log$$log;
    public volatile int bitmap$0;
    private volatile int bitmap$priv$0;

    static {
        new HotRodTestingUtil$();
    }

    public byte EXPECTED_HASH_FUNCTION_VERSION() {
        return this.EXPECTED_HASH_FUNCTION_VERSION;
    }

    public String host() {
        return "127.0.0.1";
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager) {
        return this.startHotRodServer(manager, Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())));
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, String proxyHost, int proxyPort) {
        return this.startHotRodServer(manager, Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())), 0, proxyHost, proxyPort);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port) {
        return this.startHotRodServer(manager, port, 0);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, String proxyHost, int proxyPort) {
        return this.startHotRodServer(manager, port, 0, proxyHost, proxyPort);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout) {
        return this.startHotRodServer(manager, port, idleTimeout, this.host(), port);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout, String proxyHost, int proxyPort) {
        return this.startHotRodServer(manager, port, idleTimeout, proxyHost, proxyPort, -1L);
    }

    public HotRodServer startHotRodServerWithDelay(EmbeddedCacheManager manager, int port, long delay) {
        return this.startHotRodServer(manager, port, 0, this.host(), port, delay);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout, String proxyHost, int proxyPort, long delay) {
        Properties properties = new Properties();
        properties.setProperty(Main$.MODULE$.PROP_KEY_IDLE_TIMEOUT(), ((Object)BoxesRunTime.boxToInteger((int)idleTimeout)).toString());
        properties.setProperty(Main$.MODULE$.PROP_KEY_PROXY_HOST(), proxyHost);
        properties.setProperty(Main$.MODULE$.PROP_KEY_PROXY_PORT(), ((Object)BoxesRunTime.boxToInteger((int)proxyPort)).toString());
        return this.startHotRodServer(manager, port, delay, properties);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, Properties props) {
        return this.startHotRodServer(manager, port, 0L, props);
    }

    public HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, long delay$1, Properties props) {
        HotRodServer server = new HotRodServer(delay$1){
            private final long delay$1;

            public Configuration createTopologyCacheConfig(TypedProperties typedProps, long distSyncTimeout) {
                if (this.delay$1 > 0L) {
                    Thread.sleep(this.delay$1);
                }
                Configuration cfg = super.createTopologyCacheConfig(typedProps, distSyncTimeout);
                cfg.setSyncCommitPhase(true);
                cfg.setSyncRollbackPhase(true);
                return cfg;
            }
            {
                this.delay$1 = l;
            }
        };
        props.setProperty(Main$.MODULE$.PROP_KEY_HOST(), this.host());
        props.setProperty(Main$.MODULE$.PROP_KEY_PORT(), ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        server.start(props, manager);
        return server;
    }

    private Properties getProperties(String host, int port, int idleTimeout, String proxyHost, int proxyPort) {
        Properties properties = new Properties();
        properties.setProperty(Main$.MODULE$.PROP_KEY_HOST(), host);
        properties.setProperty(Main$.MODULE$.PROP_KEY_PORT(), ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        properties.setProperty(Main$.MODULE$.PROP_KEY_IDLE_TIMEOUT(), ((Object)BoxesRunTime.boxToInteger((int)idleTimeout)).toString());
        properties.setProperty(Main$.MODULE$.PROP_KEY_PROXY_HOST(), proxyHost);
        properties.setProperty(Main$.MODULE$.PROP_KEY_PROXY_PORT(), ((Object)BoxesRunTime.boxToInteger((int)proxyPort)).toString());
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    public HotRodServer startCrashingHotRodServer(EmbeddedCacheManager manager, int port) {
        void var3_3;
        HotRodServer server = new HotRodServer(){

            public Configuration createTopologyCacheConfig(TypedProperties typedProps, long distSyncTimeout) {
                Configuration cfg = super.createTopologyCacheConfig(typedProps, distSyncTimeout);
                cfg.setSyncCommitPhase(true);
                cfg.setSyncRollbackPhase(true);
                return cfg;
            }
        };
        server.start(this.getProperties(this.host(), port, 0, this.host(), port), manager);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] k(Method m, String prefix) {
        void var3_3;
        byte[] bytes = new StringBuilder().append((Object)prefix).append((Object)m.getName()).toString().getBytes();
        this.trace((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "String %s is converted to %s bytes";
            }
        }, new StringBuilder().append((Object)prefix).append((Object)m.getName()).toString(), Util.printArray((byte[])bytes, (boolean)true));
        return var3_3;
    }

    public byte[] v(Method m, String prefix) {
        return this.k(m, prefix);
    }

    public byte[] k(Method m) {
        return this.k(m, "k-");
    }

    public byte[] v(Method m) {
        return this.v(m, "v-");
    }

    public boolean assertStatus(TestResponse resp, Enumeration.Value expected) {
        Enumeration.Value status;
        Enumeration.Value value = status = resp.status();
        Enumeration.Value value2 = expected;
        boolean isSuccess = !(value != null ? !value.equals(value2) : value2 != null);
        TestResponse testResponse = resp;
        if (testResponse instanceof TestErrorResponse) {
            Assert.assertTrue((boolean)isSuccess, (String)Predef$.MODULE$.augmentString("Status should have been '%s' but instead was: '%s', and the error message was: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected, status, ((TestErrorResponse)testResponse).msg()})));
        } else {
            Assert.assertTrue((boolean)isSuccess, (String)Predef$.MODULE$.augmentString("Status should have been '%s' but instead was: '%s'").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected, status})));
        }
        return isSuccess;
    }

    /*
     * WARNING - void declaration
     */
    public boolean assertSuccess(TestGetResponse resp, byte[] expected) {
        void var3_3;
        this.assertStatus(resp, OperationStatus$.MODULE$.Success());
        boolean isArrayEquals = Arrays.equals(expected, (byte[])resp.data().get());
        Assert.assertTrue((boolean)isArrayEquals, (String)new StringBuilder().append((Object)"Retrieved data should have contained ").append((Object)Util.printArray((byte[])expected, (boolean)true)).append((Object)" (").append((Object)new String(expected)).append((Object)"), but instead we received ").append((Object)Util.printArray((byte[])((byte[])resp.data().get()), (boolean)true)).append((Object)" (").append((Object)new String((byte[])resp.data().get())).append((Object)")").toString());
        return (boolean)var3_3;
    }

    public boolean assertSuccess(TestGetWithVersionResponse resp, byte[] expected, int expectedVersion) {
        Assert.assertTrue((resp.version() != expectedVersion ? 1 : 0) != 0);
        return this.assertSuccess(resp, expected);
    }

    /*
     * WARNING - void declaration
     */
    public boolean assertSuccess(TestResponseWithPrevious resp, byte[] expected) {
        void var3_3;
        this.assertStatus(resp, OperationStatus$.MODULE$.Success());
        boolean isSuccess = Arrays.equals(expected, (byte[])resp.previous().get());
        Assert.assertTrue((boolean)isSuccess);
        return (boolean)var3_3;
    }

    public boolean assertKeyDoesNotExist(TestGetResponse resp) {
        Enumeration.Value status;
        Enumeration.Value value = status = resp.status();
        Enumeration.Value value2 = OperationStatus$.MODULE$.KeyDoesNotExist();
        Assert.assertTrue((!(value != null ? !value.equals(value2) : value2 != null) ? 1 : 0) != 0, (String)new StringBuilder().append((Object)"Status should have been 'KeyDoesNotExist' but instead was: ").append((Object)status).toString());
        Assert.assertEquals(resp.data(), (Object)None$.MODULE$);
        Enumeration.Value value3 = status;
        Enumeration.Value value4 = OperationStatus$.MODULE$.KeyDoesNotExist();
        return !(value3 != null ? !value3.equals(value4) : value4 != null);
    }

    public void assertTopologyReceived(AbstractTopologyResponse resp, List<HotRodServer> servers$2) {
        AbstractTopologyResponse abstractTopologyResponse;
        block5: {
            block3: {
                TestHashDistAware11Response testHashDistAware11Response;
                block4: {
                    TestHashDistAware10Response testHashDistAware10Response;
                    block2: {
                        TestTopologyAwareResponse testTopologyAwareResponse;
                        this.assertTopologyId(resp.viewId(), ((AbstractProtocolServer)servers$2.head()).getCacheManager());
                        abstractTopologyResponse = resp;
                        if (!(abstractTopologyResponse instanceof TestTopologyAwareResponse)) break block2;
                        TestTopologyAwareResponse t = testTopologyAwareResponse = (TestTopologyAwareResponse)abstractTopologyResponse;
                        Assert.assertEquals((int)t.members().size(), (int)2);
                        t.members().foreach((Function1)new Serializable(servers$2){
                            public static final long serialVersionUID;
                            private final List servers$2;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final boolean apply(ServerAddress member$1) {
                                return ((LinearSeqOptimized)this.servers$2.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final ServerAddress apply(HotRodServer hotRodServer) {
                                        return hotRodServer.getAddress();
                                    }
                                }, List$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this, member$1){
                                    public static final long serialVersionUID;
                                    private final ServerAddress member$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final boolean apply(ServerAddress serverAddress) {
                                        ServerAddress serverAddress2 = serverAddress;
                                        ServerAddress serverAddress3 = this.member$1;
                                        return !(serverAddress2 != null ? !serverAddress2.equals(serverAddress3) : serverAddress3 != null);
                                    }
                                    {
                                        this.member$1 = serverAddress;
                                    }
                                });
                            }
                            {
                                this.servers$2 = list;
                            }
                        });
                        break block3;
                    }
                    if (!(abstractTopologyResponse instanceof TestHashDistAware10Response)) break block4;
                    TestHashDistAware10Response h10 = testHashDistAware10Response = (TestHashDistAware10Response)abstractTopologyResponse;
                    Assert.assertEquals((int)h10.members().size(), (int)2);
                    h10.members().foreach((Function1)new Serializable(servers$2){
                        public static final long serialVersionUID;
                        private final List servers$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(ServerAddress member$2) {
                            return ((LinearSeqOptimized)this.servers$2.map((Function1)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final ServerAddress apply(HotRodServer hotRodServer) {
                                    return hotRodServer.getAddress();
                                }
                            }, List$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this, member$2){
                                public static final long serialVersionUID;
                                private final ServerAddress member$2;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final boolean apply(ServerAddress serverAddress) {
                                    ServerAddress serverAddress2 = serverAddress;
                                    ServerAddress serverAddress3 = this.member$2;
                                    return !(serverAddress2 != null ? !serverAddress2.equals(serverAddress3) : serverAddress3 != null);
                                }
                                {
                                    this.member$2 = serverAddress;
                                }
                            });
                        }
                        {
                            this.servers$2 = list;
                        }
                    });
                    break block3;
                }
                if (!(abstractTopologyResponse instanceof TestHashDistAware11Response)) break block5;
                TestHashDistAware11Response h11 = testHashDistAware11Response = (TestHashDistAware11Response)abstractTopologyResponse;
                Assert.assertEquals((int)h11.membersToHash().size(), (int)2);
                h11.membersToHash().foreach((Function1)new Serializable(servers$2){
                    public static final long serialVersionUID;
                    private final List servers$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<ServerAddress, Object> member$3) {
                        return ((LinearSeqOptimized)this.servers$2.map((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final ServerAddress apply(HotRodServer hotRodServer) {
                                return hotRodServer.getAddress();
                            }
                        }, List$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this, member$3){
                            public static final long serialVersionUID;
                            private final Tuple2 member$3;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final boolean apply(ServerAddress serverAddress) {
                                ServerAddress serverAddress2 = serverAddress;
                                Tuple2 tuple2 = this.member$3;
                                return !(serverAddress2 != null ? !serverAddress2.equals(tuple2) : tuple2 != null);
                            }
                            {
                                this.member$3 = tuple2;
                            }
                        });
                    }
                    {
                        this.servers$2 = list;
                    }
                });
            }
            return;
        }
        throw new MatchError((Object)abstractTopologyResponse);
    }

    public void assertHashTopologyReceived(AbstractTopologyResponse topoResp, List<HotRodServer> servers, Map<ServerAddress, Seq<Object>> hashIds) {
        this.assertHashTopology10Received(topoResp, servers, hashIds, 2, this.EXPECTED_HASH_FUNCTION_VERSION(), Integer.MAX_VALUE);
    }

    public void assertNoHashTopologyReceived(AbstractTopologyResponse topoResp, List<HotRodServer> servers, Map<ServerAddress, Seq<Object>> hashIds) {
        this.assertHashTopology10Received(topoResp, servers, hashIds, 0, 0, 0);
    }

    public void assertHashTopology10Received(AbstractTopologyResponse topoResp, List<HotRodServer> servers$3, Map<ServerAddress, Seq<Object>> hashIds, int expectedNumOwners, int expectedHashFct, int expectedHashSpace) {
        TestHashDistAware10Response hashTopologyResp = (TestHashDistAware10Response)topoResp;
        this.assertTopologyId(hashTopologyResp.viewId(), ((AbstractProtocolServer)servers$3.head()).getCacheManager());
        Assert.assertEquals((int)hashTopologyResp.members().size(), (int)servers$3.size());
        hashTopologyResp.members().foreach((Function1)new Serializable(servers$3){
            public static final long serialVersionUID;
            private final List servers$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(ServerAddress member$4) {
                return ((LinearSeqOptimized)this.servers$3.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final ServerAddress apply(HotRodServer hotRodServer) {
                        return hotRodServer.getAddress();
                    }
                }, List$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this, member$4){
                    public static final long serialVersionUID;
                    private final ServerAddress member$4;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(ServerAddress serverAddress) {
                        ServerAddress serverAddress2 = serverAddress;
                        ServerAddress serverAddress3 = this.member$4;
                        return !(serverAddress2 != null ? !serverAddress2.equals(serverAddress3) : serverAddress3 != null);
                    }
                    {
                        this.member$4 = serverAddress;
                    }
                });
            }
            {
                this.servers$3 = list;
            }
        });
        this.assertHashIds(hashTopologyResp.hashIds(), hashIds);
        Assert.assertEquals((int)hashTopologyResp.numOwners(), (int)expectedNumOwners);
        Assert.assertEquals((int)hashTopologyResp.hashFunction(), (int)expectedHashFct);
        Assert.assertEquals((int)hashTopologyResp.hashSpace(), (int)expectedHashSpace);
    }

    public void assertHashTopologyReceived(AbstractTopologyResponse topoResp, List<HotRodServer> servers$1, int expectedVirtualNodes) {
        TestHashDistAware11Response hashTopologyResp = (TestHashDistAware11Response)topoResp;
        this.assertTopologyId(hashTopologyResp.viewId(), ((AbstractProtocolServer)servers$1.head()).getCacheManager());
        Assert.assertEquals((int)hashTopologyResp.membersToHash().size(), (int)servers$1.size());
        hashTopologyResp.membersToHash().foreach((Function1)new Serializable(servers$1){
            public static final long serialVersionUID;
            private final List servers$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<ServerAddress, Object> member$5) {
                return ((LinearSeqOptimized)this.servers$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final ServerAddress apply(HotRodServer hotRodServer) {
                        return hotRodServer.getAddress();
                    }
                }, List$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this, member$5){
                    public static final long serialVersionUID;
                    private final Tuple2 member$5;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(ServerAddress serverAddress) {
                        ServerAddress serverAddress2 = serverAddress;
                        Tuple2 tuple2 = this.member$5;
                        return !(serverAddress2 != null ? !serverAddress2.equals(tuple2) : tuple2 != null);
                    }
                    {
                        this.member$5 = tuple2;
                    }
                });
            }
            {
                this.servers$1 = list;
            }
        });
        Assert.assertEquals((int)hashTopologyResp.numOwners(), (int)2);
        Assert.assertEquals((byte)hashTopologyResp.hashFunction(), (byte)this.EXPECTED_HASH_FUNCTION_VERSION());
        Assert.assertEquals((int)hashTopologyResp.hashSpace(), (int)Integer.MAX_VALUE);
        Assert.assertEquals((int)hashTopologyResp.numVirtualNodes(), (int)expectedVirtualNodes);
    }

    public void assertHashIds(Map<ServerAddress, Seq<Object>> hashIds, Map<ServerAddress, Seq<Object>> expectedHashIds) {
        Assert.assertEquals(hashIds, expectedHashIds);
    }

    public void assertTopologyId(int viewId, EmbeddedCacheManager cm) {
        Assert.assertEquals((int)viewId, (int)cm.getCache(HotRodServer$.MODULE$.ADDRESS_CACHE_NAME()).getAdvancedCache().getRpcManager().getTransport().getViewId());
    }

    public Seq<CountDownLatch> getAddressCacheRemovalLatches(List<HotRodServer> servers) {
        ListBuffer latches$1 = new ListBuffer();
        servers.foreach((Function1)new Serializable(latches$1){
            public static final long serialVersionUID;
            private final ListBuffer latches$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ListBuffer<CountDownLatch> apply(HotRodServer server) {
                CountDownLatch addressRemovalLatch = new CountDownLatch(1);
                server.getAddressCache().addListener((Object)new HotRodTestingUtil.AddressRemovalListener(addressRemovalLatch));
                return this.latches$1.$plus$eq((Object)addressRemovalLatch);
            }
            {
                this.latches$1 = listBuffer;
            }
        });
        return latches$1.toList();
    }

    public void waitAddressCacheRemoval(Seq<CountDownLatch> latches) {
        latches.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(CountDownLatch latch) {
                boolean completed = latch.await(60L, TimeUnit.SECONDS);
                if (completed) {
                    return;
                }
                throw new Exception("Timed out waiting for address cache to be updated");
            }
        });
    }

    private HotRodTestingUtil$() {
        MODULE$ = this;
        Log.class.$init$((org.infinispan.server.core.logging.Log)this);
        Log.class.$init$((Log)this);
        this.EXPECTED_HASH_FUNCTION_VERSION = (byte)2;
    }
}

