/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.remote.configuration.AuthenticationConfiguration;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.SslConfiguration;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.persistence.remote.wrapper.HotRodEntryMarshaller;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.FlagAffectedStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

@Store(shared=true)
@ThreadSafe
@ConfiguredBy(value=RemoteStoreConfiguration.class)
public class RemoteStore<K, V>
implements AdvancedLoadWriteStore<K, V>,
FlagAffectedStore<K, V> {
    private static final Log log = (Log)LogFactory.getLog(RemoteStore.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private RemoteStoreConfiguration configuration;
    private volatile RemoteCacheManager remoteCacheManager;
    private volatile RemoteCache<Object, Object> remoteCache;
    private InternalEntryFactory iceFactory;
    private static final String LIFESPAN = "lifespan";
    private static final String MAXIDLE = "maxidle";
    protected InitializationContext ctx;

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (RemoteStoreConfiguration)ctx.getConfiguration();
    }

    public void start() throws PersistenceException {
        Object marshaller = this.configuration.marshaller() != null ? (Marshaller)Util.getInstance((String)this.configuration.marshaller(), (ClassLoader)this.ctx.getCache().getAdvancedCache().getClassLoader()) : (this.configuration.hotRodWrapping() ? new HotRodEntryMarshaller(this.ctx.getByteBufferFactory()) : (this.configuration.rawValues() ? new GenericJBossMarshaller(Thread.currentThread().getContextClassLoader()) : this.ctx.getMarshaller()));
        ConfigurationBuilder builder = this.buildRemoteConfiguration(this.configuration, (Marshaller)marshaller);
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        this.remoteCache = this.configuration.remoteCacheName().equals("___defaultcache") ? this.remoteCacheManager.getCache() : this.remoteCacheManager.getCache(this.configuration.remoteCacheName());
        if (this.configuration.rawValues() && this.iceFactory == null) {
            this.iceFactory = (InternalEntryFactory)this.ctx.getCache().getAdvancedCache().getComponentRegistry().getComponent(InternalEntryFactory.class);
        }
    }

    public void stop() throws PersistenceException {
        this.remoteCacheManager.stop();
    }

    public MarshalledEntry load(Object key) throws PersistenceException {
        if (this.configuration.rawValues()) {
            Object unwrappedKey = key instanceof WrappedByteArray ? (Object)((WrappedByteArray)key).getBytes() : key;
            MetadataValue value = this.remoteCache.getWithMetadata(unwrappedKey);
            if (value != null) {
                Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(value.getVersion())).lifespan((long)value.getLifespan(), TimeUnit.SECONDS).maxIdle((long)value.getMaxIdle(), TimeUnit.SECONDS).build();
                long created = value.getCreated();
                long lastUsed = value.getLastUsed();
                Object realValue = value.getValue();
                if (realValue instanceof byte[]) {
                    realValue = new WrappedByteArray((byte[])realValue);
                }
                return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, realValue, (InternalMetadata)new InternalMetadataImpl(metadata, created, lastUsed));
            }
            return null;
        }
        if (key instanceof WrappedByteArray) {
            key = ((WrappedByteArray)key).getBytes();
        }
        return (MarshalledEntry)this.remoteCache.get(key);
    }

    public boolean contains(Object key) throws PersistenceException {
        if (key instanceof WrappedByteArray) {
            key = ((WrappedByteArray)key).getBytes();
        }
        return this.remoteCache.containsKey(key);
    }

    public void process(KeyFilter filter, AdvancedCacheLoader.CacheLoaderTask task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        TaskContextImpl taskContext = new TaskContextImpl();
        for (Object key : this.remoteCache.keySet()) {
            if (key instanceof byte[]) {
                key = new WrappedByteArray((byte[])key);
            }
            if (taskContext.isStopped()) break;
            if (filter != null && !filter.accept(key)) continue;
            try {
                MarshalledEntry marshalledEntry = this.load(key);
                if (marshalledEntry == null) continue;
                task.processEntry(marshalledEntry, (AdvancedCacheLoader.TaskContext)taskContext);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public int size() {
        return this.remoteCache.size();
    }

    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener task) {
    }

    public void write(MarshalledEntry entry) throws PersistenceException {
        InternalMetadata metadata;
        if (trace) {
            log.tracef("Adding entry: %s", entry);
        }
        long lifespan = (metadata = entry.getMetadata()) != null ? metadata.lifespan() : -1L;
        long maxIdle = metadata != null ? metadata.maxIdle() : -1L;
        Object key = this.getKey(entry);
        Object value = this.getValue(entry);
        this.remoteCache.put(key, value, this.toSeconds(lifespan, entry.getKey(), LIFESPAN), TimeUnit.SECONDS, this.toSeconds(maxIdle, entry.getKey(), MAXIDLE), TimeUnit.SECONDS);
    }

    private Object getKey(MarshalledEntry entry) {
        Object key = entry.getKey();
        if (key instanceof WrappedByteArray) {
            return ((WrappedByteArray)key).getBytes();
        }
        return key;
    }

    private Object getValue(MarshalledEntry entry) {
        if (this.configuration.rawValues()) {
            Object value = entry.getValue();
            return value instanceof WrappedByteArray ? (Object)((WrappedByteArray)value).getBytes() : value;
        }
        return entry;
    }

    public void writeBatch(Iterable<MarshalledEntry<? extends K, ? extends V>> marshalledEntries) {
        HashMap<Object, Object> batch = new HashMap<Object, Object>();
        for (MarshalledEntry<K, V> marshalledEntry : marshalledEntries) {
            batch.put(this.getKey(marshalledEntry), this.getValue(marshalledEntry));
            if (batch.size() != this.configuration.maxBatchSize()) continue;
            this.remoteCache.putAll(batch);
            batch.clear();
        }
        if (!batch.isEmpty()) {
            this.remoteCache.putAll(batch);
        }
    }

    public void clear() throws PersistenceException {
        this.remoteCache.clear();
    }

    public boolean delete(Object key) throws PersistenceException {
        if (key instanceof WrappedByteArray) {
            key = ((WrappedByteArray)key).getBytes();
        }
        return this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove(key) != null;
    }

    private long toSeconds(long millis, Object key, String desc) {
        if (millis > 0L && millis < 1000L) {
            if (trace) {
                log.tracef("Adjusting %s time for (k,v): (%s, %s) from %d millis to 1 sec, as milliseconds are not supported by HotRod", desc, key, millis);
            }
            return 1L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    public void setInternalCacheEntryFactory(InternalEntryFactory iceFactory) {
        if (this.iceFactory != null) {
            throw new IllegalStateException();
        }
        this.iceFactory = iceFactory;
    }

    public RemoteCache<Object, Object> getRemoteCache() {
        return this.remoteCache;
    }

    private ConfigurationBuilder buildRemoteConfiguration(RemoteStoreConfiguration configuration, Marshaller marshaller) {
        AuthenticationConfiguration auth;
        SslConfiguration ssl;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        for (RemoteServerConfiguration s : configuration.servers()) {
            builder.addServer().host(s.host()).port(s.port());
        }
        ConnectionPoolConfiguration poolConfiguration = configuration.connectionPool();
        Long connectionTimeout = configuration.connectionTimeout();
        Long socketTimeout = configuration.socketTimeout();
        builder.classLoader(((Object)((Object)configuration)).getClass().getClassLoader()).balancingStrategy(configuration.balancingStrategy()).connectionPool().exhaustedAction(ExhaustedAction.valueOf((String)poolConfiguration.exhaustedAction().toString())).maxActive(poolConfiguration.maxActive()).maxIdle(poolConfiguration.maxIdle()).maxTotal(poolConfiguration.maxTotal()).minIdle(poolConfiguration.minIdle()).minEvictableIdleTime(poolConfiguration.minEvictableIdleTime()).testWhileIdle(poolConfiguration.testWhileIdle()).timeBetweenEvictionRuns(poolConfiguration.timeBetweenEvictionRuns()).connectionTimeout(connectionTimeout.intValue()).forceReturnValues(configuration.forceReturnValues()).keySizeEstimate(configuration.keySizeEstimate()).marshaller(marshaller).asyncExecutorFactory().factoryClass(configuration.asyncExecutorFactory().factory().getClass()).socketTimeout(socketTimeout.intValue()).tcpNoDelay(configuration.tcpNoDelay()).valueSizeEstimate(configuration.valueSizeEstimate());
        if (configuration.protocolVersion() != null) {
            builder.protocolVersion(configuration.protocolVersion());
        } else {
            builder.version(ProtocolVersion.DEFAULT_PROTOCOL_VERSION);
        }
        if (configuration.transportFactory() != null) {
            builder.transportFactory(configuration.transportFactory());
        }
        if ((ssl = configuration.security().ssl()).enabled()) {
            builder.security().ssl().enable().keyStoreType(ssl.keyStoreType()).keyAlias(ssl.keyAlias()).keyStoreFileName(ssl.keyStoreFileName()).keyStorePassword(ssl.keyStorePassword()).keyStoreCertificatePassword(ssl.keyStoreCertificatePassword()).trustStoreFileName(ssl.trustStoreFileName()).trustStorePassword(ssl.trustStorePassword()).trustStoreType(ssl.trustStoreType()).protocol(ssl.protocol()).sniHostName(ssl.sniHostName());
        }
        if ((auth = configuration.security().authentication()).enabled()) {
            builder.security().authentication().enable().callbackHandler(auth.callbackHandler()).clientSubject(auth.clientSubject()).saslMechanism(auth.saslMechanism()).serverName(auth.serverName()).saslProperties(auth.saslProperties()).username(auth.username()).password(auth.password()).realm(auth.realm());
        }
        builder.withProperties(configuration.properties());
        return builder;
    }

    public RemoteStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean shouldWrite(long commandFlags) {
        return !EnumUtil.containsAny((long)FlagBitSets.ROLLING_UPGRADE, (long)commandFlags);
    }
}

