/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.conflict.ConflictManager;
import org.infinispan.conflict.impl.DefaultConflictManager;
import org.infinispan.conflict.impl.InternalConflictManager;
import org.infinispan.conflict.impl.StateReceiver;
import org.infinispan.conflict.impl.StateReceiverImpl;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.scattered.impl.ScatteredStateConsumerImpl;
import org.infinispan.scattered.impl.ScatteredStateProviderImpl;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateConsumerImpl;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.StateProviderImpl;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.statetransfer.StateTransferManagerImpl;

@DefaultFactoryFor(classes={StateTransferManager.class, StateConsumer.class, StateProvider.class, StateReceiver.class, ConflictManager.class, InternalConflictManager.class})
public class StateTransferComponentFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (!this.configuration.clustering().cacheMode().isClustered()) {
            return null;
        }
        if (componentType.equals(StateTransferManager.class)) {
            return componentType.cast(new StateTransferManagerImpl());
        }
        if (componentType.equals(StateProvider.class)) {
            if (this.configuration.clustering().cacheMode().isScattered()) {
                return componentType.cast(new ScatteredStateProviderImpl());
            }
            return componentType.cast(new StateProviderImpl());
        }
        if (componentType.equals(StateConsumer.class)) {
            if (this.configuration.clustering().cacheMode().isScattered()) {
                return componentType.cast(new ScatteredStateConsumerImpl());
            }
            return componentType.cast(new StateConsumerImpl());
        }
        if (componentType.equals(StateReceiver.class)) {
            return componentType.cast(new StateReceiverImpl());
        }
        if (componentType.isAssignableFrom(InternalConflictManager.class)) {
            return componentType.cast(new DefaultConflictManager());
        }
        throw new CacheConfigurationException("Don't know how to create a " + componentType.getName());
    }
}

