/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.BitSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.RemovableCloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class KeyStreamSupplier<K, V>
implements AbstractLocalCacheStream.StreamSupplier<K, Stream<K>> {
    private static final Log log = LogFactory.getLog(KeyStreamSupplier.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Cache<K, V> cache;
    private final ConsistentHash hash;
    private final Supplier<Stream<K>> supplier;

    public KeyStreamSupplier(Cache<K, V> cache, ConsistentHash hash, Supplier<Stream<K>> supplier) {
        this.cache = cache;
        this.hash = hash;
        this.supplier = supplier;
    }

    @Override
    public Stream<K> buildStream(Set<Integer> segmentsToFilter, Set<?> keysToFilter) {
        Stream<Object> stream;
        if (keysToFilter != null) {
            if (trace) {
                log.tracef("Applying key filtering %s", keysToFilter);
            }
            AdvancedCache<K, V> advancedCache = AbstractDelegatingCache.unwrapCache(this.cache).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
            stream = keysToFilter.stream().filter(arg_0 -> advancedCache.containsKey(arg_0));
        } else {
            stream = this.supplier.get();
        }
        if (segmentsToFilter != null && this.hash != null) {
            if (trace) {
                log.tracef("Applying segment filter %s", segmentsToFilter);
            }
            BitSet bitSet = new BitSet(this.hash.getNumSegments());
            segmentsToFilter.forEach(bitSet::set);
            stream = stream.filter(k -> bitSet.get(this.hash.getSegment(k)));
        }
        return stream;
    }

    @Override
    public CloseableIterator<K> removableIterator(CloseableIterator<K> realIterator) {
        return new RemovableCloseableIterator(realIterator, arg_0 -> this.cache.remove(arg_0));
    }
}

