/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import javax.security.sasl.SaslServerFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.CompatModeEncoder;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.filter.NamedFactory;
import org.infinispan.filter.ParamKeyValueFilterConverterFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listenable;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.query.remote.ProtostreamCompatEncoder;
import org.infinispan.query.remote.client.BaseProtoStreamMarshaller;
import org.infinispan.query.remote.impl.ProtostreamWrapper;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.QueryFacade;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.security.SaslUtils;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.hotrod.CheckAddressTask;
import org.infinispan.server.hotrod.ClientListenerRegistry;
import org.infinispan.server.hotrod.CrashedMemberDetectorListener;
import org.infinispan.server.hotrod.HotRodDecoder;
import org.infinispan.server.hotrod.HotRodEncoder;
import org.infinispan.server.hotrod.HotRodSourceMigrator;
import org.infinispan.server.hotrod.SecurityActions;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.event.KeyValueWithPreviousEventConverterFactory;
import org.infinispan.server.hotrod.iteration.DefaultIterationManager;
import org.infinispan.server.hotrod.iteration.IterationManager;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.transport.HotRodChannelInitializer;
import org.infinispan.server.hotrod.transport.TimeoutEnabledChannelInitializer;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.upgrade.SourceMigrator;

public class HotRodServer
extends AbstractProtocolServer<HotRodServerConfiguration> {
    private static final Log log = (Log)LogFactory.getLog(HotRodServer.class, Log.class);
    private static final String WORKER_THREADS_SYS_PROP = "infinispan.server.hotrod.workerThreads";
    private boolean isClustered;
    private Address clusterAddress;
    private ServerAddress address;
    private Cache<Address, ServerAddress> addressCache;
    private Map<String, AdvancedCache> knownCaches = CollectionFactory.makeConcurrentMap((int)4, (float)0.9f, (int)16);
    private Map<String, Configuration> knownCacheConfigurations = CollectionFactory.makeConcurrentMap((int)4, (float)0.9f, (int)16);
    private Map<String, ComponentRegistry> knownCacheRegistries = CollectionFactory.makeConcurrentMap((int)4, (float)0.9f, (int)16);
    private QueryFacade queryFacade;
    private Map<String, SaslServerFactory> saslMechFactories = CollectionFactory.makeConcurrentMap((int)4, (float)0.9f, (int)16);
    private ClientListenerRegistry clientListenerRegistry;
    private Marshaller marshaller;
    private DefaultExecutorService distributedExecutorService;
    private CrashedMemberDetectorListener viewChangeListener;
    private ReAddMyAddressListener topologyChangeListener;
    protected ExecutorService executor;
    private IterationManager iterationManager;
    private RemoveCacheListener removeCacheListener;
    ThreadPoolExecutor.AbortPolicy abortPolicy = new ThreadPoolExecutor.AbortPolicy(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (HotRodServer.this.executor.isShutdown()) {
                throw new IllegalLifecycleStateException("Server has been stopped");
            }
            super.rejectedExecution(r, e);
        }
    };

    public HotRodServer() {
        super("HotRod");
    }

    public ServerAddress getAddress() {
        return this.address;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    byte[] query(AdvancedCache<byte[], byte[]> cache, byte[] query) {
        return this.queryFacade.query(cache, query);
    }

    public ClientListenerRegistry getClientListenerRegistry() {
        return this.clientListenerRegistry;
    }

    public ChannelOutboundHandler getEncoder() {
        return new HotRodEncoder(this.cacheManager, this);
    }

    public HotRodDecoder getDecoder() {
        return new HotRodDecoder(this.cacheManager, this.transport, this, arg_0 -> ((HotRodServer)this).isCacheIgnored(arg_0));
    }

    protected void startInternal(HotRodServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        this.configuration = configuration;
        this.cacheManager = cacheManager;
        this.iterationManager = new DefaultIterationManager(cacheManager);
        this.setupSasl();
        List<QueryFacade> queryFacades = this.loadQueryFacades();
        this.queryFacade = queryFacades.size() > 0 ? queryFacades.get(0) : null;
        this.clientListenerRegistry = new ClientListenerRegistry(configuration);
        this.addKeyValueFilterConverterFactory(ToEmptyBytesKeyValueFilterConverter.class.getName(), (KeyValueFilterConverterFactory)new ToEmptyBytesFactory());
        this.addCacheEventConverterFactory("key-value-with-previous-converter-factory", new KeyValueWithPreviousEventConverterFactory());
        this.loadFilterConverterFactories(ParamKeyValueFilterConverterFactory.class, this::addKeyValueFilterConverterFactory);
        this.loadFilterConverterFactories(CacheEventFilterConverterFactory.class, this::addCacheEventFilterConverterFactory);
        this.loadFilterConverterFactories(CacheEventConverterFactory.class, this::addCacheEventConverterFactory);
        this.loadFilterConverterFactories(KeyValueFilterConverterFactory.class, this::addKeyValueFilterConverterFactory);
        this.removeCacheListener = new RemoveCacheListener();
        cacheManager.addListener((Object)this.removeCacheListener);
        super.startInternal((ProtocolServerConfiguration)configuration, cacheManager);
        if (Configurations.isClustered((GlobalConfiguration)cacheManager.getCacheManagerConfiguration())) {
            this.defineTopologyCacheConfig(cacheManager);
            if (log.isDebugEnabled()) {
                log.debugf("Externally facing address is %s:%d", configuration.proxyHost(), configuration.proxyPort());
            }
            this.addSelfToTopologyView(cacheManager);
        }
    }

    public ExecutorService getExecutor(String threadPrefix) {
        if (this.executor == null || this.executor.isShutdown()) {
            DefaultThreadFactory factory = new DefaultThreadFactory(threadPrefix + "-ServerHandler");
            int workerThreads = Integer.getInteger(WORKER_THREADS_SYS_PROP, ((HotRodServerConfiguration)this.configuration).workerThreads());
            this.executor = new ThreadPoolExecutor(workerThreads, workerThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)factory, this.abortPolicy);
        }
        return this.executor;
    }

    public ChannelInitializer<Channel> getInitializer() {
        if (((HotRodServerConfiguration)this.configuration).idleTimeout() > 0) {
            return new NettyInitializers(Arrays.asList(new NettyInitializer[]{new HotRodChannelInitializer(this, this.transport, this.getEncoder(), (ChannelInboundHandler)this.getDecoder(), this.getExecutor(this.getQualifiedName())), new TimeoutEnabledChannelInitializer(this)}));
        }
        return new NettyInitializers((NettyInitializer)new HotRodChannelInitializer(this, this.transport, this.getEncoder(), (ChannelInboundHandler)this.getDecoder(), this.getExecutor(this.getQualifiedName())));
    }

    private <T> void loadFilterConverterFactories(Class<T> c, BiConsumer<String, T> biConsumer) {
        ServiceFinder.load(c, (ClassLoader[])new ClassLoader[0]).forEach(factory -> {
            NamedFactory annotation = factory.getClass().getAnnotation(NamedFactory.class);
            if (annotation != null) {
                String name = annotation.name();
                biConsumer.accept(name, factory);
            }
        });
    }

    private List<QueryFacade> loadQueryFacades() {
        ArrayList<QueryFacade> facades = new ArrayList<QueryFacade>();
        ServiceLoader.load(QueryFacade.class, ((Object)((Object)this)).getClass().getClassLoader()).forEach(facades::add);
        return facades;
    }

    protected void startTransport() {
        this.preStartCaches();
        super.startTransport();
    }

    protected void startDefaultCache() {
        this.getCacheInstance(((HotRodServerConfiguration)this.configuration).defaultCacheName(), this.cacheManager, true, true);
    }

    private void preStartCaches() {
        InternalCacheRegistry icr = (InternalCacheRegistry)this.cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        boolean authz = this.cacheManager.getCacheManagerConfiguration().security().authorization().enabled();
        for (String cacheName : this.cacheManager.getCacheNames()) {
            this.getCacheInstance(cacheName, this.cacheManager, false, !icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.PROTECTED) || authz);
        }
    }

    private void addSelfToTopologyView(EmbeddedCacheManager cacheManager) {
        this.addressCache = cacheManager.getCache(((HotRodServerConfiguration)this.configuration).topologyCacheName());
        this.clusterAddress = cacheManager.getAddress();
        this.address = new ServerAddress(((HotRodServerConfiguration)this.configuration).proxyHost(), ((HotRodServerConfiguration)this.configuration).proxyPort());
        this.distributedExecutorService = new DefaultExecutorService(this.addressCache);
        this.viewChangeListener = new CrashedMemberDetectorListener(this.addressCache, this);
        cacheManager.addListener((Object)this.viewChangeListener);
        this.topologyChangeListener = new ReAddMyAddressListener(this.addressCache, this.clusterAddress, this.address);
        this.addressCache.addListener((Object)this.topologyChangeListener);
        log.debugf("Map %s cluster address with %s server endpoint in address cache", this.clusterAddress, this.address);
        this.addressCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.GUARANTEED_DELIVERY}).put((Object)this.clusterAddress, (Object)this.address);
    }

    private void defineTopologyCacheConfig(EmbeddedCacheManager cacheManager) {
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache(((HotRodServerConfiguration)this.configuration).topologyCacheName(), this.createTopologyCacheConfig(cacheManager.getCacheManagerConfiguration().transport().distributedSyncTimeout()).build(), EnumSet.of(InternalCacheRegistry.Flag.EXCLUSIVE));
    }

    protected ConfigurationBuilder createTopologyCacheConfig(long distSyncTimeout) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).remoteTimeout(((HotRodServerConfiguration)this.configuration).topologyReplTimeout()).locking().lockAcquisitionTimeout(((HotRodServerConfiguration)this.configuration).topologyLockTimeout()).expiration().lifespan(-1L).maxIdle(-1L);
        if (((HotRodServerConfiguration)this.configuration).topologyStateTransfer()) {
            builder.clustering().stateTransfer().awaitInitialTransfer(((HotRodServerConfiguration)this.configuration).topologyAwaitInitialTransfer()).fetchInMemoryState(true).timeout(distSyncTimeout + ((HotRodServerConfiguration)this.configuration).topologyReplTimeout());
        } else {
            builder.persistence().addClusterLoader().remoteCallTimeout(((HotRodServerConfiguration)this.configuration).topologyReplTimeout());
        }
        return builder;
    }

    AdvancedCache getKnownCache(String cacheName) {
        return this.knownCaches.get(cacheName);
    }

    AdvancedCache getCacheInstance(String cacheName, EmbeddedCacheManager cacheManager, Boolean skipCacheCheck, Boolean addToKnownCaches) {
        AdvancedCache cache = null;
        if (!skipCacheCheck.booleanValue()) {
            cache = this.knownCaches.get(cacheName);
        }
        if (cache == null) {
            String validCacheName = cacheName.isEmpty() ? ((HotRodServerConfiguration)this.configuration).defaultCacheName() : cacheName;
            Cache tmpCache = SecurityActions.getCache(cacheManager, validCacheName);
            Configuration cacheConfiguration = SecurityActions.getCacheConfiguration(tmpCache.getAdvancedCache());
            boolean compatibility = cacheConfiguration.compatibility().enabled();
            Marshaller marshaller = cacheConfiguration.compatibility().marshaller();
            boolean indexing = cacheConfiguration.indexing().index().isEnabled();
            ComponentRegistry cacheComponentRegistry = SecurityActions.getCacheComponentRegistry(tmpCache.getAdvancedCache());
            if (marshaller != null) {
                cacheComponentRegistry.wireDependencies((Object)marshaller);
            }
            if (compatibility || indexing) {
                cache = tmpCache.getAdvancedCache().withFlags(new Flag[]{Flag.OPERATION_HOTROD});
                if (compatibility && !indexing) {
                    cache = cache.getAdvancedCache().withEncoding(CompatModeEncoder.class);
                }
                if (compatibility && indexing) {
                    cache = marshaller instanceof BaseProtoStreamMarshaller ? cache.getAdvancedCache().withEncoding(ProtostreamCompatEncoder.class).withWrapping(ByteArrayWrapper.class, ProtostreamWrapper.class) : cache.getAdvancedCache().withEncoding(CompatModeEncoder.class);
                }
                if (!compatibility) {
                    cache = cache.getAdvancedCache().withWrapping(ByteArrayWrapper.class, ProtostreamWrapper.class);
                }
            } else {
                cache = tmpCache.getAdvancedCache();
            }
            this.knownCacheConfigurations.put(cacheName, cacheConfiguration);
            this.knownCacheRegistries.put(cacheName, SecurityActions.getCacheComponentRegistry(tmpCache.getAdvancedCache()));
            if (addToKnownCaches.booleanValue()) {
                this.knownCaches.put(cacheName, cache);
            }
            this.tryRegisterMigrationManager(cacheName, (AdvancedCache<byte[], byte[]>)cache);
        }
        return cache;
    }

    Configuration getCacheConfiguration(String cacheName) {
        return this.knownCacheConfigurations.get(cacheName);
    }

    ComponentRegistry getCacheRegistry(String cacheName) {
        return this.knownCacheRegistries.get(cacheName);
    }

    void tryRegisterMigrationManager(String cacheName, AdvancedCache<byte[], byte[]> cache) {
        ComponentRegistry cr = SecurityActions.getCacheComponentRegistry(cache.getAdvancedCache());
        RollingUpgradeManager migrationManager = (RollingUpgradeManager)cr.getComponent(RollingUpgradeManager.class);
        if (migrationManager != null) {
            migrationManager.addSourceMigrator((SourceMigrator)new HotRodSourceMigrator(cache));
        }
    }

    private void setupSasl() {
        Iterator saslFactories = SaslUtils.getSaslServerFactories((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (boolean)true);
        while (saslFactories.hasNext()) {
            String[] saslFactoryMechs;
            SaslServerFactory saslFactory = (SaslServerFactory)saslFactories.next();
            for (String supportedMech : saslFactoryMechs = saslFactory.getMechanismNames(((HotRodServerConfiguration)this.configuration).authentication().mechProperties())) {
                for (String mech : ((HotRodServerConfiguration)this.configuration).authentication().allowedMechs()) {
                    if (!supportedMech.equals(mech)) continue;
                    this.saslMechFactories.putIfAbsent(mech, saslFactory);
                }
            }
        }
    }

    SaslServerFactory getSaslServerFactory(String mech) {
        return this.saslMechFactories.get(mech);
    }

    private Cache<Address, ServerAddress> getAddressCache() {
        return this.addressCache;
    }

    public void addCacheEventFilterFactory(String name, CacheEventFilterFactory factory) {
        this.clientListenerRegistry.addCacheEventFilterFactory(name, factory);
    }

    public void removeCacheEventFilterFactory(String name) {
        this.clientListenerRegistry.removeCacheEventFilterFactory(name);
    }

    public void addCacheEventConverterFactory(String name, CacheEventConverterFactory factory) {
        this.clientListenerRegistry.addCacheEventConverterFactory(name, factory);
    }

    public void removeCacheEventConverterFactory(String name) {
        this.clientListenerRegistry.removeCacheEventConverterFactory(name);
    }

    public void addCacheEventFilterConverterFactory(String name, CacheEventFilterConverterFactory factory) {
        this.clientListenerRegistry.addCacheEventFilterConverterFactory(name, factory);
    }

    public void removeCacheEventFilterConverterFactory(String name) {
        this.clientListenerRegistry.removeCacheEventFilterConverterFactory(name);
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        Optional<Marshaller> optMarshaller = Optional.ofNullable(marshaller);
        this.clientListenerRegistry.setEventMarshaller(optMarshaller);
        this.iterationManager.setMarshaller(optMarshaller);
    }

    public void addKeyValueFilterConverterFactory(String name, KeyValueFilterConverterFactory factory) {
        this.iterationManager.addKeyValueFilterConverterFactory(name, factory);
    }

    public void removeKeyValueFilterConverterFactory(String name) {
        this.iterationManager.removeKeyValueFilterConverterFactory(name);
    }

    public IterationManager getIterationManager() {
        return this.iterationManager;
    }

    public void stop() {
        InternalCacheRegistry internalCacheRegistry;
        if (this.removeCacheListener != null) {
            SecurityActions.removeListener((Listenable)this.cacheManager, this.removeCacheListener);
        }
        if (this.viewChangeListener != null) {
            SecurityActions.removeListener((Listenable)this.cacheManager, this.viewChangeListener);
        }
        if (this.topologyChangeListener != null) {
            SecurityActions.removeListener(this.addressCache, this.topologyChangeListener);
        }
        if (Configurations.isClustered((GlobalConfiguration)this.cacheManager.getCacheManagerConfiguration()) && (internalCacheRegistry = (InternalCacheRegistry)this.cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class)) != null) {
            internalCacheRegistry.unregisterInternalCache(((HotRodServerConfiguration)this.configuration).topologyCacheName());
        }
        if (this.distributedExecutorService != null) {
            this.distributedExecutorService.shutdownNow();
        }
        if (this.clientListenerRegistry != null) {
            this.clientListenerRegistry.stop();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        super.stop();
    }

    @Listener
    class RemoveCacheListener {
        RemoveCacheListener() {
        }

        @CacheStopped
        public void cacheStopped(CacheStoppedEvent event) {
            HotRodServer.this.knownCaches.remove(event.getCacheName());
            HotRodServer.this.knownCacheConfigurations.remove(event.getCacheName());
            HotRodServer.this.knownCacheRegistries.remove(event.getCacheName());
        }
    }

    @Listener(sync=false, observation=Listener.Observation.POST)
    class ReAddMyAddressListener {
        private final Cache<Address, ServerAddress> addressCache;
        private final Address clusterAddress;
        private final ServerAddress address;

        ReAddMyAddressListener(Cache<Address, ServerAddress> addressCache, Address clusterAddress, ServerAddress address) {
            this.addressCache = addressCache;
            this.clusterAddress = clusterAddress;
            this.address = address;
        }

        @TopologyChanged
        public void topologyChanged(TopologyChangedEvent<Address, ServerAddress> event) {
            boolean success = false;
            while (!success && !HotRodServer.this.distributedExecutorService.isShutdown() && this.addressCache.getStatus().allowInvocations()) {
                try {
                    List futures = HotRodServer.this.distributedExecutorService.submitEverywhere((Callable)((Object)new CheckAddressTask(this.clusterAddress)));
                    AtomicBoolean result = new AtomicBoolean(true);
                    futures.forEach(f -> {
                        try {
                            if (!((Boolean)f.get()).booleanValue()) {
                                result.set(false);
                            }
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new CacheException((Throwable)e);
                        }
                    });
                    if (!result.get()) {
                        log.debugf("Re-adding %s to the topology cache", this.clusterAddress);
                        this.addressCache.putAsync((Object)this.clusterAddress, (Object)this.address);
                    }
                    success = true;
                }
                catch (Throwable e) {
                    log.debug("Error re-adding address to topology cache, retrying", e);
                }
            }
        }
    }

    @SerializeWith(value=ToEmptyBytesKeyValueFilterConverterExternalizer.class)
    static class ToEmptyBytesKeyValueFilterConverter
    extends AbstractKeyValueFilterConverter {
        public static ToEmptyBytesKeyValueFilterConverter INSTANCE = new ToEmptyBytesKeyValueFilterConverter();
        static final byte[] bytes = new byte[0];

        private ToEmptyBytesKeyValueFilterConverter() {
        }

        public Object filterAndConvert(Object key, Object value, Metadata metadata) {
            return bytes;
        }

        public static final class ToEmptyBytesKeyValueFilterConverterExternalizer
        implements Externalizer<ToEmptyBytesKeyValueFilterConverter> {
            public void writeObject(ObjectOutput output, ToEmptyBytesKeyValueFilterConverter object) throws IOException {
            }

            public ToEmptyBytesKeyValueFilterConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return INSTANCE;
            }
        }
    }

    class ToEmptyBytesFactory
    implements ParamKeyValueFilterConverterFactory {
        ToEmptyBytesFactory() {
        }

        public KeyValueFilterConverter getFilterConverter(Object[] params) {
            return ToEmptyBytesKeyValueFilterConverter.INSTANCE;
        }

        public boolean binaryParam() {
            return true;
        }
    }
}

