/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.jgroups.impl.MessageSerializationHelper;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorService;
import org.hibernate.search.backend.jgroups.logging.impl.Log;
import org.hibernate.search.backend.spi.OperationDispatcher;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;

public class JGroupsMasterMessageListener
implements Receiver {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private final SearchIntegrator integrator;
    private final NodeSelectorService selector;
    private final LuceneWorkSerializer luceneWorkSerializer;
    private volatile OperationDispatcher operationDispatcher;

    public JGroupsMasterMessageListener(BuildContext context, NodeSelectorService masterNodeSelector, LuceneWorkSerializer luceneWorkSerializer) {
        this.integrator = context.getUninitializedSearchIntegrator();
        this.selector = masterNodeSelector;
        this.luceneWorkSerializer = luceneWorkSerializer;
    }

    public void receive(Message message) {
        int offset = message.getOffset();
        int bufferLength = message.getLength();
        byte[] rawBuffer = message.getRawBuffer();
        try {
            byte[] serializedQueue = MessageSerializationHelper.extractSerializedQueue(offset, bufferLength, rawBuffer);
            List queue = this.luceneWorkSerializer.toLuceneWorks(serializedQueue);
            this.applyLuceneWorkLocally(queue, message);
        }
        catch (ClassCastException e) {
            log.illegalObjectRetrievedFromMessage(e);
        }
        catch (SearchException e) {
            log.illegalObjectRetrievedFromMessage((Exception)((Object)e));
        }
    }

    private void applyLuceneWorkLocally(List<LuceneWork> queue, Message message) {
        if (queue != null && !queue.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debugf("There are %d Lucene docs received from slave node %s to be processed if this node is the master", queue.size(), message.getSrc());
            }
            OperationDispatcher operationDispatcher = this.getOperationDispatcher();
            operationDispatcher.dispatch(queue, null);
        } else {
            log.receivedEmptyLuceneWorksInMessage();
        }
    }

    private OperationDispatcher getOperationDispatcher() {
        if (this.operationDispatcher == null) {
            this.operationDispatcher = this.integrator.createRemoteOperationDispatcher(indexManager -> this.selector.getMasterNodeSelector(indexManager.getIndexName()).isIndexOwnerLocal());
        }
        return this.operationDispatcher;
    }

    public void viewAccepted(View view) {
        log.jGroupsReceivedNewClusterView(view);
        this.selector.viewAccepted(view);
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public void getState(OutputStream arg0) throws Exception {
    }

    public void setState(InputStream arg0) throws Exception {
    }

    public void unblock() {
    }
}

