/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.infinispan.AdvancedCache;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.clustered.ClusteredTopDocs;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributedIterator<E>
implements ResultIterator<E> {
    private static final Log log = (Log)LogFactory.getLog(DistributedIterator.class, Log.class);
    protected final AdvancedCache<?, ?> cache;
    private int currentIndex = -1;
    private final int fetchSize;
    private final int resultSize;
    private final int maxResults;
    private final int firstResult;
    private final ClusteredTopDocs[] partialResults;
    private final int[] partialPositionNext;
    private final TopDocs mergedResults;

    public DistributedIterator(Sort sort, int fetchSize, int resultSize, int maxResults, int firstResult, HashMap<UUID, ClusteredTopDocs> topDocsResponses, AdvancedCache<?, ?> cache) {
        this.fetchSize = fetchSize;
        this.resultSize = resultSize;
        this.maxResults = maxResults;
        this.firstResult = firstResult;
        this.cache = cache;
        int parallels = topDocsResponses.size();
        this.partialResults = new ClusteredTopDocs[parallels];
        TopFieldDocs[] partialTopDocs = sort != null ? new TopFieldDocs[parallels] : new TopDocs[parallels];
        this.partialPositionNext = new int[parallels];
        int i = 0;
        for (Map.Entry<UUID, ClusteredTopDocs> entry : topDocsResponses.entrySet()) {
            this.partialResults[i] = entry.getValue();
            partialTopDocs[i] = this.partialResults[i].getNodeTopDocs().topDocs;
            ++i;
        }
        try {
            this.mergedResults = sort != null ? TopDocs.merge((Sort)sort, (int)firstResult, (int)maxResults, (TopFieldDocs[])partialTopDocs) : TopDocs.merge((int)firstResult, (int)maxResults, (TopDocs[])partialTopDocs);
        }
        catch (IOException e) {
            throw log.unexpectedIOException(e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        ++this.currentIndex;
        ScoreDoc scoreDoc = this.mergedResults.scoreDocs[this.currentIndex];
        int index = scoreDoc.shardIndex;
        if (this.partialPositionNext[index] == 0) {
            this.partialPositionNext[index] = this.findSpecificPosition(scoreDoc.doc, this.partialResults[index].getNodeTopDocs().topDocs);
        }
        int specificPosition = this.partialPositionNext[index];
        int n = index;
        this.partialPositionNext[n] = this.partialPositionNext[n] + 1;
        return this.fetchValue(specificPosition, this.partialResults[index]);
    }

    private int findSpecificPosition(int docId, TopDocs topDocs) {
        for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
            if (topDocs.scoreDocs[i].doc != docId) continue;
            return i;
        }
        return 0;
    }

    protected E fetchValue(int scoreIndex, ClusteredTopDocs topDoc) {
        NodeTopDocs eagerTopDocs = topDoc.getNodeTopDocs();
        return (E)this.cache.get(eagerTopDocs.keys[scoreIndex]);
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("This Iterator is read only");
    }

    @Override
    public final boolean hasNext() {
        int nextIndex = this.currentIndex + 1;
        return this.firstResult + nextIndex < this.resultSize && nextIndex < this.maxResults;
    }
}

