/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.CommandInitializer;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.CustomQueryCommand;
import org.infinispan.query.impl.SearchManagerImpl;
import org.infinispan.query.logging.Log;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractUpdateCommand
extends BaseRpcCommand
implements ReplicableCommand,
CustomQueryCommand {
    protected static final Log log = (Log)LogFactory.getLog(AbstractUpdateCommand.class, Log.class);
    protected SearchIntegrator searchFactory;
    protected String indexName;
    protected byte[] serializedModel;
    protected QueryInterceptor queryInterceptor;

    protected AbstractUpdateCommand(ByteString cacheName) {
        super(cacheName);
    }

    public abstract CompletableFuture<Object> invokeAsync() throws Throwable;

    public abstract byte getCommandId();

    public void writeTo(ObjectOutput output) throws IOException {
        if (this.indexName == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            output.writeUTF(this.indexName);
        }
        MarshallUtil.marshallByteArray((byte[])this.serializedModel, (ObjectOutput)output);
    }

    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        boolean hasIndexName = input.readBoolean();
        if (hasIndexName) {
            this.indexName = input.readUTF();
        }
        this.serializedModel = MarshallUtil.unmarshallByteArray((ObjectInput)input);
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void fetchExecutionContext(CommandInitializer ci) {
        String name = this.cacheName.toString();
        if (!ci.getCacheManager().cacheExists(name)) {
            throw new CacheException("Cache named '" + name + "' does not exist on this CacheManager, or was not started");
        }
        Cache cache = ci.getCacheManager().getCache(name);
        SearchManagerImpl searchManager = new SearchManagerImpl(cache.getAdvancedCache());
        this.searchFactory = searchManager.unwrap(SearchIntegrator.class);
        this.queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
    }

    public boolean canBlock() {
        return true;
    }

    public String getIndexName() {
        return this.indexName;
    }

    protected void setSerializedWorkList(byte[] serializedModel) {
        this.serializedModel = serializedModel;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }
}

