/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.table.management;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.jdbc.table.management.DbMetaData;
import org.infinispan.persistence.jdbc.table.management.TableManager;
import org.infinispan.persistence.jdbc.table.management.TableName;
import org.infinispan.persistence.spi.PersistenceException;

public abstract class AbstractTableManager
implements TableManager {
    private final Log log;
    protected final ConnectionFactory connectionFactory;
    protected final TableManipulationConfiguration config;
    protected final String timestampIndexExt = "timestamp_index";
    protected String identifierQuoteString = "\"";
    protected String cacheName;
    protected DbMetaData metaData;
    protected TableName tableName;
    protected String insertRowSql;
    protected String updateRowSql;
    protected String upsertRowSql;
    protected String selectRowSql;
    protected String selectMultipleRowSql;
    protected String selectIdRowSql;
    protected String deleteRowSql;
    protected String loadAllRowsSql;
    protected String countRowsSql;
    protected String loadAllNonExpiredRowsSql;
    protected String deleteAllRows;
    protected String selectExpiredRowsSql;
    protected String deleteExpiredRowsSql;

    AbstractTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData, Log log) {
        this.connectionFactory = connectionFactory;
        this.config = config;
        this.metaData = metaData;
        this.log = log;
    }

    @Override
    public void start() throws PersistenceException {
        if (this.config.createOnStart()) {
            Connection conn = null;
            try {
                conn = this.connectionFactory.getConnection();
                if (!this.tableExists(conn)) {
                    this.createTable(conn);
                }
                this.createTimestampIndex(conn);
            }
            finally {
                this.connectionFactory.releaseConnection(conn);
            }
        }
    }

    @Override
    public void stop() throws PersistenceException {
        if (this.config.dropOnExit()) {
            Connection conn = null;
            try {
                conn = this.connectionFactory.getConnection();
                this.dropTable(conn);
            }
            finally {
                this.connectionFactory.releaseConnection(conn);
            }
        }
    }

    @Override
    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
        this.tableName = null;
    }

    @Override
    public boolean tableExists(Connection connection) throws PersistenceException {
        return this.tableExists(connection, this.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Connection connection, TableName tableName) throws PersistenceException {
        Objects.requireNonNull(tableName, "table name is mandatory");
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String schemaPattern = tableName.getSchema();
            rs = metaData.getTables(null, schemaPattern, tableName.getName(), new String[]{"TABLE"});
            boolean bl = rs.next();
            JdbcUtil.safeClose(rs);
            return bl;
        }
        catch (SQLException e) {
            if (this.log.isTraceEnabled()) {
                this.log.tracef(e, "SQLException occurs while checking the table %s", tableName);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            JdbcUtil.safeClose(rs);
        }
    }

    @Override
    public void createTable(Connection conn) throws PersistenceException {
        if (this.cacheName == null || this.cacheName.trim().length() == 0) {
            throw new PersistenceException("cacheName needed in order to create table");
        }
        String ddl = String.format("CREATE TABLE %1$s (%2$s %3$s NOT NULL, %4$s %5$s NOT NULL, %6$s %7$s NOT NULL, PRIMARY KEY (%2$s))", this.getTableName(), this.config.idColumnName(), this.config.idColumnType(), this.config.dataColumnName(), this.config.dataColumnType(), this.config.timestampColumnName(), this.config.timestampColumnType());
        if (this.log.isTraceEnabled()) {
            this.log.tracef("Creating table with following DDL: '%s'.", ddl);
        }
        this.executeUpdateSql(conn, ddl);
    }

    protected void createTimestampIndex(Connection conn) throws PersistenceException {
        if (this.metaData.isIndexingDisabled()) {
            return;
        }
        boolean indexExists = this.timestampIndexExists(conn);
        if (!indexExists) {
            String ddl = String.format("CREATE INDEX %s ON %s (%s)", this.getIndexName(true), this.getTableName(), this.config.timestampColumnName());
            if (this.log.isTraceEnabled()) {
                this.log.tracef("Adding timestamp index with following DDL: '%s'.", ddl);
            }
            this.executeUpdateSql(conn, ddl);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean timestampIndexExists(Connection conn) throws PersistenceException {
        ResultSet rs;
        block7: {
            boolean bl;
            block6: {
                rs = null;
                try {
                    TableName table = this.getTableName();
                    DatabaseMetaData meta = conn.getMetaData();
                    rs = meta.getIndexInfo(null, table.getSchema(), table.getName(), false, false);
                    while (rs.next()) {
                        String indexName = rs.getString("INDEX_NAME");
                        if (indexName == null || !indexName.equalsIgnoreCase(this.getIndexName(false))) continue;
                        bl = true;
                        break block6;
                    }
                    break block7;
                }
                catch (SQLException e) {
                    try {
                        throw new PersistenceException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtil.safeClose(rs);
                        throw throwable;
                    }
                }
            }
            JdbcUtil.safeClose(rs);
            return bl;
        }
        JdbcUtil.safeClose(rs);
        return false;
    }

    public void executeUpdateSql(Connection conn, String sql) throws PersistenceException {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.log.errorCreatingTable(sql, e);
            throw new PersistenceException((Throwable)e);
        }
        finally {
            JdbcUtil.safeClose(statement);
        }
    }

    @Override
    public void dropTable(Connection conn) throws PersistenceException {
        this.dropTimestampIndex(conn);
        String dropTableDdl = "DROP TABLE " + this.getTableName();
        String clearTable = "DELETE FROM " + this.getTableName();
        this.executeUpdateSql(conn, clearTable);
        if (this.log.isTraceEnabled()) {
            this.log.tracef("Dropping table with following DDL '%s'", dropTableDdl);
        }
        this.executeUpdateSql(conn, dropTableDdl);
    }

    protected void dropTimestampIndex(Connection conn) throws PersistenceException {
        if (!this.timestampIndexExists(conn)) {
            return;
        }
        String dropIndexDdl = String.format("DROP INDEX %s ON %s", this.getIndexName(true), this.getTableName());
        this.executeUpdateSql(conn, dropIndexDdl);
    }

    @Override
    public int getFetchSize() {
        return this.config.fetchSize();
    }

    @Override
    public int getBatchSize() {
        return this.config.batchSize();
    }

    @Override
    public boolean isUpsertSupported() {
        return !this.metaData.isUpsertDisabled();
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    @Override
    public TableName getTableName() {
        if (this.tableName == null) {
            this.tableName = new TableName(this.identifierQuoteString, this.config.tableNamePrefix(), this.cacheName);
        }
        return this.tableName;
    }

    public String getIndexName(boolean withIdentifier) {
        TableName table = this.getTableName();
        String tableName = table.toString().replace(this.identifierQuoteString, "");
        String indexName = tableName + "_" + "timestamp_index";
        if (withIdentifier) {
            return this.identifierQuoteString + indexName + this.identifierQuoteString;
        }
        return indexName;
    }

    @Override
    public String getInsertRowSql() {
        if (this.insertRowSql == null) {
            this.insertRowSql = String.format("INSERT INTO %s (%s,%s,%s) VALUES (?,?,?)", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return this.insertRowSql;
    }

    @Override
    public String getUpdateRowSql() {
        if (this.updateRowSql == null) {
            this.updateRowSql = String.format("UPDATE %s SET %s = ? , %s = ? WHERE %s = ?", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return this.updateRowSql;
    }

    @Override
    public String getSelectRowSql() {
        if (this.selectRowSql == null) {
            this.selectRowSql = String.format("SELECT %s, %s FROM %s WHERE %s = ?", this.config.idColumnName(), this.config.dataColumnName(), this.getTableName(), this.config.idColumnName());
        }
        return this.selectRowSql;
    }

    protected String getSelectMultipleRowSql(int numberOfParams, String selectCriteria) {
        if (numberOfParams < 1) {
            return null;
        }
        if (numberOfParams == 1) {
            return this.getSelectRowSql();
        }
        StringBuilder sb = new StringBuilder(this.getSelectRowSql());
        for (int i = 0; i < numberOfParams - 1; ++i) {
            sb.append(" OR ");
            sb.append(selectCriteria);
        }
        return sb.toString();
    }

    @Override
    public String getSelectMultipleRowSql(int numberOfParams) {
        return this.getSelectMultipleRowSql(numberOfParams, this.config.idColumnName() + " = ?");
    }

    @Override
    public String getSelectIdRowSql() {
        if (this.selectIdRowSql == null) {
            this.selectIdRowSql = String.format("SELECT %s FROM %s WHERE %s = ?", this.config.idColumnName(), this.getTableName(), this.config.idColumnName());
        }
        return this.selectIdRowSql;
    }

    @Override
    public String getCountRowsSql() {
        if (this.countRowsSql == null) {
            this.countRowsSql = "SELECT COUNT(*) FROM " + this.getTableName();
        }
        return this.countRowsSql;
    }

    @Override
    public String getDeleteRowSql() {
        if (this.deleteRowSql == null) {
            this.deleteRowSql = String.format("DELETE FROM %s WHERE %s = ?", this.getTableName(), this.config.idColumnName());
        }
        return this.deleteRowSql;
    }

    @Override
    public String getLoadNonExpiredAllRowsSql() {
        if (this.loadAllNonExpiredRowsSql == null) {
            this.loadAllNonExpiredRowsSql = String.format("SELECT %1$s, %2$s, %3$s FROM %4$s WHERE %3$s > ? OR %3$s < 0", this.config.dataColumnName(), this.config.idColumnName(), this.config.timestampColumnName(), this.getTableName());
        }
        return this.loadAllNonExpiredRowsSql;
    }

    @Override
    public String getLoadAllRowsSql() {
        if (this.loadAllRowsSql == null) {
            this.loadAllRowsSql = String.format("SELECT %s, %s FROM %s", this.config.dataColumnName(), this.config.idColumnName(), this.getTableName());
        }
        return this.loadAllRowsSql;
    }

    @Override
    public String getDeleteAllRowsSql() {
        if (this.deleteAllRows == null) {
            this.deleteAllRows = "DELETE FROM " + this.getTableName();
        }
        return this.deleteAllRows;
    }

    @Override
    public String getSelectExpiredBucketsSql() {
        if (this.selectExpiredRowsSql == null) {
            this.selectExpiredRowsSql = String.format("%s WHERE %s < ?", this.getLoadAllRowsSql(), this.config.timestampColumnName());
        }
        return this.selectExpiredRowsSql;
    }

    @Override
    public String getSelectOnlyExpiredRowsSql() {
        if (this.deleteExpiredRowsSql == null) {
            this.deleteExpiredRowsSql = String.format("%1$s WHERE %2$s < ? AND %2$s > 0", this.getLoadAllRowsSql(), this.config.timestampColumnName());
        }
        return this.deleteExpiredRowsSql;
    }

    @Override
    public String getUpsertRowSql() {
        if (this.upsertRowSql == null) {
            this.upsertRowSql = String.format("MERGE INTO %1$s USING (VALUES (?, ?, ?)) AS tmp (%2$s, %3$s, %4$s) ON (%2$s = tmp.%2$s) WHEN MATCHED THEN UPDATE SET %3$s = tmp.%3$s, %4$s = tmp.%4$s WHEN NOT MATCHED THEN INSERT (%2$s, %3$s, %4$s) VALUES (tmp.%2$s, tmp.%3$s, tmp.%4$s)", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return this.upsertRowSql;
    }

    @Override
    public boolean isStringEncodingRequired() {
        return false;
    }

    @Override
    public String encodeString(String string) {
        return string;
    }

    @Override
    public void prepareUpdateStatement(PreparedStatement ps, String key, long timestamp, ByteBuffer byteBuffer) throws SQLException {
        ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byteBuffer.getBuf(), byteBuffer.getOffset(), byteBuffer.getLength()), byteBuffer.getLength());
        ps.setLong(2, timestamp);
        ps.setString(3, key);
    }
}

