/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.eventlogger;

import org.infinispan.server.eventlogger.ServerEventImpl;
import org.infinispan.server.eventlogger.ServerEventLogger;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;
import org.infinispan.util.logging.events.EventLogger;
import org.infinispan.util.logging.events.Messages;
import org.infinispan.util.logging.events.impl.DecoratedEventLogger;

class DecoratedServerEventLogger
extends DecoratedEventLogger {
    private ServerEventLogger delegate;

    DecoratedServerEventLogger(ServerEventLogger delegate) {
        super((EventLogger)delegate);
        this.delegate = delegate;
    }

    public void log(EventLogLevel level, EventLogCategory category, String message) {
        StringBuilder sb = new StringBuilder();
        this.context.ifPresent(c -> sb.append(Messages.MESSAGES.eventLogContext(c)));
        this.scope.ifPresent(s -> sb.append(Messages.MESSAGES.eventLogContext(s)));
        this.who.ifPresent(w -> sb.append(Messages.MESSAGES.eventLogWho(w)));
        sb.append(message);
        this.delegate.textLog(level, category, sb.toString());
        this.delegate.eventLog(new ServerEventImpl(level, category, this.delegate.getTimeService().instant(), message, this.detail, this.context, this.who, this.scope));
    }
}

