/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.session;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheConfigurationAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static Configuration getCacheConfiguration(AdvancedCache<?, ?> cache) {
        GetCacheConfigurationAction action = new GetCacheConfigurationAction(cache);
        return (Configuration)SecurityActions.doPrivileged(action);
    }

    static void endBatch(AdvancedCache<?, ?> cache) {
        SecurityActions.doPrivileged(() -> {
            cache.endBatch(false);
            return null;
        });
    }

    public static ClassLoader setThreadContextClassLoader(Class cl) {
        if (System.getSecurityManager() == null) {
            return SetThreadContextClassLoaderAction.NON_PRIVILEGED.setThreadContextClassLoader(cl);
        }
        return SetThreadContextClassLoaderAction.PRIVILEGED.setThreadContextClassLoader(cl);
    }

    public static ClassLoader setThreadContextClassLoader(ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            return SetThreadContextClassLoaderAction.NON_PRIVILEGED.setThreadContextClassLoader(cl);
        }
        return SetThreadContextClassLoaderAction.PRIVILEGED.setThreadContextClassLoader(cl);
    }

    static interface SetThreadContextClassLoaderAction {
        public static final SetThreadContextClassLoaderAction NON_PRIVILEGED = new SetThreadContextClassLoaderAction(){

            @Override
            public ClassLoader setThreadContextClassLoader(Class cl) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl.getClassLoader());
                return old;
            }

            @Override
            public ClassLoader setThreadContextClassLoader(ClassLoader cl) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                return old;
            }
        };
        public static final SetThreadContextClassLoaderAction PRIVILEGED = new SetThreadContextClassLoaderAction(){

            @Override
            public ClassLoader setThreadContextClassLoader(final Class cl) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(cl.getClassLoader());
                        return old;
                    }
                });
            }

            @Override
            public ClassLoader setThreadContextClassLoader(final ClassLoader cl) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(cl);
                        return old;
                    }
                });
            }
        };

        public ClassLoader setThreadContextClassLoader(Class var1);

        public ClassLoader setThreadContextClassLoader(ClassLoader var1);
    }
}

