/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.logging.impl.ElasticsearchJsonObjectFormatter;
import org.hibernate.search.elasticsearch.logging.impl.ElasticsearchRequestFormatter;
import org.hibernate.search.elasticsearch.logging.impl.ElasticsearchResponseFormatter;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidationException;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.BaseHibernateSearchLogger;
import org.hibernate.search.util.logging.impl.ClassFormatter;
import org.hibernate.search.util.logging.impl.IndexedTypeIdentifierFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BaseHibernateSearchLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String cannotRunEsQueryTargetingEntityIndexedWithNonEsIndexManager = "HSEARCH400001: Cannot execute query '%2$s', as targeted entity type '%1$s' is not mapped to an Elasticsearch index";
    private static final String cannotTransformLuceneQueryIntoEsQuery = "HSEARCH400002: Lucene query '%1$s' cannot be transformed into equivalent Elasticsearch query";
    private static final String cannotSendRangeDefinitionOrderToElasticsearchBackend = "HSEARCH400004: The sort order RANGE_DEFINITION_ORDER cant not be sent used with Elasticsearch";
    private static final String cannotUseThisSortTypeWithNullSortFieldName = "HSEARCH400005: The SortType '%1$s' cannot be used with a null sort field name";
    private static final String cannotQueryOnEmptyPhraseQuery = "HSEARCH400006: Empty phrase queries are not supported";
    private static final String elasticsearchRequestFailed = "HSEARCH400007: Elasticsearch request failed.\nRequest: %1$s\nResponse: %2$s";
    private static final String elasticsearchBulkedRequestFailed = "HSEARCH400008: Elasticsearch bulked request failed.\nRequest metadata: %1$sResponse: %2$s";
    private static final String analyzerIsNotElasticsearch = "HSEARCH400009: Field '%2$s' in '%1$s' requires an Elasticsearch analyzer reference (got '%3$s' instead). The analyzer will be ignored.";
    private static final String elasticsearchRequestTimeout = "HSEARCH400010: Elasticsearch connection time-out; check the cluster status, it should be 'green'";
    private static final String unsupportedProjectionOfNonJsonPrimitiveFields = "HSEARCH400011: Projection of non-JSON-primitive field values is not supported: '%1$s'";
    private static final String interruptedWhileWaitingForRequestCompletion = "HSEARCH400012: Interrupted while waiting for requests to be processed.";
    private static final String filterFactoryMethodReturnsUnsupportedType = "HSEARCH400013: @Factory method does not return a Filter class or an ElasticsearchFilter class: %1$s.%2$s";
    private static final String filterFactoryMethodInaccessible = "HSEARCH400014: Unable to access @Factory method: %1$s.%2$s";
    private static final String filterHasUnsupportedType = "HSEARCH400015: Filter implementation does not implement the Filter interface or the ElasticsearchFilter interface: %1$s";
    private static final String documentExtractorTopDocsUnsupported = "HSEARCH400016: TopDocs not available when using Elasticsearch";
    private static final String hsQueryLuceneQueryUnsupported = "HSEARCH400017: Cannot use Lucene query with Elasticsearch";
    private static final String unexpectedNumericEncodingType = "HSEARCH400018: Unexpected numeric encoding type for field '%2$s' on entity type '%1$s'. If you used a custom field bridge, make sure it implements MetadataProvidingFieldBridge and provides metadata for this field.";
    private static final String elasticsearchMappingCreationFailed = "HSEARCH400020: Could not create mapping for entity type %1$s";
    private static final String unexpectedFieldType = "HSEARCH400021: Unexpected field type for field '%2$s': %1$s";
    private static final String unexpectedIndexStatusString = "HSEARCH400022: Unexpected index status string: '%1$s'. Specify one of 'green', 'yellow' or 'red'.";
    private static final String negativeTimeoutValue = "HSEARCH400023: Positive timeout value expected, but it was: %1$s";
    private static final String unexpectedIndexStatus = "HSEARCH400024: Timed out while waiting for for index '%1$s' to reach status '%2$s'; status was still '%3$s' after %4$s.";
    private static final String indexManagerReaderProviderUnsupported = "HSEARCH400025: With an Elasticsearch backend it is not possible to get a ReaderProvider or an IndexReader";
    private static final String facetingRequestHasUnsupportedType = "HSEARCH400026: Faceting request of type %1$s not supported";
    private static final String invalidNullMarkerForBoolean = "HSEARCH400027: The 'indexNullAs' property for Boolean fields must represent a Boolean ('true' or 'false').";
    private static final String invalidNullMarkerForCalendarAndDate = "HSEARCH400028: The 'indexNullAs' property for Calendar and Date fields must represent a date/time in ISO-8601 format (yyyy-MM-dd'T'HH:mm:ssZ).";
    private static final String unsupportedOffsettedScrolling = "HSEARCH400029: Cannot use an offset ('from', 'firstResult') when scrolling through Elasticsearch results";
    private static final String unsupportedBackwardTraversal = "HSEARCH400030: Cannot scroll backward through Elasticsearch results. Previously accessed index was %1$s, requested index is %2$s.";
    private static final String backtrackingWindowOverflow = "HSEARCH400031: Cannot scroll backward more than %1$s positions through Elasticsearch results. First index still in memory is %2$s, requested index is %3$s.";
    private static final String unsupportedDynamicBoost = "HSEARCH400032: @DynamicBoost is not supported with Elasticsearch. Ignoring boost strategy '%1$s' for entity '%2$s' (field path '%3$s').";
    private static final String schemaValidationFailed = "HSEARCH400033: An Elasticsearch schema validation failed: %1$s";
    private static final String elasticsearchMappingRetrievalForValidationFailed = "HSEARCH400034: Could not retrieve the mappings from Elasticsearch for validation";
    private static final String schemaUpdateFailed = "HSEARCH400035: Could not update mappings in index '%1$s'";
    private static final String fieldIsBothCompositeAndConcrete = "HSEARCH400036: Mapping conflict detected for field '%2$s' on entity '%1$s'. The current mapping would require the field to be mapped to both a composite field ('object' datatype) and a \"concrete\" field ('integer', 'date', etc.) holding a value, which Elasticsearch does not allow. If you're seeing this issue, you probably added both an @IndexedEmbedded annotation and a @Field (or similar) annotation on the same property: if that's the case, please set either @IndexedEmbedded.prefix or @Field.name to a custom value different from the default to resolve the conflict.";
    private static final String invalidNullMarkerForPeriod = "HSEARCH400037: The 'indexNullAs' property for Period fields must represent a date interval in ISO-8601 format (for instance P3Y2M1D for 3 years, 2 months and 1 day).";
    private static final String invalidNullMarkerForDuration = "HSEARCH400038: The 'indexNullAs' property for Duration fields must represent a duration in ISO-8601 format (for instance P1DT2H3M4.007S for 1 day, 2 hours, 3 minutes, 4 seconds and 7 miliseconds).";
    private static final String invalidNullMarkerForInstant = "HSEARCH400039: The 'indexNullAs' property for Instant fields must represent a date/time in ISO-8601 format (yyyy-MM-dd'T'HH:mm:ssZ[ZZZ]).";
    private static final String invalidNullMarkerForLocalDateTime = "HSEARCH400040: The 'indexNullAs' property for LocalDateTime fields must represent a local date/time in ISO-8601 format (yyyy-MM-dd'T'HH:mm:ss).";
    private static final String invalidNullMarkerForLocalDate = "HSEARCH400041: The 'indexNullAs' property for LocalDate fields must represent a local date in ISO-8601 format (yyyy-MM-dd).";
    private static final String invalidNullMarkerForLocalTime = "HSEARCH400042: The 'indexNullAs' property for LocalTime fields must represent a local time in ISO-8601 format (HH:mm:ss).";
    private static final String invalidNullMarkerForOffsetDateTime = "HSEARCH400043: The 'indexNullAs' property for OffsetDateTime fields must represent an offset date/time in ISO-8601 format (yyyy-MM-dd'T'HH:mm:ssZ).";
    private static final String invalidNullMarkerForOffsetTime = "HSEARCH400044: The 'indexNullAs' property for OffsetTime fields must represent an offset time in ISO-8601 format (HH:mm:ssZ).";
    private static final String invalidNullMarkerForZonedDateTime = "HSEARCH400045: The 'indexNullAs' property for ZonedDateTime fields must represent a zoned date/time in ISO-8601 format (yyyy-MM-dd'T'HH:mm:ss[ZZZ]).";
    private static final String invalidNullMarkerForZonedTime = "HSEARCH400046: The 'indexNullAs' property for ZonedTime fields must represent a zoned time in ISO-8601 format (HH:mm:ss[ZZZ]).";
    private static final String invalidNullMarkerForYear = "HSEARCH400047: The 'indexNullAs' property for Year fields must represent a year in ISO-8601 format (for instance 2014).";
    private static final String invalidNullMarkerForYearMonth = "HSEARCH400048: The 'indexNullAs' property for YearMonth fields must represent a year/month in ISO-8601 format (yyyy-MM-dd).";
    private static final String invalidNullMarkerForMonthDay = "HSEARCH400049: The 'indexNullAs' property for MonthDay fields must represent a month/day in ISO-8601 format (--MM-dd).";
    private static final String indexMissing = "HSEARCH400050: The index '%1$s' does not exist in the Elasticsearch cluster.";
    private static final String unsupportedSearchAPIPayloadAttributes = "HSEARCH400051: The given payload contains unsupported attributes: %1$s. Only 'query' is supported.";
    private static final String invalidSearchAPIPayload = "HSEARCH400052: The given payload is not a valid JSON object.";
    private static final String executingElasticsearchQuery = "HSEARCH400053: Executing Elasticsearch query on '%s' with parameters '%s': <%s>";
    private static final String indexedEmbeddedPrefixBypass = "HSEARCH400054: Invalid field path detected for field '%2$s' on entity '%1$s': the field name is not prefixed with '%3$s' as it should. This probably means that the field was created with a custom field bridge which added fields with an arbitrary name, not taking the name passed as a parameter into account. This is not supported with the Elasticsearch indexing service: please only add suffixes to the name passed as a parameter to the various bridge methods and never ignore this name.";
    private static final String tokenizerNamingConflict = "HSEARCH400055: The same tokenizer name '%1$s' is assigned to multiple definitions. The tokenizer names must be unique. If you used the @TokenizerDef annotation and this name was automatically generated, you may override this name by using @TokenizerDef.name.";
    private static final String charFilterNamingConflict = "HSEARCH400056: The same char filter name '%1$s' is assigned to multiple definitions. The char filter names must be unique. If you used the @CharFilterDef annotation and this name was automatically generated, you may override this name by using @CharFilterDef.name.";
    private static final String tokenFilterNamingConflict = "HSEARCH400057: The same token filter name '%1$s' is assigned to multiple definitions. The token filter names must be unique. If you used the @TokenFilterDef annotation and this name was automatically generated, you may override this name by using @TokenFilterDef.name.";
    private static final String unsupportedCharFilterFactory = "HSEARCH400058: The char filter factory '%1$s' is not supported with Elasticsearch. Please only use builtin Lucene factories that have a builtin equivalent in Elasticsearch.";
    private static final String unsupportedTokenizerFactory = "HSEARCH400059: The tokenizer factory '%1$s' is not supported with Elasticsearch. Please only use builtin Lucene factories that have a builtin equivalent in Elasticsearch.";
    private static final String unsupportedTokenFilterFactory = "HSEARCH400060: The token filter factory '%1$s' is not supported with Elasticsearch. Please only use builtin Lucene factories that have a builtin equivalent in Elasticsearch.";
    private static final String unsupportedAnalysisFactoryParameter = "HSEARCH400061: The parameter '%2$s' is not supported for the factory '%1$s' with Elasticsearch.";
    private static final String unsupportedAnalysisFactoryTokenizerClassNameParameter = "HSEARCH400062: The parameter '%2$s' for the factory '%1$s' refers to the class '%3$s', which cannot be converted to a builtin Elasticsearch tokenizer type.";
    private static final String unsupportedAnalysisDefinitionParameterValue = "HSEARCH400063: The parameter '%2$s' for the factory '%1$s' has an unsupported value: '%3$s' is unsupported with Elasticsearch.";
    private static final String unsupportedAnalyzerImplementation = "HSEARCH400064: The analyzer implementation '%1$s' is not supported with Elasticsearch. Please only use builtin Lucene analyzers that have a builtin equivalent in Elasticsearch.";
    private static final String invalidAnalysisDefinitionJsonStringParameter = "HSEARCH400065: The parameter '%2$s' for the factory '%1$s' could not be parsed as a JSON string: %3$s";
    private static final String invalidAnalysisDefinitionJsonParameter = "HSEARCH400066: The parameter '%2$s' for the factory '%1$s' could not be parsed as JSON: %3$s";
    private static final String elasticsearchSettingsUpdateFailed = "HSEARCH400067: Could not update settings for index '%1$s'";
    private static final String elasticsearchIndexSettingsRetrievalForValidationFailed = "HSEARCH400068: Could not retrieve the index settings from Elasticsearch for validation";
    private static final String closedIndex = "HSEARCH400069: Closed Elasticsearch index '%1$s' automatically.";
    private static final String openedIndex = "HSEARCH400070: Opened Elasticsearch index '%1$s' automatically.";
    private static final String failedToOpenIndex = "HSEARCH400071: Failed to open Elasticsearch index '%1$s' ; see the stack trace below.";
    private static final String elasticsearch2RequestDeleteByQueryNotFound = "HSEARCH400072: DeleteByQuery request to Elasticsearch failed with 404 result code.\nPlease check that 1. you installed the delete-by-query plugin on your Elasticsearch nodes and 2. the targeted index exists";
    private static final String usingPasswordOverHttp = "HSEARCH400073: Hibernate Search will connect to Elasticsearch server '%1$s' with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.";
    private static final String analyzerNamingConflict = "HSEARCH400074: The same analyzer name '%1$s' is assigned to multiple definitions. The analyzer names must be unique.";
    private static final String invalidElasticsearchAnalyzerDefinitionProvider = "HSEARCH400075: Property 'hibernate.search.elasticsearch.analysis_definition_provider' set to value '%1$s' is invalid. The value must be the fully-qualified name of a class with a public, no-arg constructor in your classpath. Also, the class must either implement ElasticsearchAnalyzerDefinitionProvider or expose a public, @Factory-annotated method returning a ElasticsearchAnalyzerDefinitionProvider.";
    private static final String invalidElasticsearchAnalyzerDefinition = "HSEARCH400076: Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.";
    private static final String invalidElasticsearchTokenizerDefinition = "HSEARCH400077: Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.";
    private static final String invalidElasticsearchCharFilterDefinition = "HSEARCH400078: Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.";
    private static final String invalidElasticsearchTokenFilterDefinition = "HSEARCH400079: Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.";
    private static final String failedToDetectElasticsearchVersion = "HSEARCH400080: Failed to detect the Elasticsearch version running on the cluster.";
    private static final String unsupportedElasticsearchVersion = "HSEARCH400081: An unsupported Elasticsearch version runs on the Elasticsearch cluster: '%s'. Please refer to the documentation to know which versions are supported.";
    private static final String executedRequest6 = "HSEARCH400082: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s in %dms. Response had status %d '%s'.";
    private static final String unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzersForSimpleQueryStringQueries = "HSEARCH400083: For simple query string queries, Elasticsearch does not support overriding fields with more than one different analyzers: %1$s.";
    private static final String invalidAnalysisFactoryParameter = "HSEARCH400084: The parameter '%2$s' must have value '%3$s' for the factory '%1$s' with Elasticsearch. Current value '%4$s' is invalid.";
    private static final String unexpectedElasticsearchVersion = "HSEARCH400085: Hibernate Search may not work correctly, because an unknown Elasticsearch version runs on the Elasticsearch cluster: '%s'.";
    private static final String normalizerNamingConflict = "HSEARCH400086: The same normalizer name '%1$s' is assigned to multiple definitions. The analyzer names must be unique.";
    private static final String analyzerNormalizerNamingConflict = "HSEARCH400087: The same name '%1$s' is assigned to a normalizer definition and an analyzer definition. This is not possible on Elasticsearch 5.1 and below, since normalizers are translated to analyzers under the hood.";
    private static final String cannotUseNormalizerImpl = "HSEARCH400088: You cannot use @Normalizer(impl = \"%1$s\") on entities mapped to Elasticsearch: there are no built-in normalizers in Elasticsearch. Use @Normalizer(definition = \"...\") instead.";
    private static final String failedToParseElasticsearchResponse = "HSEARCH400089: Failed to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'.";
    private static final String elasticsearchResponseIndicatesFailure = "HSEARCH400090: Elasticsearch response indicates a failure.";
    private static final String threadInterruptedWhileSubmittingChangeset = "HSEARCH400091: The thread was interrupted while a changeset was being submitted to '%1$s'. The changeset has been discarded.";
    private static final String orchestratorShutDownBeforeSubmittingChangeset = "HSEARCH400092: A changeset was submitted after Hibernate Search shutdown was requested to '%1$s'. The changeset has been discarded.";
    private static final String executedRequest8 = "HSEARCH400093: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>";
    private static final String interruptedWhileWaitingForIndexActivity = "HSEARCH000049: '%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    private static final String illegalObjectRetrievedFromMessage = "HSEARCH000069: Illegal object retrieved from message";
    private static final String unableToLoadResource = "HSEARCH000114: Could not load resource: '%1$s'";
    private static final String unknownResolution = "HSEARCH000140: Unknown Resolution: %1$s";
    private static final String unsupportedFacetRangeParameter = "HSEARCH000266: '%s' is not a valid type for a facet range request. Numbers (byte, short, int, long, float, double and their wrappers) as well as dates are supported";
    private static final String projectingFieldWithoutTwoWayFieldBridge = "HSEARCH000324: The fieldBridge for field '%1$s' is an instance of '%2$s', which does not implement TwoWayFieldBridge. Projected fields must have a TwoWayFieldBridge.";
    private static final String unsupportedNullTokenType = "HSEARCH000327: Unsupported indexNullAs token type '%3$s' on field '%2$s' of entity '%1$s'.";
    private static final String invalidLuceneAnalyzerDefinitionProvider = "HSEARCH000329: Property 'hibernate.search.lucene.analysis_definition_provider' set to value '%1$s' is invalid. The value must be the fully-qualified name of a class with a public, no-arg constructor in your classpath. Also, the class must either implement LuceneAnalyzerDefinitionProvider or expose a public, @Factory-annotated method returning a LuceneAnalyzerDefinitionProvider.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String cannotRunEsQueryTargetingEntityIndexedWithNonEsIndexManager$str() {
        return cannotRunEsQueryTargetingEntityIndexedWithNonEsIndexManager;
    }

    @Override
    public final SearchException cannotRunEsQueryTargetingEntityIndexedWithNonEsIndexManager(IndexedTypeIdentifier entityType, String query) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotRunEsQueryTargetingEntityIndexedWithNonEsIndexManager$str(), new IndexedTypeIdentifierFormatter(entityType), query));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotTransformLuceneQueryIntoEsQuery$str() {
        return cannotTransformLuceneQueryIntoEsQuery;
    }

    @Override
    public final SearchException cannotTransformLuceneQueryIntoEsQuery(Query query) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotTransformLuceneQueryIntoEsQuery$str(), query));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotSendRangeDefinitionOrderToElasticsearchBackend$str() {
        return cannotSendRangeDefinitionOrderToElasticsearchBackend;
    }

    @Override
    public final SearchException cannotSendRangeDefinitionOrderToElasticsearchBackend() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotSendRangeDefinitionOrderToElasticsearchBackend$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotUseThisSortTypeWithNullSortFieldName$str() {
        return cannotUseThisSortTypeWithNullSortFieldName;
    }

    @Override
    public final SearchException cannotUseThisSortTypeWithNullSortFieldName(SortField.Type sortType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseThisSortTypeWithNullSortFieldName$str(), sortType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotQueryOnEmptyPhraseQuery$str() {
        return cannotQueryOnEmptyPhraseQuery;
    }

    @Override
    public final SearchException cannotQueryOnEmptyPhraseQuery() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotQueryOnEmptyPhraseQuery$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchRequestFailed$str() {
        return elasticsearchRequestFailed;
    }

    @Override
    public final SearchException elasticsearchRequestFailed(ElasticsearchRequest request, ElasticsearchResponse response, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchRequestFailed$str(), new ElasticsearchRequestFormatter(request), new ElasticsearchResponseFormatter(response)), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchBulkedRequestFailed$str() {
        return elasticsearchBulkedRequestFailed;
    }

    @Override
    public final SearchException elasticsearchBulkedRequestFailed(JsonObject requestMetadata, JsonObject response, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchBulkedRequestFailed$str(), new ElasticsearchJsonObjectFormatter(requestMetadata), new ElasticsearchJsonObjectFormatter(response)), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void analyzerIsNotElasticsearch(IndexedTypeIdentifier entityType, String fieldName, AnalyzerReference analyzerReference) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.analyzerIsNotElasticsearch$str(), (Object)new IndexedTypeIdentifierFormatter(entityType), (Object)fieldName, (Object)analyzerReference);
    }

    protected String analyzerIsNotElasticsearch$str() {
        return analyzerIsNotElasticsearch;
    }

    protected String elasticsearchRequestTimeout$str() {
        return elasticsearchRequestTimeout;
    }

    @Override
    public final SearchException elasticsearchRequestTimeout() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchRequestTimeout$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedProjectionOfNonJsonPrimitiveFields$str() {
        return unsupportedProjectionOfNonJsonPrimitiveFields;
    }

    @Override
    public final SearchException unsupportedProjectionOfNonJsonPrimitiveFields(JsonElement value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedProjectionOfNonJsonPrimitiveFields$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String interruptedWhileWaitingForRequestCompletion$str() {
        return interruptedWhileWaitingForRequestCompletion;
    }

    @Override
    public final SearchException interruptedWhileWaitingForRequestCompletion(Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.interruptedWhileWaitingForRequestCompletion$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String filterFactoryMethodReturnsUnsupportedType$str() {
        return filterFactoryMethodReturnsUnsupportedType;
    }

    @Override
    public final SearchException filterFactoryMethodReturnsUnsupportedType(String implementorName, String factoryMethodName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.filterFactoryMethodReturnsUnsupportedType$str(), implementorName, factoryMethodName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String filterFactoryMethodInaccessible$str() {
        return filterFactoryMethodInaccessible;
    }

    @Override
    public final SearchException filterFactoryMethodInaccessible(String implementorName, String factoryMethodName, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.filterFactoryMethodInaccessible$str(), implementorName, factoryMethodName), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String filterHasUnsupportedType$str() {
        return filterHasUnsupportedType;
    }

    @Override
    public final SearchException filterHasUnsupportedType(String actualClassName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.filterHasUnsupportedType$str(), actualClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String documentExtractorTopDocsUnsupported$str() {
        return documentExtractorTopDocsUnsupported;
    }

    @Override
    public final UnsupportedOperationException documentExtractorTopDocsUnsupported() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.documentExtractorTopDocsUnsupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hsQueryLuceneQueryUnsupported$str() {
        return hsQueryLuceneQueryUnsupported;
    }

    @Override
    public final UnsupportedOperationException hsQueryLuceneQueryUnsupported() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.hsQueryLuceneQueryUnsupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedNumericEncodingType$str() {
        return unexpectedNumericEncodingType;
    }

    @Override
    public final SearchException unexpectedNumericEncodingType(IndexedTypeIdentifier entityType, String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedNumericEncodingType$str(), new IndexedTypeIdentifierFormatter(entityType), fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchMappingCreationFailed$str() {
        return elasticsearchMappingCreationFailed;
    }

    @Override
    public final SearchException elasticsearchMappingCreationFailed(Object entityType, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchMappingCreationFailed$str(), entityType), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedFieldType$str() {
        return unexpectedFieldType;
    }

    @Override
    public final SearchException unexpectedFieldType(String fieldType, String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedFieldType$str(), fieldType, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedIndexStatusString$str() {
        return unexpectedIndexStatusString;
    }

    @Override
    public final SearchException unexpectedIndexStatusString(String status) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedIndexStatusString$str(), status));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String negativeTimeoutValue$str() {
        return negativeTimeoutValue;
    }

    @Override
    public final SearchException negativeTimeoutValue(int timeout) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.negativeTimeoutValue$str(), timeout));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedIndexStatus$str() {
        return unexpectedIndexStatus;
    }

    @Override
    public final SearchException unexpectedIndexStatus(String indexName, String expected, String actual, String timeoutAndUnit) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedIndexStatus$str(), indexName, expected, actual, timeoutAndUnit));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexManagerReaderProviderUnsupported$str() {
        return indexManagerReaderProviderUnsupported;
    }

    @Override
    public final UnsupportedOperationException indexManagerReaderProviderUnsupported() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.indexManagerReaderProviderUnsupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String facetingRequestHasUnsupportedType$str() {
        return facetingRequestHasUnsupportedType;
    }

    @Override
    public final SearchException facetingRequestHasUnsupportedType(String facetingRequestType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.facetingRequestHasUnsupportedType$str(), facetingRequestType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForBoolean$str() {
        return invalidNullMarkerForBoolean;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForBoolean() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForBoolean$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForCalendarAndDate$str() {
        return invalidNullMarkerForCalendarAndDate;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForCalendarAndDate(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForCalendarAndDate$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedOffsettedScrolling$str() {
        return unsupportedOffsettedScrolling;
    }

    @Override
    public final UnsupportedOperationException unsupportedOffsettedScrolling() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedOffsettedScrolling$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedBackwardTraversal$str() {
        return unsupportedBackwardTraversal;
    }

    @Override
    public final UnsupportedOperationException unsupportedBackwardTraversal(int lastRequestedIndex, int index) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedBackwardTraversal$str(), lastRequestedIndex, index));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backtrackingWindowOverflow$str() {
        return backtrackingWindowOverflow;
    }

    @Override
    public final SearchException backtrackingWindowOverflow(int backtrackingLimit, int windowStartIndex, int requestedIndex) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backtrackingWindowOverflow$str(), backtrackingLimit, windowStartIndex, requestedIndex));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unsupportedDynamicBoost(Class<?> boostStrategyType, IndexedTypeIdentifier entityType, String fieldPath) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsupportedDynamicBoost$str(), boostStrategyType, (Object)new IndexedTypeIdentifierFormatter(entityType), (Object)fieldPath);
    }

    protected String unsupportedDynamicBoost$str() {
        return unsupportedDynamicBoost;
    }

    protected String schemaValidationFailed$str() {
        return schemaValidationFailed;
    }

    @Override
    public final ElasticsearchSchemaValidationException schemaValidationFailed(String message) {
        ElasticsearchSchemaValidationException result = new ElasticsearchSchemaValidationException(String.format(this.getLoggingLocale(), this.schemaValidationFailed$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchMappingRetrievalForValidationFailed$str() {
        return elasticsearchMappingRetrievalForValidationFailed;
    }

    @Override
    public final SearchException elasticsearchMappingRetrievalForValidationFailed(Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchMappingRetrievalForValidationFailed$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String schemaUpdateFailed$str() {
        return schemaUpdateFailed;
    }

    @Override
    public final SearchException schemaUpdateFailed(Object indexName, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.schemaUpdateFailed$str(), indexName), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldIsBothCompositeAndConcrete$str() {
        return fieldIsBothCompositeAndConcrete;
    }

    @Override
    public final SearchException fieldIsBothCompositeAndConcrete(IndexedTypeIdentifier entityType, String fieldPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fieldIsBothCompositeAndConcrete$str(), new IndexedTypeIdentifierFormatter(entityType), fieldPath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForPeriod$str() {
        return invalidNullMarkerForPeriod;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForPeriod(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForPeriod$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForDuration$str() {
        return invalidNullMarkerForDuration;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForDuration(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForDuration$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForInstant$str() {
        return invalidNullMarkerForInstant;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForInstant(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForInstant$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForLocalDateTime$str() {
        return invalidNullMarkerForLocalDateTime;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForLocalDateTime(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForLocalDateTime$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForLocalDate$str() {
        return invalidNullMarkerForLocalDate;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForLocalDate(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForLocalDate$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForLocalTime$str() {
        return invalidNullMarkerForLocalTime;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForLocalTime(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForLocalTime$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForOffsetDateTime$str() {
        return invalidNullMarkerForOffsetDateTime;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForOffsetDateTime(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForOffsetDateTime$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForOffsetTime$str() {
        return invalidNullMarkerForOffsetTime;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForOffsetTime(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForOffsetTime$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForZonedDateTime$str() {
        return invalidNullMarkerForZonedDateTime;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForZonedDateTime(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForZonedDateTime$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForZonedTime$str() {
        return invalidNullMarkerForZonedTime;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForZonedTime(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForZonedTime$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForYear$str() {
        return invalidNullMarkerForYear;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForYear(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForYear$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForYearMonth$str() {
        return invalidNullMarkerForYearMonth;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForYearMonth(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForYearMonth$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullMarkerForMonthDay$str() {
        return invalidNullMarkerForMonthDay;
    }

    @Override
    public final IllegalArgumentException invalidNullMarkerForMonthDay(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullMarkerForMonthDay$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexMissing$str() {
        return indexMissing;
    }

    @Override
    public final SearchException indexMissing(Object indexName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexMissing$str(), indexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedSearchAPIPayloadAttributes$str() {
        return unsupportedSearchAPIPayloadAttributes;
    }

    @Override
    public final SearchException unsupportedSearchAPIPayloadAttributes(List<String> invalidAttributes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedSearchAPIPayloadAttributes$str(), invalidAttributes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSearchAPIPayload$str() {
        return invalidSearchAPIPayload;
    }

    @Override
    public final SearchException invalidSearchAPIPayload(Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSearchAPIPayload$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void executingElasticsearchQuery(String path, Map<String, String> parameters, String bodyParts) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.executingElasticsearchQuery$str(), (Object)path, parameters, (Object)bodyParts);
    }

    protected String executingElasticsearchQuery$str() {
        return executingElasticsearchQuery;
    }

    protected String indexedEmbeddedPrefixBypass$str() {
        return indexedEmbeddedPrefixBypass;
    }

    @Override
    public final SearchException indexedEmbeddedPrefixBypass(IndexedTypeIdentifier entityType, String fieldPath, String expectedParent) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexedEmbeddedPrefixBypass$str(), new IndexedTypeIdentifierFormatter(entityType), fieldPath, expectedParent));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tokenizerNamingConflict$str() {
        return tokenizerNamingConflict;
    }

    @Override
    public final SearchException tokenizerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tokenizerNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String charFilterNamingConflict$str() {
        return charFilterNamingConflict;
    }

    @Override
    public final SearchException charFilterNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.charFilterNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tokenFilterNamingConflict$str() {
        return tokenFilterNamingConflict;
    }

    @Override
    public final SearchException tokenFilterNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tokenFilterNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedCharFilterFactory$str() {
        return unsupportedCharFilterFactory;
    }

    @Override
    public final SearchException unsupportedCharFilterFactory(Class<?> factoryType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedCharFilterFactory$str(), new ClassFormatter(factoryType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedTokenizerFactory$str() {
        return unsupportedTokenizerFactory;
    }

    @Override
    public final SearchException unsupportedTokenizerFactory(Class<?> factoryType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedTokenizerFactory$str(), new ClassFormatter(factoryType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedTokenFilterFactory$str() {
        return unsupportedTokenFilterFactory;
    }

    @Override
    public final SearchException unsupportedTokenFilterFactory(Class<?> factoryType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedTokenFilterFactory$str(), new ClassFormatter(factoryType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedAnalysisFactoryParameter$str() {
        return unsupportedAnalysisFactoryParameter;
    }

    @Override
    public final SearchException unsupportedAnalysisFactoryParameter(Class<?> factoryType, String parameter) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedAnalysisFactoryParameter$str(), new ClassFormatter(factoryType), parameter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedAnalysisFactoryTokenizerClassNameParameter$str() {
        return unsupportedAnalysisFactoryTokenizerClassNameParameter;
    }

    @Override
    public final SearchException unsupportedAnalysisFactoryTokenizerClassNameParameter(Class<?> factoryClass, String parameterName, String tokenizerClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedAnalysisFactoryTokenizerClassNameParameter$str(), new ClassFormatter(factoryClass), parameterName, tokenizerClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedAnalysisDefinitionParameterValue$str() {
        return unsupportedAnalysisDefinitionParameterValue;
    }

    @Override
    public final SearchException unsupportedAnalysisDefinitionParameterValue(Class<?> factoryClass, String parameterName, String parameterValue) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedAnalysisDefinitionParameterValue$str(), new ClassFormatter(factoryClass), parameterName, parameterValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedAnalyzerImplementation$str() {
        return unsupportedAnalyzerImplementation;
    }

    @Override
    public final SearchException unsupportedAnalyzerImplementation(Class<?> luceneClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedAnalyzerImplementation$str(), new ClassFormatter(luceneClass)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAnalysisDefinitionJsonStringParameter$str() {
        return invalidAnalysisDefinitionJsonStringParameter;
    }

    @Override
    public final SearchException invalidAnalysisDefinitionJsonStringParameter(Class<?> factoryClass, String parameterName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAnalysisDefinitionJsonStringParameter$str(), new ClassFormatter(factoryClass), parameterName, causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAnalysisDefinitionJsonParameter$str() {
        return invalidAnalysisDefinitionJsonParameter;
    }

    @Override
    public final SearchException invalidAnalysisDefinitionJsonParameter(Class<?> factoryClass, String parameterName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAnalysisDefinitionJsonParameter$str(), new ClassFormatter(factoryClass), parameterName, causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchSettingsUpdateFailed$str() {
        return elasticsearchSettingsUpdateFailed;
    }

    @Override
    public final SearchException elasticsearchSettingsUpdateFailed(Object indexName, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchSettingsUpdateFailed$str(), indexName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchIndexSettingsRetrievalForValidationFailed$str() {
        return elasticsearchIndexSettingsRetrievalForValidationFailed;
    }

    @Override
    public final SearchException elasticsearchIndexSettingsRetrievalForValidationFailed(Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchIndexSettingsRetrievalForValidationFailed$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void closedIndex(Object indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.closedIndex$str(), indexName);
    }

    protected String closedIndex$str() {
        return closedIndex;
    }

    @Override
    public final void openedIndex(Object indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.openedIndex$str(), indexName);
    }

    protected String openedIndex$str() {
        return openedIndex;
    }

    @Override
    public final void failedToOpenIndex(Object indexName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failedToOpenIndex$str(), indexName);
    }

    protected String failedToOpenIndex$str() {
        return failedToOpenIndex;
    }

    protected String elasticsearch2RequestDeleteByQueryNotFound$str() {
        return elasticsearch2RequestDeleteByQueryNotFound;
    }

    @Override
    public final SearchException elasticsearch2RequestDeleteByQueryNotFound() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearch2RequestDeleteByQueryNotFound$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void usingPasswordOverHttp(String serverUris) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingPasswordOverHttp$str(), (Object)serverUris);
    }

    protected String usingPasswordOverHttp$str() {
        return usingPasswordOverHttp;
    }

    protected String analyzerNamingConflict$str() {
        return analyzerNamingConflict;
    }

    @Override
    public final SearchException analyzerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analyzerNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchAnalyzerDefinitionProvider$str() {
        return invalidElasticsearchAnalyzerDefinitionProvider;
    }

    @Override
    public final SearchException invalidElasticsearchAnalyzerDefinitionProvider(String providerClassName, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchAnalyzerDefinitionProvider$str(), providerClassName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchAnalyzerDefinition$str() {
        return invalidElasticsearchAnalyzerDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchAnalyzerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchAnalyzerDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchTokenizerDefinition$str() {
        return invalidElasticsearchTokenizerDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchTokenizerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTokenizerDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchCharFilterDefinition$str() {
        return invalidElasticsearchCharFilterDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchCharFilterDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchCharFilterDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElasticsearchTokenFilterDefinition$str() {
        return invalidElasticsearchTokenFilterDefinition;
    }

    @Override
    public final SearchException invalidElasticsearchTokenFilterDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTokenFilterDefinition$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToDetectElasticsearchVersion$str() {
        return failedToDetectElasticsearchVersion;
    }

    @Override
    public final SearchException failedToDetectElasticsearchVersion(Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToDetectElasticsearchVersion$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedElasticsearchVersion$str() {
        return unsupportedElasticsearchVersion;
    }

    @Override
    public final SearchException unsupportedElasticsearchVersion(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedElasticsearchVersion$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void executedRequest(String method, String path, Map<String, String> getParameters, long timeInMs, int responseStatusCode, String responseStatusMessage) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.executedRequest6$str(), new Object[]{method, path, getParameters, timeInMs, responseStatusCode, responseStatusMessage});
    }

    protected String executedRequest6$str() {
        return executedRequest6;
    }

    protected String unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzersForSimpleQueryStringQueries$str() {
        return unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzersForSimpleQueryStringQueries;
    }

    @Override
    public final SearchException unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzersForSimpleQueryStringQueries(Collection<String> analyzers) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzersForSimpleQueryStringQueries$str(), analyzers));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAnalysisFactoryParameter$str() {
        return invalidAnalysisFactoryParameter;
    }

    @Override
    public final SearchException invalidAnalysisFactoryParameter(Class<?> factoryType, String parameter, String expectedValue, String actualValue) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAnalysisFactoryParameter$str(), new ClassFormatter(factoryType), parameter, expectedValue, actualValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unexpectedElasticsearchVersion(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unexpectedElasticsearchVersion$str(), (Object)name);
    }

    protected String unexpectedElasticsearchVersion$str() {
        return unexpectedElasticsearchVersion;
    }

    protected String normalizerNamingConflict$str() {
        return normalizerNamingConflict;
    }

    @Override
    public final SearchException normalizerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.normalizerNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String analyzerNormalizerNamingConflict$str() {
        return analyzerNormalizerNamingConflict;
    }

    @Override
    public final SearchException analyzerNormalizerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analyzerNormalizerNamingConflict$str(), remoteName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotUseNormalizerImpl$str() {
        return cannotUseNormalizerImpl;
    }

    @Override
    public final SearchException cannotUseNormalizerImpl(Class<?> analyzerType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseNormalizerImpl$str(), new ClassFormatter(analyzerType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToParseElasticsearchResponse$str() {
        return failedToParseElasticsearchResponse;
    }

    @Override
    public final SearchException failedToParseElasticsearchResponse(int statusCode, String statusPhrase, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToParseElasticsearchResponse$str(), statusCode, statusPhrase), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String elasticsearchResponseIndicatesFailure$str() {
        return elasticsearchResponseIndicatesFailure;
    }

    @Override
    public final SearchException elasticsearchResponseIndicatesFailure() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchResponseIndicatesFailure$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String threadInterruptedWhileSubmittingChangeset$str() {
        return threadInterruptedWhileSubmittingChangeset;
    }

    @Override
    public final SearchException threadInterruptedWhileSubmittingChangeset(String orchestratorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.threadInterruptedWhileSubmittingChangeset$str(), orchestratorName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String orchestratorShutDownBeforeSubmittingChangeset$str() {
        return orchestratorShutDownBeforeSubmittingChangeset;
    }

    @Override
    public final SearchException orchestratorShutDownBeforeSubmittingChangeset(String orchestratorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.orchestratorShutDownBeforeSubmittingChangeset$str(), orchestratorName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void executedRequest(String method, String path, Map<String, String> getParameters, long timeInMs, int responseStatusCode, String responseStatusMessage, String requestBodyParts, String responseBody) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.executedRequest8$str(), new Object[]{method, path, getParameters, timeInMs, responseStatusCode, responseStatusMessage, requestBodyParts, responseBody});
    }

    protected String executedRequest8$str() {
        return executedRequest8;
    }

    public final void interruptedWhileWaitingForIndexActivity(String arg0, InterruptedException arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg1, this.interruptedWhileWaitingForIndexActivity$str(), (Object)arg0);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }

    public final void illegalObjectRetrievedFromMessage(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg0, this.illegalObjectRetrievedFromMessage$str(), new Object[0]);
    }

    protected String illegalObjectRetrievedFromMessage$str() {
        return illegalObjectRetrievedFromMessage;
    }

    protected String unableToLoadResource$str() {
        return unableToLoadResource;
    }

    public final SearchException unableToLoadResource(String arg0) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToLoadResource$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownResolution$str() {
        return unknownResolution;
    }

    public final AssertionFailure unknownResolution(String arg0) {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.unknownResolution$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedFacetRangeParameter$str() {
        return unsupportedFacetRangeParameter;
    }

    public final SearchException unsupportedFacetRangeParameter(String arg0) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedFacetRangeParameter$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String projectingFieldWithoutTwoWayFieldBridge$str() {
        return projectingFieldWithoutTwoWayFieldBridge;
    }

    public final SearchException projectingFieldWithoutTwoWayFieldBridge(String arg0, Class<?> arg1) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectingFieldWithoutTwoWayFieldBridge$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedNullTokenType$str() {
        return unsupportedNullTokenType;
    }

    public final SearchException unsupportedNullTokenType(IndexedTypeIdentifier arg0, String arg1, Class<?> arg2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedNullTokenType$str(), new IndexedTypeIdentifierFormatter(arg0), arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidLuceneAnalyzerDefinitionProvider$str() {
        return invalidLuceneAnalyzerDefinitionProvider;
    }

    public final SearchException invalidLuceneAnalyzerDefinitionProvider(String arg0, Exception arg1) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLuceneAnalyzerDefinitionProvider$str(), arg0), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

