/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.server.hotrod.BaseRequestProcessor;
import org.infinispan.server.hotrod.BulkGetKeysResponse;
import org.infinispan.server.hotrod.BulkGetResponse;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.ClientListenerRegistry;
import org.infinispan.server.hotrod.ClientListenerRequestContext;
import org.infinispan.server.hotrod.EmptyResponse;
import org.infinispan.server.hotrod.GetAllResponse;
import org.infinispan.server.hotrod.GetStreamResponse;
import org.infinispan.server.hotrod.GetWithMetadataResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.IterationNextResponse;
import org.infinispan.server.hotrod.IterationStartRequest;
import org.infinispan.server.hotrod.IterationStartResponse;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.QueryResponse;
import org.infinispan.server.hotrod.SecurityActions;
import org.infinispan.server.hotrod.SizeResponse;
import org.infinispan.server.hotrod.iteration.IterableIterationResult;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.KeyValuePair;

@Listener
class CacheRequestProcessor
extends BaseRequestProcessor {
    private static final Log log = (Log)LogFactory.getLog(CacheRequestProcessor.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final Flag[] LOCAL_NON_BLOCKING_GET = new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD};
    private static final Flag[] SKIP_STATISTICS = new Flag[]{Flag.SKIP_STATISTICS};
    private final HotRodServer server;
    private final ClientListenerRegistry listenerRegistry;
    private final Map<String, CacheInfo> cacheInfo = new ConcurrentHashMap<String, CacheInfo>();

    CacheRequestProcessor(Channel channel, Executor executor, HotRodServer server) {
        super(channel, executor);
        this.server = server;
        this.listenerRegistry = server.getClientListenerRegistry();
        SecurityActions.addListener(server.getCacheManager(), this);
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        this.cacheInfo.remove(event.getCacheName());
    }

    private CacheInfo getCacheInfo(CacheDecodeContext cdc) {
        AdvancedCache<byte[], byte[]> cache = cdc.cache();
        CacheInfo info = this.cacheInfo.get(cache.getName());
        if (info == null) {
            AdvancedCache localNonBlocking = SecurityActions.anonymizeSecureCache(cache).noFlags().withFlags(LOCAL_NON_BLOCKING_GET);
            if (cache.getStatus() != ComponentStatus.RUNNING) {
                return new CacheInfo(localNonBlocking, true, true);
            }
            ComponentRegistry cr = SecurityActions.getCacheComponentRegistry(cache);
            PersistenceManager pm = (PersistenceManager)cr.getComponent(PersistenceManager.class);
            boolean hasIndexing = SecurityActions.getCacheConfiguration(cache).indexing().index().isEnabled();
            info = new CacheInfo(localNonBlocking, pm.isEnabled(), hasIndexing);
            this.cacheInfo.put(cache.getName(), info);
        }
        return info;
    }

    private boolean isBlockingRead(CacheDecodeContext cdc, CacheInfo info) {
        return info.persistence && !cdc.decoder.isSkipCacheLoad(cdc.header);
    }

    private boolean isBlockingWrite(CacheDecodeContext cdc) {
        CacheInfo info = this.getCacheInfo(cdc);
        return info.persistence || info.indexing && !cdc.decoder.isSkipIndexing(cdc.header);
    }

    void get(CacheDecodeContext cdc) {
        CacheInfo info = this.getCacheInfo(cdc);
        CacheEntry entry = info.localNonBlocking(cdc.subject).getCacheEntry((Object)cdc.key);
        if (entry != null) {
            this.handleGet(cdc, (CacheEntry<byte[], byte[]>)entry, null);
        } else if (this.isBlockingRead(cdc, info)) {
            this.executor.execute(() -> this.getInternal(cdc));
        } else {
            this.getInternal(cdc);
        }
    }

    private void getInternal(CacheDecodeContext cdc) {
        cdc.cache().withFlags(SKIP_STATISTICS).getCacheEntryAsync((Object)cdc.key).whenComplete((result, throwable) -> this.handleGet(cdc, (CacheEntry<byte[], byte[]>)result, (Throwable)throwable));
    }

    private void handleGet(CacheDecodeContext cdc, CacheEntry<byte[], byte[]> result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else {
            try {
                this.writeResponse(cdc.decoder.createGetResponse(cdc.header, result));
            }
            catch (Throwable t2) {
                this.writeException(cdc, t2);
            }
        }
    }

    void getKeyMetadata(CacheDecodeContext cdc) {
        CacheInfo info = this.getCacheInfo(cdc);
        CacheEntry entry = info.localNonBlocking(cdc.subject).getCacheEntry((Object)cdc.key);
        if (entry != null) {
            this.handleGetKeyMetadata(cdc, (CacheEntry<byte[], byte[]>)entry, null);
        } else if (this.isBlockingRead(cdc, info)) {
            this.executor.execute(() -> this.getKeyMetadataInternal(cdc));
        } else {
            this.getKeyMetadataInternal(cdc);
        }
    }

    private void getKeyMetadataInternal(CacheDecodeContext cdc) {
        cdc.cache().withFlags(SKIP_STATISTICS).getCacheEntryAsync((Object)cdc.key).whenComplete((ce, throwable) -> this.handleGetKeyMetadata(cdc, (CacheEntry<byte[], byte[]>)ce, (Throwable)throwable));
    }

    private void handleGetKeyMetadata(CacheDecodeContext cdc, CacheEntry<byte[], byte[]> ce, Throwable throwable) {
        OperationStatus status;
        if (throwable != null) {
            this.writeException(cdc, throwable);
            return;
        }
        OperationStatus operationStatus = status = ce == null ? OperationStatus.KeyDoesNotExist : OperationStatus.Success;
        if (cdc.header.op == HotRodOperation.GET_WITH_METADATA) {
            this.writeResponse(new GetWithMetadataResponse(cdc.header.version, cdc.header.messageId, cdc.header.cacheName, cdc.header.clientIntel, cdc.header.op, status, cdc.header.topologyId, ce));
        } else {
            int offset = ce == null ? 0 : (Integer)cdc.operationDecodeContext;
            this.writeResponse(new GetStreamResponse(cdc.header.version, cdc.header.messageId, cdc.header.cacheName, cdc.header.clientIntel, cdc.header.op, status, cdc.header.topologyId, offset, ce));
        }
    }

    void containsKey(CacheDecodeContext cdc) {
        CacheInfo info = this.getCacheInfo(cdc);
        boolean contains = info.localNonBlocking(cdc.subject).containsKey((Object)cdc.key);
        if (contains) {
            this.writeSuccess(cdc, null);
        } else if (this.isBlockingRead(cdc, info)) {
            this.executor.execute(() -> this.containsKeyInternal(cdc));
        } else {
            this.containsKeyInternal(cdc);
        }
    }

    private void containsKeyInternal(CacheDecodeContext cdc) {
        cdc.cache().withFlags(SKIP_STATISTICS).containsKeyAsync((Object)cdc.key).whenComplete((result, throwable) -> this.handleContainsKey(cdc, (Boolean)result, (Throwable)throwable));
    }

    private void handleContainsKey(CacheDecodeContext cdc, Boolean result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else if (result.booleanValue()) {
            this.writeSuccess(cdc, null);
        } else {
            this.writeNotExist(cdc);
        }
    }

    void put(CacheDecodeContext cdc) {
        if (this.isBlockingWrite(cdc)) {
            this.executor.execute(() -> this.putInternal(cdc));
        } else {
            this.putInternal(cdc);
        }
    }

    private void putInternal(CacheDecodeContext cdc) {
        cdc.cache().putAsync((Object)cdc.key, (Object)((byte[])cdc.operationDecodeContext), cdc.buildMetadata()).whenComplete((result, throwable) -> this.handlePut(cdc, (byte[])result, (Throwable)throwable));
    }

    private void handlePut(CacheDecodeContext cdc, byte[] result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else {
            this.writeSuccess(cdc, result);
        }
    }

    void replaceIfUnmodified(CacheDecodeContext cdc) {
        if (this.isBlockingWrite(cdc)) {
            this.executor.execute(() -> this.replaceIfUnmodifiedInternal(cdc));
        } else {
            this.replaceIfUnmodifiedInternal(cdc);
        }
    }

    private void replaceIfUnmodifiedInternal(CacheDecodeContext cdc) {
        cdc.cache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).getCacheEntryAsync((Object)cdc.key).whenComplete((entry, throwable) -> this.handleGetForReplaceIfUnmodified(cdc, (CacheEntry<byte[], byte[]>)entry, (Throwable)throwable));
    }

    private void handleGetForReplaceIfUnmodified(CacheDecodeContext cdc, CacheEntry<byte[], byte[]> entry, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else if (entry != null) {
            byte[] prev = (byte[])entry.getValue();
            NumericVersion streamVersion = new NumericVersion(cdc.params.streamVersion);
            if (entry.getMetadata().version().equals(streamVersion)) {
                cdc.cache().replaceAsync((Object)cdc.key, (Object)prev, (Object)((byte[])cdc.operationDecodeContext), cdc.buildMetadata()).whenComplete((replaced, throwable2) -> {
                    if (throwable2 != null) {
                        this.writeException(cdc, (Throwable)throwable2);
                    } else if (replaced.booleanValue()) {
                        this.writeSuccess(cdc, prev);
                    } else {
                        this.writeNotExecuted(cdc, prev);
                    }
                });
            } else {
                this.writeNotExecuted(cdc, prev);
            }
        } else {
            this.writeNotExist(cdc);
        }
    }

    void replace(CacheDecodeContext cdc) {
        if (this.isBlockingWrite(cdc)) {
            this.executor.execute(() -> this.replaceInternal(cdc));
        } else {
            this.replaceInternal(cdc);
        }
    }

    private void replaceInternal(CacheDecodeContext cdc) {
        cdc.cache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).getAsync((Object)cdc.key).whenComplete((prev, throwable) -> this.handleGetForReplace(cdc, (byte[])prev, (Throwable)throwable));
    }

    private void handleGetForReplace(CacheDecodeContext cdc, byte[] prev, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else if (prev != null) {
            cdc.cache().replaceAsync((Object)cdc.key, (Object)((byte[])cdc.operationDecodeContext), cdc.buildMetadata()).whenComplete((result, throwable1) -> this.handleReplace(cdc, (byte[])result, (Throwable)throwable1));
        } else {
            this.writeNotExecuted(cdc, null);
        }
    }

    private void handleReplace(CacheDecodeContext cdc, byte[] result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else if (result != null) {
            this.writeSuccess(cdc, result);
        } else {
            this.writeNotExecuted(cdc, null);
        }
    }

    void putIfAbsent(CacheDecodeContext cdc) {
        if (this.isBlockingWrite(cdc)) {
            this.executor.execute(() -> this.putIfAbsent(cdc));
        } else {
            this.putIfAbsentInternal(cdc);
        }
    }

    private void putIfAbsentInternal(CacheDecodeContext cdc) {
        cdc.cache().getAsync((Object)cdc.key).whenComplete((prev, throwable) -> this.handleGetForPutIfAbsent(cdc, (byte[])prev, (Throwable)throwable));
    }

    private void handleGetForPutIfAbsent(CacheDecodeContext cdc, byte[] prev, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else if (prev == null) {
            cdc.cache().putIfAbsentAsync((Object)cdc.key, (Object)((byte[])cdc.operationDecodeContext), cdc.buildMetadata()).whenComplete((result, throwable1) -> this.handlePutIfAbsent(cdc, (byte[])result, (Throwable)throwable1));
        } else {
            this.writeNotExecuted(cdc, prev);
        }
    }

    private void handlePutIfAbsent(CacheDecodeContext cdc, byte[] result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else if (result == null) {
            this.writeSuccess(cdc, null);
        } else {
            this.writeNotExecuted(cdc, result);
        }
    }

    void remove(CacheDecodeContext cdc) {
        if (this.isBlockingWrite(cdc)) {
            this.executor.execute(() -> this.removeInternal(cdc));
        } else {
            this.removeInternal(cdc);
        }
    }

    private void removeInternal(CacheDecodeContext cdc) {
        cdc.cache().removeAsync((Object)cdc.key).whenComplete((prev, throwable) -> this.handleRemove(cdc, (byte[])prev, (Throwable)throwable));
    }

    private void handleRemove(CacheDecodeContext cdc, byte[] prev, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else if (prev != null) {
            this.writeSuccess(cdc, prev);
        } else {
            this.writeNotExist(cdc);
        }
    }

    void removeIfUnmodified(CacheDecodeContext cdc) {
        if (this.isBlockingWrite(cdc)) {
            this.executor.execute(() -> this.removeIfUnmodifiedInternal(cdc));
        } else {
            this.removeIfUnmodifiedInternal(cdc);
        }
    }

    private void removeIfUnmodifiedInternal(CacheDecodeContext cdc) {
        cdc.cache().getCacheEntryAsync((Object)cdc.key).whenComplete((entry, throwable) -> this.handleGetForRemoveIfUnmodified(cdc, (CacheEntry<byte[], byte[]>)entry, (Throwable)throwable));
    }

    private void handleGetForRemoveIfUnmodified(CacheDecodeContext cdc, CacheEntry<byte[], byte[]> entry, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else if (entry != null) {
            byte[] prev = (byte[])entry.getValue();
            NumericVersion streamVersion = new NumericVersion(cdc.params.streamVersion);
            if (entry.getMetadata().version().equals(streamVersion)) {
                cdc.cache().removeAsync((Object)cdc.key, (Object)prev).whenComplete((removed, throwable2) -> {
                    if (throwable2 != null) {
                        this.writeException(cdc, (Throwable)throwable2);
                    } else if (removed.booleanValue()) {
                        this.writeSuccess(cdc, prev);
                    } else {
                        this.writeNotExecuted(cdc, prev);
                    }
                });
            } else {
                this.writeNotExecuted(cdc, prev);
            }
        } else {
            this.writeNotExist(cdc);
        }
    }

    void clear(CacheDecodeContext cdc) {
        if (this.isBlockingWrite(cdc)) {
            this.executor.execute(() -> this.clearInternal(cdc));
        } else {
            this.clearInternal(cdc);
        }
    }

    private void clearInternal(CacheDecodeContext cdc) {
        cdc.cache().clearAsync().whenComplete((nil, throwable) -> {
            if (throwable != null) {
                this.writeException(cdc, (Throwable)throwable);
            } else {
                this.writeSuccess(cdc, null);
            }
        });
    }

    void putAll(CacheDecodeContext cdc) {
        if (this.isBlockingWrite(cdc)) {
            this.executor.execute(() -> this.putAllInternal(cdc));
        } else {
            this.putAllInternal(cdc);
        }
    }

    private void putAllInternal(CacheDecodeContext cdc) {
        cdc.cache().putAllAsync((Map)cdc.operationContext(), cdc.buildMetadata()).whenComplete((nil, throwable) -> this.handlePutAll(cdc, (Throwable)throwable));
    }

    private void handlePutAll(CacheDecodeContext cdc, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else {
            this.writeSuccess(cdc, null);
        }
    }

    void getAll(CacheDecodeContext cdc) {
        if (this.isBlockingRead(cdc, this.getCacheInfo(cdc))) {
            this.executor.execute(() -> this.getAllInternal(cdc));
        } else {
            this.getAllInternal(cdc);
        }
    }

    private void getAllInternal(CacheDecodeContext cdc) {
        cdc.cache().getAllAsync((Set)cdc.operationContext()).whenComplete((map, throwable) -> this.handleGetAll(cdc, (Map<byte[], byte[]>)map, (Throwable)throwable));
    }

    private void handleGetAll(CacheDecodeContext cdc, Map<byte[], byte[]> map, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else {
            this.writeResponse(new GetAllResponse(cdc.header.version, cdc.header.messageId, cdc.header.cacheName, cdc.header.clientIntel, cdc.header.topologyId, map));
        }
    }

    void size(CacheDecodeContext cdc) {
        this.executor.execute(() -> this.sizeInternal(cdc));
    }

    private void sizeInternal(CacheDecodeContext cdc) {
        HotRodHeader h = cdc.header;
        try {
            AdvancedCache<byte[], byte[]> cache = cdc.cache();
            this.writeResponse(new SizeResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, cache.size()));
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    void bulkGet(CacheDecodeContext cdc) {
        this.executor.execute(() -> this.bulkGetInternal(cdc));
    }

    private void bulkGetInternal(CacheDecodeContext cdc) {
        try {
            AdvancedCache<byte[], byte[]> cache = cdc.cache();
            int size = (Integer)cdc.operationDecodeContext;
            if (trace) {
                log.tracef("About to create bulk response count = %d", size);
            }
            HotRodHeader h = cdc.header;
            this.writeResponse(new BulkGetResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, size, (CacheSet<Map.Entry<byte[], byte[]>>)cache.entrySet()));
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    public void bulkGetKeys(CacheDecodeContext cdc) {
        this.executor.execute(() -> this.bulkGetKeysInternal(cdc));
    }

    private void bulkGetKeysInternal(CacheDecodeContext cdc) {
        try {
            int scope = (Integer)cdc.operationDecodeContext;
            if (trace) {
                log.tracef("About to create bulk get keys response scope = %d", scope);
            }
            HotRodHeader h = cdc.header;
            this.writeResponse(new BulkGetKeysResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, scope, (Iterator<byte[]>)cdc.cache().keySet().iterator()));
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    void query(CacheDecodeContext cdc) {
        this.executor.execute(() -> this.queryInternal(cdc));
    }

    private void queryInternal(CacheDecodeContext cdc) {
        try {
            byte[] queryResult = this.server.query(cdc.cache(), (byte[])cdc.operationDecodeContext);
            HotRodHeader h = cdc.header;
            this.writeResponse(new QueryResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, queryResult));
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    void addClientListener(CacheDecodeContext cdc) {
        this.executor.execute(() -> this.addClientListenerInternal(cdc));
    }

    private void addClientListenerInternal(CacheDecodeContext cdc) {
        try {
            ClientListenerRequestContext clientContext = (ClientListenerRequestContext)cdc.operationDecodeContext;
            this.listenerRegistry.addClientListener(cdc.decoder, this.channel, cdc.header, clientContext.getListenerId(), cdc.cache(), clientContext.isIncludeCurrentState(), (KeyValuePair<Optional<KeyValuePair<String, List<byte[]>>>, Optional<KeyValuePair<String, List<byte[]>>>>)new KeyValuePair(clientContext.getFilterFactoryInfo(), clientContext.getConverterFactoryInfo()), clientContext.isUseRawData(), clientContext.getListenerInterests());
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    void removeClientListener(CacheDecodeContext cdc) {
        this.executor.execute(() -> this.removeClientListenerInternal(cdc));
    }

    private void removeClientListenerInternal(CacheDecodeContext cdc) {
        try {
            byte[] listenerId = (byte[])cdc.operationDecodeContext;
            if (this.server.getClientListenerRegistry().removeClientListener(listenerId, (Cache)cdc.cache())) {
                this.writeResponse(cdc.decoder.createSuccessResponse(cdc.header, null));
            } else {
                this.writeResponse(cdc.decoder.createNotExecutedResponse(cdc.header, null));
            }
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    void iterationStart(CacheDecodeContext cdc) {
        this.executor.execute(() -> this.iterationStartInternal(cdc));
    }

    private void iterationStartInternal(CacheDecodeContext cdc) {
        try {
            IterationStartRequest iterationStart = (IterationStartRequest)cdc.operationDecodeContext;
            Optional<BitSet> optionBitSet = iterationStart.getOptionBitSet().isPresent() ? Optional.of(BitSet.valueOf(iterationStart.getOptionBitSet().get())) : Optional.empty();
            String iterationId = this.server.getIterationManager().start((Cache)cdc.cache(), optionBitSet, iterationStart.getFactory(), iterationStart.getBatch(), iterationStart.isMetadata());
            HotRodHeader h = cdc.header;
            this.writeResponse(new IterationStartResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, iterationId));
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    void iterationNext(CacheDecodeContext cdc) {
        this.executor.execute(() -> this.iterationNextInternal(cdc));
    }

    private void iterationNextInternal(CacheDecodeContext cdc) {
        try {
            String iterationId = (String)cdc.operationDecodeContext;
            IterableIterationResult iterationResult = this.server.getIterationManager().next(cdc.cache().getName(), iterationId);
            HotRodHeader h = cdc.header;
            this.writeResponse(new IterationNextResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, iterationResult));
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    void iterationEnd(CacheDecodeContext cdc) {
        this.executor.execute(() -> this.iterationEndInternal(cdc));
    }

    private void iterationEndInternal(CacheDecodeContext cdc) {
        try {
            String iterationId = (String)cdc.operationDecodeContext;
            boolean removed = this.server.getIterationManager().close(cdc.cache().getName(), iterationId);
            HotRodHeader h = cdc.header;
            this.writeResponse(new EmptyResponse(h.version, h.messageId, h.cacheName, h.clientIntel, HotRodOperation.ITERATION_END, removed ? OperationStatus.Success : OperationStatus.InvalidIteration, h.topologyId));
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putStream(CacheDecodeContext cdc) {
        ByteBuf buf = (ByteBuf)cdc.operationDecodeContext;
        try {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            cdc.operationDecodeContext = bytes;
            long version = cdc.params.streamVersion;
            if (version == 0L) {
                this.put(cdc);
            } else if (version < 0L) {
                this.putIfAbsent(cdc);
            } else {
                this.replaceIfUnmodified(cdc);
            }
        }
        finally {
            buf.release();
        }
    }

    private static class CacheInfo {
        final AdvancedCache<byte[], byte[]> localNonBlocking;
        final boolean persistence;
        final boolean indexing;

        private CacheInfo(AdvancedCache<byte[], byte[]> localNonBlocking, boolean persistence, boolean indexing) {
            this.localNonBlocking = localNonBlocking;
            this.persistence = persistence;
            this.indexing = indexing;
        }

        AdvancedCache<byte[], byte[]> localNonBlocking(Subject subject) {
            if (subject == null) {
                return this.localNonBlocking;
            }
            return this.localNonBlocking.withSubject(subject);
        }
    }
}

